/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.util;

import org.eclipse.jdt.core.tests.junit.extension.TestCase;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.junit.Test;

public class HashtableOfObjectTest
extends TestCase {
    public HashtableOfObjectTest(String name) {
        super(name);
    }

    @Test
    public void testCalculateNewSize() {
        int input = -2;
        try {
            HashtableOfObject.calculateNewSize((int)input);
            HashtableOfObjectTest.fail((String)("Should not accept " + input));
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
        input = Integer.MIN_VALUE;
        try {
            HashtableOfObject.calculateNewSize((int)input);
            HashtableOfObjectTest.fail((String)("Should not accept " + input));
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
        input = -1;
        try {
            HashtableOfObject.calculateNewSize((int)input);
            HashtableOfObjectTest.fail((String)("Should not accept " + input));
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
        HashtableOfObjectTest.assertEquals((int)1, (int)HashtableOfObject.calculateNewSize((int)0));
        HashtableOfObjectTest.assertEquals((int)2, (int)HashtableOfObject.calculateNewSize((int)1));
        input = 1073731822;
        int expected = input * 2;
        HashtableOfObjectTest.assertEquals((int)expected, (int)HashtableOfObject.calculateNewSize((int)input));
        input = 0x3FFFFFFD;
        expected = input * 2;
        HashtableOfObjectTest.assertEquals((int)expected, (int)HashtableOfObject.calculateNewSize((int)input));
        input = 0x3FFFFFFE;
        expected = input + (0x7FFFFFFD - input) / 2;
        HashtableOfObjectTest.assertEquals((int)expected, (int)HashtableOfObject.calculateNewSize((int)input));
        input = 0x3FFFFFFF;
        expected = input + (0x7FFFFFFD - input) / 2;
        HashtableOfObjectTest.assertEquals((int)expected, (int)HashtableOfObject.calculateNewSize((int)input));
        input = 1073751822;
        expected = input + (0x7FFFFFFD - input) / 2;
        HashtableOfObjectTest.assertEquals((int)expected, (int)HashtableOfObject.calculateNewSize((int)input));
        input = 0x7FFFFFF9;
        expected = input + (0x7FFFFFFD - input) / 2;
        HashtableOfObjectTest.assertEquals((int)expected, (int)HashtableOfObject.calculateNewSize((int)input));
        input = 0x7FFFFFFA;
        expected = input + 1;
        HashtableOfObjectTest.assertEquals((int)expected, (int)HashtableOfObject.calculateNewSize((int)input));
        try {
            input = 0x7FFFFFFB;
            HashtableOfObject.calculateNewSize((int)input);
            HashtableOfObjectTest.fail((String)("Should not support table size " + input));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            input = 0x7FFFFFFC;
            HashtableOfObject.calculateNewSize((int)input);
            HashtableOfObjectTest.fail((String)("Should not support table size " + input));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            input = 0x7FFFFFFD;
            HashtableOfObject.calculateNewSize((int)input);
            HashtableOfObjectTest.fail((String)("Should not support table size " + input));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            input = 0x7FFFFFFE;
            HashtableOfObject.calculateNewSize((int)input);
            HashtableOfObjectTest.fail((String)("Should not support table size " + input));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            input = Integer.MAX_VALUE;
            HashtableOfObject.calculateNewSize((int)input);
            HashtableOfObjectTest.fail((String)("Should not support table size " + input));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    @Test
    public void testCreateNewTable() {
        int input = Integer.MIN_VALUE;
        try {
            new HashtableOfObject(input);
            HashtableOfObjectTest.fail((String)("Should not accept " + input));
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
        input = -2;
        try {
            new HashtableOfObject(input);
            HashtableOfObjectTest.fail((String)("Should not accept " + input));
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
        input = -1;
        try {
            new HashtableOfObject(input);
            HashtableOfObjectTest.fail((String)("Should not accept " + input));
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
        input = -1;
        try {
            new HashtableOfObject(input);
            HashtableOfObjectTest.fail((String)("Should not accept " + input));
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
        HashtableOfObjectTest.assertEquals((int)1, (int)new HashtableOfObject(0).storageSize());
        HashtableOfObjectTest.assertEquals((int)2, (int)new HashtableOfObject(1).storageSize());
        HashtableOfObjectTest.assertEquals((int)3, (int)new HashtableOfObject(2).storageSize());
        try {
            input = 0x7FFFFFFB;
            new HashtableOfObject(input);
            HashtableOfObjectTest.fail((String)("Should support table size " + input));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            input = 0x7FFFFFFC;
            new HashtableOfObject(input);
            HashtableOfObjectTest.fail((String)("Should support table size " + input));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            input = 0x7FFFFFFD;
            new HashtableOfObject(input);
            HashtableOfObjectTest.fail((String)("Should not accept " + input));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            input = 0x7FFFFFFE;
            new HashtableOfObject(input);
            HashtableOfObjectTest.fail((String)("Should not accept " + input));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            input = Integer.MAX_VALUE;
            new HashtableOfObject(input);
            HashtableOfObjectTest.fail((String)("Should not accept " + input));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        if (Runtime.getRuntime().maxMemory() / 0x100000L < 31000L) {
            return;
        }
        input = 1227133511;
        int expected = input + (0x7FFFFFFD - input) / 2;
        HashtableOfObjectTest.assertEquals((int)expected, (int)new HashtableOfObject(input).storageSize());
        input = 0x7FFFFFF9;
        expected = input + (0x7FFFFFFD - input) / 2;
        HashtableOfObjectTest.assertEquals((int)expected, (int)new HashtableOfObject(input).storageSize());
        input = 0x7FFFFFFA;
        expected = input + 1;
        HashtableOfObjectTest.assertEquals((int)expected, (int)new HashtableOfObject(input).storageSize());
        System.gc();
    }
}

