/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.JrtFileSystem;
import org.junit.Before;
import org.junit.Test;

public class JrtUtilTest
extends TestCase {
    private String javaSpecVersion;
    private String javaHome;
    private File image;
    private String jdkRelease;

    public JrtUtilTest(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.javaSpecVersion = System.getProperty("java.specification.version", null);
        JrtUtilTest.assertNotNull((String)"java.specification.version is not defined", (Object)this.javaSpecVersion);
        this.javaHome = System.getProperty("java.home", null);
        JrtUtilTest.assertNotNull((String)"java.home is not defined", (Object)this.javaHome);
        this.image = Paths.get(this.javaHome, new String[0]).toFile();
        JrtUtilTest.assertTrue((String)"java.home points to invalid path", (boolean)this.image.isDirectory());
        this.jdkRelease = JRTUtil.getJdkRelease((File)this.image);
    }

    @Test
    public void testGetReleaseVersion() {
        long expectedLevel = CompilerOptions.versionToJdkLevel((String)this.javaSpecVersion);
        long seenLevel = CompilerOptions.versionToJdkLevel((String)this.jdkRelease);
        JrtUtilTest.assertEquals((String)("Unexpected version: " + this.jdkRelease + ", not matching " + this.javaSpecVersion), (long)expectedLevel, (long)seenLevel);
        int sameRelease = JavaCore.compareJavaVersions((String)this.javaSpecVersion, (String)this.jdkRelease);
        JrtUtilTest.assertEquals((String)("Unexpected version: " + this.jdkRelease + ", not matching " + this.javaSpecVersion), (int)sameRelease, (int)0);
    }

    @Test
    public void testGetNewJrtFileSystem() throws Exception {
        int majorVersionSegment = JrtUtilTest.getMajorVersionSegment(this.jdkRelease);
        JrtFileSystem jrtSystem = JRTUtil.getJrtSystem((File)this.image, null);
        JrtFileSystem jrtSystem2 = JRTUtil.getJrtSystem((File)this.image, (String)String.valueOf(majorVersionSegment));
        JrtUtilTest.assertSame((Object)jrtSystem, (Object)jrtSystem2);
        jrtSystem2 = JRTUtil.getJrtSystem((File)this.image, (String)String.valueOf(majorVersionSegment - 2));
        JrtUtilTest.assertNotSame((Object)jrtSystem, (Object)jrtSystem2);
        JrtFileSystem jrtSystem3 = JRTUtil.getJrtSystem((File)this.image, null);
        JrtUtilTest.assertSame((Object)jrtSystem, (Object)jrtSystem3);
    }

    @Test
    public void testWorksUnderInterruptCondition() throws IOException {
        FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
        try {
            Thread.currentThread().interrupt();
            JrtUtilTest.assertNotNull((Object)JRTUtil.safeReadBytes((Path)fs.getPath("modules", "java.base", "java/lang/Object.class")));
            JrtUtilTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
            JrtUtilTest.assertNull((Object)JRTUtil.safeReadBytes((Path)fs.getPath("xxxxxxxxx", new String[0])));
            JrtUtilTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    private static int getMajorVersionSegment(String releaseVersion) {
        int dot = releaseVersion.indexOf(46);
        if (dot > 0) {
            return Integer.parseInt(releaseVersion.substring(0, dot));
        }
        return Integer.parseInt(releaseVersion);
    }
}

