/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.core.tests.eval.EvaluationSetup;
import org.eclipse.jdt.core.tests.runtime.LocalVMLauncher;
import org.eclipse.jdt.core.tests.runtime.TargetException;
import org.eclipse.jdt.core.tests.runtime.TargetInterface;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.eval.EvaluationContext;
import org.junit.Assert;

public class DebugEvaluationSetup
extends EvaluationSetup {
    VirtualMachine vm;

    public DebugEvaluationSetup(long complianceLevel) {
        super(complianceLevel);
    }

    @Override
    protected void setUp() {
        if (this.context == null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (ServerSocket evalServer = new ServerSocket(0);){
                    LocalVMLauncher launcher;
                    int debugPort = Util.getFreePort();
                    int evalPort = evalServer.getLocalPort();
                    try {
                        launcher = LocalVMLauncher.getLauncher();
                        launcher.setVMPath(JRE_PATH);
                        launcher.setEvalPort(evalPort);
                        launcher.setEvalTargetPath(EVAL_DIRECTORY);
                        launcher.setDebugPort(debugPort);
                        this.launchedVM = launcher.launch();
                    }
                    catch (TargetException e) {
                        e.printStackTrace(System.out);
                        throw new Error(e.getMessage(), e);
                    }
                    try {
                        this.startReader("VM's stdout reader", this.launchedVM.getInputStream(), System.out);
                    }
                    catch (TargetException e) {
                        e.printStackTrace(System.out);
                    }
                    try {
                        this.startReader("VM's sterr reader", this.launchedVM.getErrorStream(), System.out);
                    }
                    catch (TargetException e) {
                        e.printStackTrace(System.out);
                    }
                    int attempts = 30;
                    Instant start = Instant.now();
                    int i = 0;
                    while (i < attempts) {
                        try {
                            VirtualMachineManager manager = Bootstrap.virtualMachineManager();
                            List<AttachingConnector> connectors = manager.attachingConnectors();
                            if (connectors.size() == 0) {
                                System.out.println(this.getName() + ": could not get attachingConnectors() from VM");
                                break;
                            }
                            AttachingConnector connector = connectors.get(0);
                            Map<String, Connector.Argument> args = connector.defaultArguments();
                            Connector.Argument argument = args.get("port");
                            if (argument != null) {
                                argument.setValue(String.valueOf(debugPort));
                            }
                            if ((argument = args.get("hostname")) != null) {
                                argument.setValue(launcher.getTargetAddress());
                            }
                            if ((argument = args.get("timeout")) != null) {
                                argument.setValue("30000");
                            }
                            this.vm = connector.attach(args);
                            System.out.println(this.getName() + ": connected to VM using port " + debugPort);
                            this.vm.resume();
                            break;
                        }
                        catch (IllegalConnectorArgumentsException | IOException e) {
                            e.printStackTrace(System.out);
                            try {
                                System.out.println(this.getName() + ": could not contact the VM at " + launcher.getTargetAddress() + ":" + debugPort + ". Retrying...");
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace(System.out);
                            }
                            ++i;
                        }
                    }
                    if (this.vm == null) {
                        Duration duration = Duration.between(start, Instant.now());
                        System.out.println(this.getName() + ": could NOT contact the VM at " + launcher.getTargetAddress() + ":" + debugPort + ". Stop trying after " + attempts + " attempts, took " + duration.getSeconds() + " seconds");
                        if (this.launchedVM != null) {
                            try {
                                if (!this.launchedVM.isRunning()) {
                                    int read;
                                    InputStream in = this.launchedVM.getErrorStream();
                                    do {
                                        if ((read = in.read()) == -1) continue;
                                        System.out.print((char)read);
                                    } while (read != -1);
                                }
                            }
                            catch (IOException | TargetException e) {
                                e.printStackTrace(System.out);
                            }
                            try {
                                if (this.target != null) {
                                    this.target.disconnect();
                                }
                                int retry = 0;
                                while (this.launchedVM.isRunning() && ++retry < 20) {
                                    try {
                                        Thread.sleep(retry * 100);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace(System.out);
                                    }
                                }
                                if (this.launchedVM.isRunning()) {
                                    this.launchedVM.shutDown();
                                }
                            }
                            catch (TargetException e) {
                                e.printStackTrace(System.out);
                            }
                        }
                        System.out.println(this.getName() + ": could not contact the VM at port " + debugPort);
                        return;
                    }
                    this.context = new EvaluationContext();
                    this.target = new TargetInterface();
                    this.target.connect(evalServer, 60000);
                    Assert.assertTrue((String)(this.getName() + ": failed to connect VM server"), (boolean)this.target.isConnected());
                    System.out.println(this.getName() + ": connected to target using port " + debugPort);
                    this.env = new FileSystem(Util.getJavaClassLibs(), new String[0], null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e1) {
                e1.printStackTrace(System.out);
                throw new Error(this.getName() + ": Failed to open socket", e1);
            }
        }
        super.setUp();
    }
}

