/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import com.sun.jdi.VirtualMachine;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.jdt.core.tests.eval.DebugEvaluationSetup;
import org.eclipse.jdt.core.tests.eval.EvaluationSetup;
import org.eclipse.jdt.core.tests.eval.EvaluationTest;
import org.eclipse.jdt.core.tests.eval.JDIStackFrame;
import org.eclipse.jdt.core.tests.runtime.TargetInterface;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.eval.EvaluationResult;
import org.eclipse.jdt.internal.eval.IRequestor;
import org.eclipse.jdt.internal.eval.InstallException;

public class DebugEvaluationTest
extends EvaluationTest {
    protected static final String SOURCE_DIRECTORY = Util.getOutputDirectory() + File.separator + "source";
    public JDIStackFrame jdiStackFrame;
    VirtualMachine jdiVM;

    public DebugEvaluationTest(String name) {
        super(name);
    }

    public static Test setupSuite(Class clazz) {
        ArrayList<Class> testClasses = new ArrayList<Class>();
        testClasses.add(clazz);
        return DebugEvaluationTest.buildAllCompliancesTestSuite(clazz, DebugEvaluationSetup.class, testClasses);
    }

    public static Test suite() {
        return DebugEvaluationTest.setupSuite(DebugEvaluationTest.testClass());
    }

    public static Class testClass() {
        return DebugEvaluationTest.class;
    }

    public void compileAndDeploy(String source, String className) {
        this.resetEnv();
        File directory = new File(SOURCE_DIRECTORY);
        if (!directory.exists() && !directory.mkdir()) {
            System.out.println("Could not create " + SOURCE_DIRECTORY);
            return;
        }
        String fileName = SOURCE_DIRECTORY + File.separator + className + ".java";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(source);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("\"").append(fileName).append("\" -d \"").append(EvaluationSetup.EVAL_DIRECTORY + File.separator + "regularPath").append("\" -nowarn -g -classpath \"").append(Util.getJavaClassLibsAsString()).append(SOURCE_DIRECTORY).append("\"");
        BatchCompiler.compile((String)buffer.toString(), (PrintWriter)new PrintWriter(System.out), (PrintWriter)new PrintWriter(System.err), null);
    }

    public void compileAndDeploy15(String source, String className) {
        this.resetEnv();
        File directory = new File(SOURCE_DIRECTORY);
        if (!directory.exists() && !directory.mkdir()) {
            System.out.println("Could not create " + SOURCE_DIRECTORY);
            return;
        }
        String fileName = SOURCE_DIRECTORY + File.separator + className + ".java";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(source);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("\"").append(fileName).append("\" -d \"").append(EvaluationSetup.EVAL_DIRECTORY + File.separator + "regularPath").append("\" -nowarn -" + CompilerOptions.getFirstSupportedJavaVersion() + " -g -classpath \"").append(Util.getJavaClassLibsAsString()).append(SOURCE_DIRECTORY).append("\"");
        BatchCompiler.compile((String)buffer.toString(), (PrintWriter)new PrintWriter(System.out), (PrintWriter)new PrintWriter(System.err), null);
    }

    private void evaluate(JDIStackFrame stackFrame, DebugRequestor requestor, char[] snippet) throws InstallException {
        this.context.evaluate(snippet, stackFrame.localVariableTypeNames(), stackFrame.localVariableNames(), stackFrame.localVariableModifiers(), stackFrame.declaringTypeName(), stackFrame.isStatic(), stackFrame.isConstructorCall(), this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
    }

    @Override
    public Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        return options;
    }

    @Override
    public void initialize(CompilerTestSetup setUp) {
        super.initialize(setUp);
        this.jdiVM = ((DebugEvaluationSetup)setUp).vm;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        DebugEvaluationTest.assertNotNull((String)"VM is null, probably VM connection error", (Object)this.jdiVM);
    }

    public void removeTempClass(String className) {
        this.resetEnv();
        Util.delete(SOURCE_DIRECTORY + File.separator + className + ".java");
        Util.delete(EvaluationSetup.EVAL_DIRECTORY + File.separator + "regularPath" + File.separator + className + ".class");
    }

    public void test001() throws Exception {
        String userCode = "";
        JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode);
        DebugRequestor requestor = new DebugRequestor();
        char[] snippet = "return 1;".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
        DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
        this.assertEquals("Value", "1".toCharArray(), result.getValueDisplayString());
        this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
    }

    public void test002() throws Exception {
        try {
            String sourceA002 = "public class A002 {\n  public int foo() {\n    return 2;\n  }\n  public String toString() {\n    return \"hello\";\n  }\n}";
            this.compileAndDeploy(sourceA002, "A002");
            String userCode = "new A002().foo();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A002", "foo", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return this;".toCharArray();
            this.context.evaluate(snippet, null, null, null, stackFrame.declaringTypeName(), stackFrame.isStatic(), stackFrame.isConstructorCall(), this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "hello".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "A002".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A002");
        }
    }

    public void test003() throws Exception {
        try {
            String sourceA003 = "public class A003 {\n  public int foo() {\n    return 2;\n  }\n  public String toString() {\n    return \"hello\";\n  }\n}";
            this.compileAndDeploy(sourceA003, "A003");
            String userCode = "new A003().foo();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A003", "foo", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return this;".toCharArray();
            this.context.evaluate(snippet, stackFrame.localVariableTypeNames(), stackFrame.localVariableNames(), stackFrame.localVariableModifiers(), null, stackFrame.isStatic(), stackFrame.isConstructorCall(), this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should have a problem", (boolean)result.hasProblems());
            DebugEvaluationTest.assertTrue((String)"Result should not have a value", (!result.hasValue() ? 1 : 0) != 0);
        }
        finally {
            this.removeTempClass("A003");
        }
    }

    public void test004() throws Exception {
        String userCode = "java.lang.Thread thread = new Thread() {\n  public String toString() {\n    return \"my thread\";\n  }\n};";
        JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode);
        DebugRequestor requestor = new DebugRequestor();
        char[] snippet = "return thread;".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
        DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
        this.assertEquals("Value", "my thread".toCharArray(), result.getValueDisplayString());
        this.assertEquals("Type", "java.lang.Thread".toCharArray(), result.getValueTypeName());
    }

    public void test005() throws Exception {
        try {
            String sourceA005 = "public class A005 {\n  public int x = 0;\n  public int foo() {\n    x++;\n    return x;\n  }\n}";
            this.compileAndDeploy(sourceA005, "A005");
            String userCode = "new A005().foo();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A005", "foo", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return x;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "0".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A005");
        }
    }

    public void test006() throws Exception {
        try {
            String sourceA006 = "public class A006 {\n  public int x = 0;\n  public int foo() {\n    x++;\n    return x;\n  }\n}";
            this.compileAndDeploy(sourceA006, "A006");
            String userCode = "new A006().foo();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A006", "foo", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return x + new Object(){ int foo(){ return 17; }}.foo();".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "17".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A006");
        }
    }

    public void test007() throws Exception {
        try {
            String sourceA007 = "public class A007 {\n  public static int X = 1;\n  public int foo() {\n    X++;\n    return X;\n  }\n}";
            this.compileAndDeploy(sourceA007, "A007");
            String userCode = "new A007().foo();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A007", "foo", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return X;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "1".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A007");
        }
    }

    public void test008() throws Exception {
        try {
            String sourceA008 = "public class A008 {\n  public int x = 0;\n  public int foo() {\n    x++;\n    return x;\n  }\n}";
            this.compileAndDeploy(sourceA008, "A008");
            String userCode = "new A008().foo();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A008", "foo", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return x + new Object(){ int foo(int x){ return x; }}.foo(14);".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "14".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A008");
        }
    }

    public void test009() throws Exception {
        String userCode = "String s = \"test009\";\n";
        JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode);
        DebugRequestor requestor = new DebugRequestor();
        char[] snippet = "s".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
        DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
        this.assertEquals("Value", "test009".toCharArray(), result.getValueDisplayString());
        this.assertEquals("Type", "java.lang.String".toCharArray(), result.getValueTypeName());
    }

    public void test010() throws Exception {
        try {
            String sourceA010 = "public class A010 {\n  public int foo() {\n    new Object().toString();\n    return -1;\n  }\n}";
            this.compileAndDeploy(sourceA010, "A010");
            String userCode = "A010 a = new A010() {\n  public String toString() {\n    return \"my object\";\n  }\n};\na.foo();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A010", "foo", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return this;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "my object".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "A010".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A010");
        }
    }

    public void test011() throws Exception {
        String userCode = "String s = \"s\";\njava.util.Vector v = new java.util.Vector();\nv.addElement(s);\n";
        JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode);
        DebugRequestor requestor = new DebugRequestor();
        char[] snippet = "return v;".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
        DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
        this.assertEquals("Value", "[s]".toCharArray(), result.getValueDisplayString());
        this.assertEquals("Type", "java.util.Vector".toCharArray(), result.getValueTypeName());
    }

    public void _test012() throws Exception {
        String userCode = "java.util.GregorianCalendar cal = new java.util.GregorianCalendar();\njava.util.Date date = cal.getGregorianChange();\nSystem.out.println(\"Old date =\t\" + date.toString());";
        JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode);
        DebugRequestor requestor = new DebugRequestor();
        char[] snippet = "date = new java.util.Date();".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        requestor = new DebugRequestor();
        userCode = "System.out.println(\"new date =\t\" + date.toString());\nSystem.out.println(\"cal.getGregorianChange() =\t\" + cal.getGregorianChange());\nreturn date.after(cal.getGregorianChange());";
        snippet = userCode.toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
        DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
        this.assertEquals("Value", "true".toCharArray(), result.getValueDisplayString());
        this.assertEquals("Type", "boolean".toCharArray(), result.getValueTypeName());
    }

    public void _test013() throws Exception {
        String userCode = "int i = 0;";
        JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode);
        DebugRequestor requestor = new DebugRequestor();
        char[] snippet = "i = -1;".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        requestor = new DebugRequestor();
        snippet = "return i != 0;".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
        DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
        this.assertEquals("Value", "true".toCharArray(), result.getValueDisplayString());
        this.assertEquals("Type", "boolean".toCharArray(), result.getValueTypeName());
    }

    public void _test014() throws Exception {
        String userCode = "int i = 0;";
        JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode);
        DebugRequestor requestor = new DebugRequestor();
        char[] snippet = "i++;".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        requestor = new DebugRequestor();
        snippet = "return i!= 0;".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
        DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
        this.assertEquals("Value", "true".toCharArray(), result.getValueDisplayString());
        this.assertEquals("Type", "boolean".toCharArray(), result.getValueTypeName());
    }

    public void _test015() throws Exception {
        String userCode = "int i = 0;";
        JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode);
        DebugRequestor requestor = new DebugRequestor();
        char[] snippet = "java.lang.System.setOut(new java.io.PrintStream(new java.io.OutputStream()));".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        requestor = new DebugRequestor();
        snippet = "return java.lang.System.out != null;".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
        DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
        this.assertEquals("Value", "true".toCharArray(), result.getValueDisplayString());
        this.assertEquals("Type", "boolean".toCharArray(), result.getValueTypeName());
    }

    public void test016() throws Exception {
        String userCode = "";
        JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode);
        DebugRequestor requestor = new DebugRequestor();
        char[] snippet = "java.lang.System.setOut(null);".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        requestor = new DebugRequestor();
        snippet = "return java.lang.System.out == null;".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
        DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
        this.assertEquals("Value", "true".toCharArray(), result.getValueDisplayString());
        this.assertEquals("Type", "boolean".toCharArray(), result.getValueTypeName());
    }

    public void test017() throws Exception {
        String userCode = "";
        JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode);
        DebugRequestor requestor = new DebugRequestor();
        char[] snippet = "class Eratosthenes {\n    int[] primeNumbers;\n\n    public Eratosthenes(int n) {\n        primeNumbers = new int[n + 1];\n\n        for (int i = 2; i <= n; i++) {\n            primeNumbers[i] = i;\n        }\n        int p = 2;\n        while (p * p <= n) {\n            int j = 2 * p;\n            while (j <= n) {\n                primeNumbers[j] = 0;\n                j += p;\n            }\n            do {\n                p++;\n            } while (primeNumbers[p] == 1);\n        }\n    }\n}\nint[] primes = new Eratosthenes(10).primeNumbers;\nint i = 0;\nint max = primes.length;\nint j = 0;\nfor (; i < max && j != 3; i++) {\n if (primes[i] != 0) {\n     j++;\n }\n}\nreturn primes[i-1];".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
        DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
        this.assertEquals("Value", "5".toCharArray(), result.getValueDisplayString());
        this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
    }

    public void test018() throws Exception {
        try {
            String sourceA018 = "public class A018 {\n  public int x = 1;\n  public int foo() {\n    x++;\n    return x;\n  }\n}";
            this.compileAndDeploy(sourceA018, "A018");
            String userCode = "new A018().foo();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A018", "foo", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "x = 5;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            requestor = new DebugRequestor();
            snippet = "return x;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "5".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A018");
        }
    }

    public void test019() throws Exception {
        try {
            String sourceA019 = "public class A019 {\n  public int x = 1;\n  public int foo() {\n    x++;\n    return x;\n  }\n}";
            this.compileAndDeploy(sourceA019, "A019");
            String userCode = "new A019().foo();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A019", "foo", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return super.clone().equals(this);".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + requestor.resultIndex + "1"), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should have problems", (boolean)result.hasProblems());
            DebugEvaluationTest.assertTrue((String)"Code snippet should have problems", (boolean)result.hasProblems());
            DebugEvaluationTest.assertEquals((String)"Wrong size", (int)1, (int)result.getProblems().length);
            DebugEvaluationTest.assertEquals((String)"Wrong pb", (int)422, (int)(result.getProblems()[0].getID() & 0x1FFFFF));
        }
        finally {
            this.removeTempClass("A019");
        }
    }

    public void test020() throws Exception {
        try {
            String sourceA = "public class A {\n\tObject o = null;\n\tpublic int foo() {\n\t\treturn 2;\n\t}\n\tpublic void bar() {\n\t}\n\tpublic Object bar2() {\n\t\treturn new Object();\n\t}\n}";
            this.compileAndDeploy(sourceA, "A");
            String userCode = "new A().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return foo();".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A");
        }
    }

    public void test021() throws Exception {
        try {
            String sourceA21 = "public class A21 {\n\tObject o = null;\n\tpublic int foo() {\n\t\treturn 2;\n\t}\n\tpublic void bar() {\n\t}\n\tpublic Object bar2() {\n\t\treturn \"toto\";\n\t}\n}";
            this.compileAndDeploy(sourceA21, "A21");
            String userCode = "new A21().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A21", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "o = bar2();".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            requestor = new DebugRequestor();
            snippet = "return o;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "toto".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "java.lang.Object".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A21");
        }
    }

    public void test022() throws Exception {
        try {
            String sourceB22 = "public class B22 {\n\tpublic String s = null;\n}";
            this.compileAndDeploy(sourceB22, "B22");
            String sourceA22 = "public class A22 {\n\tpublic B22 b = new B22();\n\tpublic int foo() {\n\t\treturn 2;\n\t}\n\tpublic void bar() {\n\t}\n\tpublic Object bar2() {\n\t\treturn \"toto\";\n\t}\n}";
            this.compileAndDeploy(sourceA22, "A22");
            String userCode = "new A22().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A22", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "b.s = \"toto\"".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            requestor = new DebugRequestor();
            snippet = "return b.s;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "toto".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "java.lang.String".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("B22");
            this.removeTempClass("A22");
        }
    }

    public void test023() throws Exception {
        try {
            String sourceC23 = "public class C23 {\n\tpublic String c = null;\n}";
            this.compileAndDeploy(sourceC23, "C23");
            String sourceB23 = "public class B23 {\n\tpublic C23 c = new C23();\n}";
            this.compileAndDeploy(sourceB23, "B23");
            String sourceA23 = "public class A23 {\n\tpublic B23 b = new B23();\n\tpublic int foo() {\n\t\treturn 2;\n\t}\n\tpublic void bar() {\n\t}\n\tpublic Object bar2() {\n\t\treturn \"toto\";\n\t}\n}";
            this.compileAndDeploy(sourceA23, "A23");
            String userCode = "new A23().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A23", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "b.c.c = \"toto\"".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            requestor = new DebugRequestor();
            snippet = "return b.c.c;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "toto".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "java.lang.String".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("C23");
            this.removeTempClass("B23");
            this.removeTempClass("A23");
        }
    }

    public void test024() throws Exception {
        try {
            String sourceC24 = "public class C24 {\n\tpublic int[] tab = {1,2,3,4,5};\n}";
            this.compileAndDeploy(sourceC24, "C24");
            String sourceB24 = "public class B24 {\n\tpublic C24 c = new C24();\n}";
            this.compileAndDeploy(sourceB24, "B24");
            String sourceA24 = "public class A24 {\n\tpublic B24 b = new B24();\n\tpublic int foo() {\n\t\treturn 2;\n\t}\n\tpublic void bar() {\n\t}\n\tpublic Object bar2() {\n\t\treturn \"toto\";\n\t}\n}";
            this.compileAndDeploy(sourceA24, "A24");
            String userCode = "new A24().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A24", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "b.c.tab[3] = 8".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            requestor = new DebugRequestor();
            snippet = "return b.c.tab[3];".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "8".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("C24");
            this.removeTempClass("B24");
            this.removeTempClass("A24");
        }
    }

    public void test025() throws Exception {
        try {
            String sourceA25 = "public class A25 {\n\tpublic String[] tabString = new String[2];\n\tpublic int foo() {\n\t\treturn 2;\n\t}\n\tpublic void bar() {\n\t}\n\tpublic Object bar2() {\n\t\treturn \"toto\";\n\t}\n}";
            this.compileAndDeploy(sourceA25, "A25");
            String userCode = "new A25().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A25", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "tabString[1] = \"toto\"".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            requestor = new DebugRequestor();
            snippet = "return tabString[1];".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "toto".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "java.lang.String".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A25");
        }
    }

    public void test026() throws Exception {
        try {
            String sourceA26 = "public class A26 {\n\tpublic int foo() {\n\t\treturn 2;\n\t}\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA26, "A26");
            String userCode = "new A26().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A26", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "int[] tab = new int[1];\ntab[0] = foo();\ntab[0]".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A26");
        }
    }

    public void test027() throws Exception {
        try {
            String sourceA27 = "public class A27 {\n\tpublic int foo() {\n\t\treturn 2;\n\t}\n\tpublic void bar() {\n\t}\n\tpublic int bar2(int i) {\n\t\tif (i == 2) {\n\t\t\treturn 3;\n\t\t} else {\n\t\t\treturn 4;\n\t\t}\n\t}\n}";
            this.compileAndDeploy(sourceA27, "A27");
            String userCode = "new A27().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A27", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "int[] tab = new int[] { 1, 2, 3, 4, 5};\nswitch(foo()) {\ncase 1 : return -1;\ncase 2 : return tab[bar2(foo())];\ndefault: return -5;}".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "4".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A27");
        }
    }

    public void test028() throws Exception {
        try {
            String sourceA28 = "public class A28 {\n\tpublic int foo() {\n\t\treturn 2;\n\t}\n\tpublic void bar() {\n\t}\n\tpublic int bar2(int i) {\n\t\tif (i == 2) {\n\t\t\treturn 3;\n\t\t} else {\n\t\t\treturn 4;\n\t\t}\n\t}\n}";
            this.compileAndDeploy(sourceA28, "A28");
            String userCode = "new A28().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A28", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "int[] tab = new int[] { 1, 2, 3, 4, 5};\nint i =3;\nswitch(foo()) {\ncase 0 : return -1;\ncase 1 : return tab[bar2(foo())];\n}\nreturn tab[i++];".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "4".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A28");
        }
    }

    public void test029() throws Exception {
        try {
            String sourceA29 = "public class A29 {\n\tpublic int foo() {\n\t\treturn 2;\n\t}\n\tpublic void bar() {\n\t}\n\tpublic int bar2(int i) {\n\t\tif (i == 2) {\n\t\t\treturn 3;\n\t\t} else {\n\t\t\treturn 4;\n\t\t}\n\t}\n}";
            this.compileAndDeploy(sourceA29, "A29");
            String userCode = "new A29().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A29", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "int[] tab = new int[] { 1, 2, 3, 4, 5};\nint i =3;\nswitch(foo()) {\ncase 0 : return -1;\ncase 1 : return tab[bar2(foo())];\n}\nreturn tab[++i];".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "5".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A29");
        }
    }

    public void test030() throws Exception {
        try {
            String sourceA30 = "public class A30 {\n\tpublic int foo() {\n\t\treturn 2;\n\t}\n\tpublic void bar() {\n\t}\n\tpublic int bar2(int i) {\n\t\tif (i == 2) {\n\t\t\treturn 3;\n\t\t} else {\n\t\t\treturn 4;\n\t\t}\n\t}\n}";
            this.compileAndDeploy(sourceA30, "A30");
            String userCode = "new A30().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A30", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "try {\nint[] tab = new int[] { 1, 2, 3, 4};\nint i =3;\nswitch(foo()) {\ncase 0 : return -1;\ncase 1 : return tab[bar2(foo())];\n}\nreturn tab[++i];} catch(ArrayIndexOutOfBoundsException e) {\nreturn -2;\n}".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "-2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A30");
        }
    }

    public void test031() throws Exception {
        try {
            String sourceA31 = "public class A31 {\n\tprivate int i = 2;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA31, "A31");
            String userCode = "new A31().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A31", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return i;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A31");
        }
    }

    public void test032() throws Exception {
        try {
            String sourceA32 = "public class A32 {\n\tprivate int i = 2;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA32, "A32");
            String sourceB32 = "public class B32 {\n\tprivate int j = 2;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceB32, "B32");
            String userCode = "new A32().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A32", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return new B32().j;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (boolean)result.hasProblems());
            CategorizedProblem[] problems = result.getProblems();
            StringBuilder buffer = null;
            int i = 0;
            int max = problems.length;
            while (i < max) {
                if (problems[i].isError()) {
                    if (buffer == null) {
                        buffer = new StringBuilder(10);
                    }
                    buffer.append(problems[i].getMessage());
                    buffer.append('|');
                }
                ++i;
            }
            DebugEvaluationTest.assertEquals("Unexpected errors", "The field B32.j is not visible|", buffer == null ? "none" : buffer.toString());
        }
        finally {
            this.removeTempClass("B32");
            this.removeTempClass("A32");
        }
    }

    public void test033() throws Exception {
        try {
            String sourceA33 = "public class A33 {\n\tprivate long l = 2000000L;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA33, "A33");
            String userCode = "new A33().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A33", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "try {\nClass c = Class.forName(\"A33\");\njava.lang.reflect.Field field = c.getDeclaredField(\"l\");\nfield.setAccessible(true);\njava.lang.reflect.Constructor constr = c.getConstructor(new Class[] {});\nObject o = constr.newInstance(new Object[]{});\nSystem.out.println(field.getInt(o));\n} catch(Exception e) {}\nreturn l;".toCharArray();
            Map compilerOptions = this.getCompilerOptions();
            compilerOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
            this.context.evaluate(snippet, stackFrame.localVariableTypeNames(), stackFrame.localVariableNames(), stackFrame.localVariableModifiers(), stackFrame.declaringTypeName(), stackFrame.isStatic(), stackFrame.isConstructorCall(), this.getEnv(), compilerOptions, (IRequestor)requestor, this.getProblemFactory());
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2000000".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "long".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A33");
        }
    }

    public void test034() throws Exception {
        try {
            String sourceA34 = "public class A34 {\n\tprivate long l = 2000000L;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA34, "A34");
            String userCode = "new A34().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A34", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "l = 100L;\nreturn l;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "100".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "long".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A34");
        }
    }

    public void test035() throws Exception {
        try {
            String sourceA35 = "public class A35 {\n\tstatic private int i = 2;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA35, "A35");
            String userCode = "new A35().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A35", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return i;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A35");
        }
    }

    public void test036() throws Exception {
        try {
            String sourceA36 = "public class A36 {\n\tprivate long l = 2000000L;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA36, "A36");
            String userCode = "new A36().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A36", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "l+=4;\nreturn l;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2000004".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "long".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A36");
        }
    }

    public void test037() throws Exception {
        try {
            String sourceA37 = "public class A37 {\n\tprivate long l = 2000000L;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA37, "A37");
            String userCode = "new A37().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A37", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "l++;\nreturn l;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2000001".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "long".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A37");
        }
    }

    public void test038() throws Exception {
        try {
            String sourceA38 = "public class A38 {\n\tprivate long l = 2000000L;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA38, "A38");
            String userCode = "new A38().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A38", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return l++;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2000000".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "long".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A38");
        }
    }

    public void test039() throws Exception {
        try {
            String sourceA39 = "public class A39 {\n\tstatic private int i = 2;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA39, "A39");
            String userCode = "new A39().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A39", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return A39.i;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A39");
        }
    }

    public void test040() throws Exception {
        try {
            String sourceA40 = "public class A40 {\n\tstatic private int[] tab = new int[] {1, 2};\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA40, "A40");
            String userCode = "new A40().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A40", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return A40.tab.length;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A40");
        }
    }

    public void test041() throws Exception {
        try {
            String sourceA41 = "public class A41 {\n\tstatic private final int[] tab = new int[] {1, 2};\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA41, "A41");
            String userCode = "new A41().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A41", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return A41.tab.length;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A41");
        }
    }

    public void test042() throws Exception {
        try {
            String sourceA42 = "public class A42 {\n\tstatic private int Counter = 0;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA42, "A42");
            String userCode = "new A42().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A42", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return ++A42.Counter;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "1".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A42");
        }
    }

    public void test043() throws Exception {
        try {
            String sourceA43 = "public class A43 {\n\tstatic private int Counter = 0;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA43, "A43");
            String userCode = "new A43().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A43", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "A43.Counter++; return A43.Counter;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "1".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A43");
        }
    }

    public void test044() throws Exception {
        try {
            String sourceA44 = "public class A44 {\n\tstatic private int Counter = 0;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA44, "A44");
            String userCode = "new A44().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A44", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "int j = A44.Counter++; return A44.Counter + j;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "1".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A44");
        }
    }

    public void test045() throws Exception {
        try {
            String sourceA45 = "public class A45 {\n\tstatic private int Counter = 0;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA45, "A45");
            String userCode = "new A45().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A45", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "int j = ++A45.Counter; return A45.Counter + j;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A45");
        }
    }

    public void test046() throws Exception {
        try {
            String sourceA46 = "public class A46 {\n\tstatic protected int Counter = 0;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA46, "A46");
            String userCode = "new A46().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A46", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "int j = ++A46.Counter; return A46.Counter + j;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A46");
        }
    }

    public void test047() throws Exception {
        try {
            String sourceA47 = "public class A47 {\n\tstatic private A47 instance = new A47();\n\tstatic private int Counter = 2;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA47, "A47");
            String userCode = "new A47().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A47", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return A47.instance.Counter;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A47");
        }
    }

    public void test048() throws Exception {
        try {
            String sourceA48 = "public class A48 {\n\tstatic private A48 instance = new A48();\n\tstatic private int Counter = 2;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA48, "A48");
            String userCode = "new A48().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A48", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return new A48().instance.Counter;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A48");
        }
    }

    public void test049() throws Exception {
        try {
            String sourceA49 = "public class A49 {\n\tstatic private A49 instance = new A49();\n\tstatic private int Counter = 2;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA49, "A49");
            String userCode = "new A49().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A49", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return ++(new A49().Counter);".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "3".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A49");
        }
    }

    public void test050() throws Exception {
        try {
            String sourceA50 = "public class A50 {\n\tstatic private A50 instance = new A50();\n\tstatic private int Counter = 2;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA50, "A50");
            String userCode = "new A50().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A50", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "A50 a = new A50(); a.Counter = 5; return a.Counter;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "5".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A50");
        }
    }

    public void test051() throws Exception {
        try {
            String sourceA51 = "public class A51 {\n\tstatic private A51 instance = new A51();\n\tstatic private int Counter = 2;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA51, "A51");
            String userCode = "new A51().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A51", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "Counter = 5; return Counter;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "5".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A51");
        }
    }

    public void test052() throws Exception {
        try {
            String sourceA52 = "public class A52 {\n\tstatic private A52 instance = new A52();\n\tstatic private int Counter = 2;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA52, "A52");
            String userCode = "new A52().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A52", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "this.Counter = 5; return this.Counter;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "5".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A52");
        }
    }

    public void test053() throws Exception {
        try {
            String sourceA53 = "public class A53 {\n\tstatic private A53 instance = new A53();\n\tstatic private int Counter = 2;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA53, "A53");
            String userCode = "new A53().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A53", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "this.Counter++; return this.Counter;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "3".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A53");
        }
    }

    public void test054() throws Exception {
        try {
            String sourceA54 = "public class A54 {\n\tstatic private A54 instance = new A54();\n\tstatic private long Counter = 2L;\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA54, "A54");
            String userCode = "new A54().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A54", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "this.Counter++; return this.Counter;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "3".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "long".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A54");
        }
    }

    public void test055() throws Exception {
        try {
            String sourceA55 = "public class A55 {\n\tprivate int foo() {;\n\t\treturn 3;\n\t}\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA55, "A55");
            String userCode = "new A55().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A55", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return foo();".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "3".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A55");
        }
    }

    public void test056() throws Exception {
        try {
            String sourceA56 = "public class A56 {\n\tprivate Integer foo() {;\n\t\treturn new Integer(3);\n\t}\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA56, "A56");
            String userCode = "new A56().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A56", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return foo().intValue();".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "3".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A56");
        }
    }

    public void test057() throws Exception {
        try {
            String sourceA57 = "public class A57 {\n\tprivate Integer foo(int i) {;\n\t\treturn new Integer(i);\n\t}\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA57, "A57");
            String userCode = "new A57().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A57", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return foo(3).intValue();".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "3".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A57");
        }
    }

    public void test058() throws Exception {
        try {
            String sourceA58 = "public class A58 {\n\tprivate Integer foo(int i, int[] tab) {;\n\t\treturn new Integer(i + tab.length);\n\t}\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA58, "A58");
            String userCode = "new A58().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A58", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "int[] tab = new int[] {1,2,3};return foo(0, tab).intValue();".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "3".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A58");
        }
    }

    public void test059() throws Exception {
        try {
            String sourceA59 = "public class A59 {\n\tprivate Integer foo(int i, Object[][] tab) {;\n\t\treturn new Integer(i + tab.length);\n\t}\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA59, "A59");
            String userCode = "new A59().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A59", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "Object[][] tab = new Object[0][0];return foo(3, tab).intValue();".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "3".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A59");
        }
    }

    public void test060() throws Exception {
        try {
            String sourceA60 = "public class A60 {\n\tprivate int i;\n\tpublic A60() {;\n\t}\n\tprivate A60(int i) {;\n\t\tthis.i = i;\n\t}\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA60, "A60");
            String userCode = "new A60().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A60", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return new A60(3).i;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "3".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A60");
        }
    }

    public void test061() throws Exception {
        try {
            String sourceA61 = "public class A61 {\n\tprivate int i;\n\tpublic A61() {;\n\t}\n\tprivate A61(int[] tab) {;\n\t\tthis.i = tab.length;\n\t}\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy(sourceA61, "A61");
            String userCode = "new A61().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A61", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return new A61(new int[] {1,2,3}).i;".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "3".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A61");
        }
    }

    public void test062() throws Exception {
        try {
            String sourceA62 = "public class A62 {\n  public static void bar() {\n  }\n}";
            this.compileAndDeploy(sourceA62, "A62");
            String userCode = "new A62().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A62", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "1 + 1".toCharArray();
            this.evaluate(stackFrame, requestor, snippet);
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "2".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A62");
        }
    }

    public void testNegative001() throws InstallException {
        try {
            String sourceANegative001 = "public class ANegative001 {\n  public int x = 1;\n  public int foo() {\n    x++;\n    return x;\n  }\n}";
            this.compileAndDeploy(sourceANegative001, "ANegative001");
            String userCode = "new ANegative001().foo();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "ANegative001", "foo", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return this.x;".toCharArray();
            this.context.evaluate(snippet, stackFrame.localVariableTypeNames(), stackFrame.localVariableNames(), stackFrame.localVariableModifiers(), stackFrame.declaringTypeName(), true, stackFrame.isConstructorCall(), this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
            DebugEvaluationTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            CategorizedProblem[] problems = result.getProblems();
            StringBuilder buffer = null;
            int i = 0;
            int max = problems.length;
            while (i < max) {
                if (problems[i].isError()) {
                    if (buffer == null) {
                        buffer = new StringBuilder(10);
                    }
                    buffer.append(problems[i].getMessage());
                    buffer.append('|');
                }
                ++i;
            }
            DebugEvaluationTest.assertEquals("Unexpected errors", "Cannot use this in a static context|", buffer == null ? "none" : buffer.toString());
        }
        finally {
            this.removeTempClass("ANegative001");
        }
    }

    public void testNegative002() throws Exception {
        try {
            String sourceANegative002 = "public class ANegative002 {\n  public int x = 1;\n  public int foo() {\n    x++;\n    return x;\n  }\n}";
            this.compileAndDeploy(sourceANegative002, "ANegative002");
            String userCode = "new ANegative002().foo();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "ANegative002", "foo", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return x;".toCharArray();
            this.context.evaluate(snippet, stackFrame.localVariableTypeNames(), stackFrame.localVariableNames(), stackFrame.localVariableModifiers(), stackFrame.declaringTypeName(), true, stackFrame.isConstructorCall(), this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
            DebugEvaluationTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            CategorizedProblem[] problems = result.getProblems();
            StringBuilder buffer = null;
            int i = 0;
            int max = problems.length;
            while (i < max) {
                if (problems[i].isError()) {
                    if (buffer == null) {
                        buffer = new StringBuilder(10);
                    }
                    buffer.append(problems[i].getMessage());
                    buffer.append('|');
                }
                ++i;
            }
            DebugEvaluationTest.assertEquals("Unexpected errors", "Cannot make a static reference to the non-static field x|", buffer == null ? "none" : buffer.toString());
        }
        finally {
            this.removeTempClass("ANegative002");
        }
    }

    public void testNegative003() throws InstallException {
        try {
            String sourceANegative003 = "public class ANegative003 {\n  public int x = 1;\n  public int foo() {\n    x++;\n    return x;\n  }\n}";
            this.compileAndDeploy(sourceANegative003, "ANegative003");
            String userCode = "new ANegative003().foo();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "ANegative003", "foo", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return zork;".toCharArray();
            this.context.evaluate(snippet, stackFrame.localVariableTypeNames(), stackFrame.localVariableNames(), stackFrame.localVariableModifiers(), stackFrame.declaringTypeName(), true, stackFrame.isConstructorCall(), this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
            DebugEvaluationTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            CategorizedProblem[] problems = result.getProblems();
            StringBuilder buffer = null;
            int i = 0;
            int max = problems.length;
            while (i < max) {
                if (problems[i].isError()) {
                    if (buffer == null) {
                        buffer = new StringBuilder(10);
                    }
                    buffer.append(problems[i].getMessage());
                    buffer.append('|');
                }
                ++i;
            }
            DebugEvaluationTest.assertEquals("Unexpected errors", "zork cannot be resolved to a variable|", buffer == null ? "none" : buffer.toString());
        }
        finally {
            this.removeTempClass("ANegative003");
        }
    }

    public void testNegative004() throws InstallException {
        String userCode = "";
        JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode);
        DebugRequestor requestor = new DebugRequestor();
        char[] snippet = "java.lang.System.out = null;".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        DebugEvaluationTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        CategorizedProblem[] problems = result.getProblems();
        StringBuilder buffer = null;
        int i = 0;
        int max = problems.length;
        while (i < max) {
            if (problems[i].isError()) {
                if (buffer == null) {
                    buffer = new StringBuilder(10);
                }
                buffer.append(problems[i].getMessage());
                buffer.append('|');
            }
            ++i;
        }
        DebugEvaluationTest.assertEquals("Unexpected errors", "The final field System.out cannot be assigned|", buffer == null ? "none" : buffer.toString());
    }

    public void test063() throws Exception {
        try {
            String sourceA63 = "public class A63 {\n  public static void bar() {\n  }\n}";
            this.compileAndDeploy15(sourceA63, "A63");
            String userCode = "new A63().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A63", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "int[] tab = new int[] {1, 2, 3, 4, 5, 6, 7, 8, 9 };\nint sum = 0;\nfor (int i : tab) {\n\tsum += i;\n}\nsum".toCharArray();
            Map compilerOpts = this.getCompilerOptions();
            compilerOpts.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
            compilerOpts.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
            compilerOpts.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
            this.context.evaluate(snippet, stackFrame.localVariableTypeNames(), stackFrame.localVariableNames(), stackFrame.localVariableModifiers(), stackFrame.declaringTypeName(), stackFrame.isStatic(), stackFrame.isConstructorCall(), this.getEnv(), compilerOpts, (IRequestor)requestor, this.getProblemFactory());
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "45".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A62");
        }
    }

    public void test065() {
        try {
            String sourceA65 = "public class A65<T> {\n\tprivate int i;\n\tpublic <U>A65() {;\n\t}\n\tprivate <U>A65(int i) {;\n\t\tthis.i = i;\n\t}\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy15(sourceA65, "A65");
            String userCode = "new <Object>A65<Object>().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A65", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return new <Object>A65<Object>(3).i;".toCharArray();
            try {
                this.context.evaluate(snippet, stackFrame.localVariableTypeNames(), stackFrame.localVariableNames(), stackFrame.localVariableModifiers(), stackFrame.declaringTypeName(), stackFrame.isStatic(), stackFrame.isConstructorCall(), this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
            }
            catch (InstallException e) {
                DebugEvaluationTest.assertTrue((String)("No targetException " + e.getMessage()), (boolean)false);
            }
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "3".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A65");
        }
    }

    public void test066() {
        try {
            String sourceA66 = "public class A66 {\n\tprivate int i;\n\tpublic A66() {;\n\t}\n\tprivate <U> int foo(int i) {;\n\t\treturn i;\n\t}\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy15(sourceA66, "A66");
            String userCode = "new A66().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A66", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return this.<Object>foo(3);".toCharArray();
            try {
                this.context.evaluate(snippet, stackFrame.localVariableTypeNames(), stackFrame.localVariableNames(), stackFrame.localVariableModifiers(), stackFrame.declaringTypeName(), stackFrame.isStatic(), stackFrame.isConstructorCall(), this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
            }
            catch (InstallException e) {
                DebugEvaluationTest.assertTrue((String)("No targetException " + e.getMessage()), (boolean)false);
            }
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "3".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A66");
        }
    }

    public void test067() {
        try {
            String sourceA67 = "import java.util.List;\npublic class A67<T> {\n\tpublic static String toString(List<?> list) {\n\t\tStringBuilder builder = new StringBuilder(\"{\");\n\t\tfor (Object o : list) {\t\t\tbuilder.append(o);\n\t\t}\n\t\tbuilder.append(\"}\");\n\t\treturn String.valueOf(builder);\n\t}\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy15(sourceA67, "A67");
            String userCode = "new A67<Object>().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A67", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "java.util.ArrayList<String> list = new java.util.ArrayList<String>();\nlist.add(\"Test\");\nlist.add(\"Hello\");\nlist.add(\"World\");\nreturn A67.toString(list);".toCharArray();
            try {
                this.context.evaluate(snippet, stackFrame.localVariableTypeNames(), stackFrame.localVariableNames(), stackFrame.localVariableModifiers(), stackFrame.declaringTypeName(), stackFrame.isStatic(), stackFrame.isConstructorCall(), this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
            }
            catch (InstallException e) {
                DebugEvaluationTest.assertTrue((String)("No targetException " + e.getMessage()), (boolean)false);
            }
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (!result.hasProblems() ? 1 : 0) != 0);
            DebugEvaluationTest.assertTrue((String)"Result should have a value", (boolean)result.hasValue());
            this.assertEquals("Value", "{TestHelloWorld}".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "java.lang.String".toCharArray(), result.getValueTypeName());
        }
        finally {
            this.removeTempClass("A67");
        }
    }

    public void test068() {
        try {
            String sourceSuperA68 = "public class SuperA68 {\n\tprivate int i;\n\tpublic SuperA68() {\n\t}\n\tpublic <U> int foo(int i) {;\n\t\treturn i;\n\t}\n}";
            this.compileAndDeploy15(sourceSuperA68, "SuperA68");
            String sourceA68 = "public class A68 extends SuperA68 {\n\tprivate int i;\n\tpublic A68() {\n\t}\n\tpublic <U> int foo(int i) {\n\t\treturn i;\n\t}\n\tpublic void bar() {\n\t}\n}";
            this.compileAndDeploy15(sourceA68, "A68");
            String userCode = "new A68().bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A68", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "return super.<Object>foo(3);".toCharArray();
            try {
                this.context.evaluate(snippet, stackFrame.localVariableTypeNames(), stackFrame.localVariableNames(), stackFrame.localVariableModifiers(), stackFrame.declaringTypeName(), stackFrame.isStatic(), stackFrame.isConstructorCall(), this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
            }
            catch (InstallException e) {
                DebugEvaluationTest.assertTrue((String)("No targetException " + e.getMessage()), (boolean)false);
            }
            DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should have problems", (boolean)result.hasProblems());
            DebugEvaluationTest.assertEquals((String)"Wrong size", (int)1, (int)result.getProblems().length);
            DebugEvaluationTest.assertEquals((String)"Wrong pb", (int)422, (int)(result.getProblems()[0].getID() & 0x1FFFFF));
        }
        finally {
            this.removeTempClass("A68");
            this.removeTempClass("SuperA68");
        }
    }

    public void test069() {
        try {
            boolean is16Plus;
            String sourceA69 = "public enum A69 {\n\tA(2), B(1);\n\tprivate int i;\n\tprivate A69(int i) {\n\t\tthis.i = i;\n\t}\n\tpublic String toString() {\n\t\treturn String.valueOf(this.i);\n\t}\n\tpublic static void bar() {\n\t}\n}";
            this.compileAndDeploy15(sourceA69, "A69");
            String userCode = "A69.bar();";
            JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode, "A69", "bar", -1);
            DebugRequestor requestor = new DebugRequestor();
            char[] snippet = "enum E { C }; return String.toString(E.C.getName());".toCharArray();
            try {
                this.context.evaluate(snippet, stackFrame.localVariableTypeNames(), stackFrame.localVariableNames(), stackFrame.localVariableModifiers(), stackFrame.declaringTypeName(), stackFrame.isStatic(), stackFrame.isConstructorCall(), this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
            }
            catch (InstallException e) {
                DebugEvaluationTest.assertTrue((String)("No targetException " + e.getMessage()), (boolean)false);
            }
            boolean bl = is16Plus = this.complianceLevel >= 0x3C0000L;
            if (is16Plus) {
                DebugEvaluationTest.assertTrue((String)("Should get one result but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 0 ? 1 : 0) != 0);
            } else {
                DebugEvaluationTest.assertTrue((String)("Should get two results but got " + (requestor.resultIndex + 1)), (requestor.resultIndex == 1 ? 1 : 0) != 0);
            }
            EvaluationResult result = requestor.results[0];
            DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (boolean)result.hasProblems());
            DebugEvaluationTest.assertEquals((String)"Wrong size", (int)1, (int)result.getProblems().length);
            DebugEvaluationTest.assertEquals((String)"Wrong pb", (int)(is16Plus ? 100 : 31), (int)(result.getProblems()[0].getID() & 0x1FFFFF));
            if (!is16Plus) {
                result = requestor.results[1];
                DebugEvaluationTest.assertTrue((String)"Code snippet should not have problems", (boolean)result.hasProblems());
                DebugEvaluationTest.assertEquals((String)"Wrong size", (int)1, (int)result.getProblems().length);
                DebugEvaluationTest.assertEquals((String)"Wrong pb", (int)50, (int)(result.getProblems()[0].getID() & 0x1FFFFF));
            }
        }
        finally {
            this.removeTempClass("A69");
        }
    }

    public void testNegative005() throws InstallException {
        String userCode = "";
        JDIStackFrame stackFrame = new JDIStackFrame(this.jdiVM, this, userCode);
        DebugRequestor requestor = new DebugRequestor();
        char[] snippet = "run()".toCharArray();
        this.evaluate(stackFrame, requestor, snippet);
        DebugEvaluationTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        CategorizedProblem[] problems = result.getProblems();
        StringBuilder buffer = null;
        int i = 0;
        int max = problems.length;
        while (i < max) {
            if (problems[i].isError()) {
                if (buffer == null) {
                    buffer = new StringBuilder(10);
                }
                buffer.append(problems[i].getMessage());
                buffer.append('|');
            }
            ++i;
        }
        DebugEvaluationTest.assertEquals("Unexpected errors", "Cannot use this in a static context|", buffer == null ? "none" : buffer.toString());
    }

    class DebugRequestor
    extends EvaluationTest.Requestor {
        DebugRequestor() {
            super(DebugEvaluationTest.this);
        }

        @Override
        public boolean acceptClassFiles(ClassFile[] classFiles, char[] codeSnippetClassName) {
            if (DebugEvaluationTest.this.jdiStackFrame == null) {
                return super.acceptClassFiles(classFiles, codeSnippetClassName);
            }
            super.acceptClassFiles(classFiles, null);
            if (codeSnippetClassName != null) {
                boolean success = DebugEvaluationTest.this.jdiStackFrame.run(new String(codeSnippetClassName));
                if (success) {
                    TargetInterface.Result result = DebugEvaluationTest.this.target.getResult();
                    if (result.displayString == null) {
                        this.acceptResult(new EvaluationResult(null, 2, null, null));
                    } else {
                        this.acceptResult(new EvaluationResult(null, 2, result.displayString, result.typeName));
                    }
                }
                return success;
            }
            return true;
        }
    }
}

