/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import junit.framework.Test;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.jdt.core.eval.ICodeSnippetRequestor;
import org.eclipse.jdt.core.tests.eval.DebugEvaluationSetup;
import org.eclipse.jdt.core.tests.eval.EvaluationTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.eval.EvaluationContextWrapper;
import org.eclipse.jdt.internal.eval.InstallException;

public class EvaluationContextWrapperTest
extends EvaluationTest {
    private static final String SOURCE_DIRECTORY = "src";
    private static final String BIN_DIR = "bin";
    private IJavaProject project;

    public EvaluationContextWrapperTest(String name) {
        super(name);
    }

    public static Test setupSuite(Class clazz) {
        ArrayList<Class> testClasses = new ArrayList<Class>();
        testClasses.add(clazz);
        return EvaluationContextWrapperTest.buildAllCompliancesTestSuite(clazz, DebugEvaluationSetup.class, testClasses);
    }

    public static Test suite() {
        return EvaluationContextWrapperTest.setupSuite(EvaluationContextWrapperTest.testClass());
    }

    public static Class<?> testClass() {
        return EvaluationContextWrapperTest.class;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.project = this.createProject("EvaluationContextWrapperTest");
    }

    @Override
    protected void tearDown() throws Exception {
        EvaluationContextWrapperTest.delete(this.project);
        this.project = null;
        super.tearDown();
    }

    public void testBug573589_StaticImport() throws Exception {
        try {
            StringBuilder source = new StringBuilder();
            source.append("import static java.lang.Math.max;\n");
            source.append("class Bug573589 {\n");
            source.append("\t\tpublic int fooMax() {\n");
            source.append("\t\t\treturn max(10, 11);\n");
            source.append("\t\t}\n");
            source.append("\t\tpublic static void call() {\n");
            source.append("\t\t\tnew Bug573589().fooMax();\n");
            source.append("\t\t}\n");
            source.append("}\n");
            this.compileAndDeploy15(source.toString(), "Bug573589");
            this.refreshProject();
            Optional<IMarker> problem = this.evaluate("Bug573589", "1+1");
            EvaluationContextWrapperTest.assertTrue((String)"Evaluation should not have problems : ".concat(problem.map(p -> p.getAttribute("message", "")).orElse("")), (boolean)problem.isEmpty());
        }
        finally {
            this.removeTempClass("Bug573589");
        }
    }

    public void testBug573589_StaticImport_AttachedSource() throws Exception {
        try {
            StringBuilder source = new StringBuilder();
            source.append("import static java.lang.Math.max;\n");
            source.append("class Bug573589 {\n");
            source.append("\t\tpublic int fooMax() {\n");
            source.append("\t\t\treturn max(10, 11);\n");
            source.append("\t\t}\n");
            source.append("\t\tpublic static void call() {\n");
            source.append("\t\t\tnew Bug573589().fooMax();\n");
            source.append("\t\t}\n");
            source.append("}\n");
            Map<String, String> result = this.compileAndDeploy15(source.toString(), "Bug573589", "attached");
            this.addLibrary(this.project, result.get(BIN_DIR), result.get(SOURCE_DIRECTORY));
            this.refreshProject();
            Optional<IMarker> problem = this.evaluate("Bug573589", "1+1");
            EvaluationContextWrapperTest.assertTrue((String)"Evaluation should not have problems : ".concat(problem.map(p -> p.getAttribute("message", "")).orElse("")), (boolean)problem.isEmpty());
        }
        finally {
            this.removeTempClass("Bug573589", "attached");
        }
    }

    private void compileAndDeploy15(String source, String className) throws Exception {
        this.compileAndDeploy15(source, className, "");
    }

    private Map<String, String> compileAndDeploy15(String source, String className, String locationPrefix) throws Exception {
        this.resetEnv();
        String srcDir = this.project.getProject().getLocation().toFile().getAbsolutePath() + File.separator + SOURCE_DIRECTORY.concat(locationPrefix);
        String binDir = this.project.getProject().getLocation().toFile().getAbsolutePath() + File.separator + BIN_DIR.concat(locationPrefix);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(SOURCE_DIRECTORY, srcDir);
        result.put(BIN_DIR, binDir);
        File directory = new File(srcDir);
        if (!directory.exists()) {
            Files.createDirectories(directory.toPath(), new FileAttribute[0]);
        }
        String fileName = srcDir + File.separator + className + ".java";
        Files.write(Paths.get(fileName, new String[0]), source.getBytes(), new OpenOption[0]);
        StringBuilder buffer = new StringBuilder();
        buffer.append("\"").append(fileName).append("\" -d \"").append(binDir).append("\" -nowarn -" + CompilerOptions.getFirstSupportedJavaVersion() + " -g -classpath \"").append(Util.getJavaClassLibsAsString()).append(srcDir).append("\"");
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        PrintWriter errWriter = new PrintWriter(out);
        PrintWriter outWriter = new PrintWriter(err);
        boolean compiled = BatchCompiler.compile((String)buffer.toString(), (PrintWriter)outWriter, (PrintWriter)errWriter, null);
        if (!compiled) {
            EvaluationContextWrapperTest.fail((String)("Failed to compile '" + className + "', system error: '" + err.toString() + "', system out: '" + out.toString() + "'"));
        }
        return result;
    }

    private void refreshProject() throws Exception {
        this.project.getProject().refreshLocal(2, null);
        this.waitForAutoBuild();
    }

    private void removeTempClass(String className) {
        this.removeTempClass(className, "");
    }

    private void removeTempClass(String className, String locationPrefix) {
        this.resetEnv();
        String srcDir = this.project.getProject().getLocation().toFile().getAbsolutePath() + File.separator + SOURCE_DIRECTORY.concat(locationPrefix);
        String binDir = this.project.getProject().getLocation().toFile().getAbsolutePath() + File.separator + BIN_DIR.concat(locationPrefix);
        Util.delete(srcDir + File.separator + className + ".java");
        Util.delete(binDir + File.separator + className + ".class");
    }

    private Optional<IMarker> evaluate(String declaringTypeName, String snippet) throws InstallException, JavaModelException {
        IType type = this.project.findType(declaringTypeName);
        EvaluationContextWrapperTest.assertNotNull((String)"declaringType is not compiled", (Object)type);
        String source = type.getSource();
        EvaluationContextWrapperTest.assertNotNull((String)"declaringType source mapper is not ready.", (Object)source);
        EvaluationContextWrapperTest.assertFalse((String)"declaringType source mapper is not ready.", (boolean)source.isEmpty());
        final IMarker[] problem = new IMarker[1];
        ICodeSnippetRequestor requestor = new ICodeSnippetRequestor(){

            public void acceptProblem(IMarker problemMarker, String fragmentSource, int fragmentKind) {
                if (problemMarker.getAttribute("severity", 0) >= 2) {
                    problem[0] = problemMarker;
                }
            }

            public boolean acceptClassFiles(byte[][] classFileBytes, String[][] classFileCompoundNames, String codeSnippetClassName) {
                return true;
            }
        };
        EvaluationContextWrapper wrapper = new EvaluationContextWrapper(this.context, (JavaProject)this.project);
        wrapper.evaluateCodeSnippet(snippet, new String[0], new String[0], new int[0], type, true, false, requestor, null);
        return Optional.ofNullable(problem[0]);
    }

    @Override
    public Map<String, String> getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        return options;
    }

    private IJavaProject createProject(String name) throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject proj = root.getProject(name);
        if (proj.exists()) {
            proj.delete(true, true, null);
        }
        proj = root.getProject(name);
        proj.create(null);
        proj.open(null);
        IProjectDescription description = proj.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        description.setBuildConfigs(new String[0]);
        description.setBuildSpec(new ICommand[0]);
        proj.setDescription(description, 1, null);
        IFolder binFolder = proj.getFolder(BIN_DIR);
        if (!binFolder.exists()) {
            binFolder.create(false, true, null);
        }
        IPath outputLocation = binFolder.getFullPath();
        IJavaProject jproject = JavaCore.create((IProject)proj);
        jproject.setRawClasspath(new IClasspathEntry[0], null);
        jproject.setOutputLocation(outputLocation, null);
        Hashtable map = JavaCore.getOptions();
        map.put("org.eclipse.jdt.core.compiler.compliance", CompilerOptions.getFirstSupportedJavaVersion());
        map.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.getFirstSupportedJavaVersion());
        map.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", CompilerOptions.getFirstSupportedJavaVersion());
        jproject.setOptions((Map)map);
        this.addSourceContainer(jproject, SOURCE_DIRECTORY);
        String[] stringArray = Util.getJavaClassLibs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.addLibrary(jproject, path, null);
            ++n2;
        }
        return jproject;
    }

    private void addSourceContainer(IJavaProject prj, String name) throws Exception {
        IFolder folder = prj.getProject().getFolder(name);
        if (!folder.exists()) {
            folder.create(false, true, null);
        }
        IClasspathEntry entry = JavaCore.newSourceEntry((IPath)prj.getPackageFragmentRoot((IResource)folder).getPath());
        prj.setRawClasspath(EvaluationContextWrapperTest.addToClasspath(prj.getRawClasspath(), entry), null);
    }

    private void addLibrary(IJavaProject prj, String path, String sourcePath) throws Exception {
        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)new Path(path), (IPath)Optional.ofNullable(sourcePath).map(Path::new).orElse(null), (IPath)Optional.ofNullable(sourcePath).map(p -> new Path(path)).orElse(null));
        prj.setRawClasspath(EvaluationContextWrapperTest.addToClasspath(prj.getRawClasspath(), entry), null);
    }

    private static IClasspathEntry[] addToClasspath(IClasspathEntry[] original, IClasspathEntry add) {
        ClasspathEntry[] copy = new ClasspathEntry[original.length + 1];
        System.arraycopy(original, 0, copy, 0, original.length);
        copy[copy.length - 1] = add;
        return copy;
    }

    private static void delete(IJavaProject jproject) throws CoreException {
        jproject.setRawClasspath((IClasspathEntry[])new ClasspathEntry[0], jproject.getProject().getFullPath(), null);
        jproject.getProject().delete(true, true, null);
    }
}

