/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import org.eclipse.jdt.core.tests.runtime.LocalVMLauncher;
import org.eclipse.jdt.core.tests.runtime.LocalVirtualMachine;
import org.eclipse.jdt.core.tests.runtime.TargetException;
import org.eclipse.jdt.core.tests.runtime.TargetInterface;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.eval.EvaluationContext;
import org.junit.Assert;

public class EvaluationSetup
extends CompilerTestSetup {
    public static final String EVAL_DIRECTORY = Util.getOutputDirectory() + File.separator + "evaluation";
    public static final String JRE_PATH = Util.getJREDirectory();
    EvaluationContext context;
    TargetInterface target;
    LocalVirtualMachine launchedVM;
    INameEnvironment env;

    public EvaluationSetup(long complianceLevel) {
        super(complianceLevel);
    }

    @Override
    protected void setUp() {
        if (this.context == null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (ServerSocket server = new ServerSocket(0);){
                    int evalPort = server.getLocalPort();
                    try {
                        LocalVMLauncher launcher = LocalVMLauncher.getLauncher();
                        launcher.setVMPath(JRE_PATH);
                        launcher.setEvalPort(evalPort);
                        launcher.setEvalTargetPath(EVAL_DIRECTORY);
                        this.launchedVM = launcher.launch();
                    }
                    catch (TargetException e) {
                        e.printStackTrace();
                        throw new Error(e.getMessage(), e);
                    }
                    try {
                        this.startReader("VM's stdout reader", this.launchedVM.getInputStream(), System.out);
                    }
                    catch (TargetException e) {
                        e.printStackTrace();
                    }
                    try {
                        this.startReader("VM's sterr reader", this.launchedVM.getErrorStream(), System.err);
                    }
                    catch (TargetException e) {
                        e.printStackTrace();
                    }
                    this.context = new EvaluationContext();
                    this.target = new TargetInterface();
                    this.target.connect(server, 60000);
                    Assert.assertTrue((String)"Failed to connect VM server", (boolean)this.target.isConnected());
                    System.out.println(this.getName() + ": connected to target");
                    this.env = new FileSystem(Util.getJavaClassLibs(), new String[0], null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new Error("Failed to open socket", e1);
            }
        }
        super.setUp();
    }

    protected void startReader(String name, final InputStream in, final PrintStream out) {
        new Thread(name){

            @Override
            public void run() {
                int read = 0;
                while (read != -1) {
                    try {
                        read = in.read();
                    }
                    catch (IOException e) {
                        read = -1;
                    }
                    if (read == -1) continue;
                    out.print((char)read);
                }
            }
        }.start();
    }

    @Override
    protected final void tearDown() {
        LocalVirtualMachine vm;
        if (this.context != null && (vm = this.launchedVM) != null) {
            try {
                if (this.target != null) {
                    this.target.disconnect();
                }
                int retry = 0;
                while (vm.isRunning() && ++retry < 20) {
                    try {
                        Thread.sleep(retry * 100);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (vm.isRunning()) {
                    vm.shutDown();
                }
                this.context = null;
            }
            catch (TargetException e) {
                e.printStackTrace();
                throw new Error(e.getMessage(), e);
            }
        }
        if (this.env != null) {
            this.env.cleanup();
        }
    }
}

