/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.eval.EvaluationSetup;
import org.eclipse.jdt.core.tests.junit.extension.StopableTestCase;
import org.eclipse.jdt.core.tests.runtime.LocalVirtualMachine;
import org.eclipse.jdt.core.tests.runtime.TargetException;
import org.eclipse.jdt.core.tests.runtime.TargetInterface;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.eval.EvaluationContext;
import org.eclipse.jdt.internal.eval.EvaluationResult;
import org.eclipse.jdt.internal.eval.GlobalVariable;
import org.eclipse.jdt.internal.eval.IRequestor;
import org.eclipse.jdt.internal.eval.InstallException;

public class EvaluationTest
extends AbstractCompilerTest
implements StopableTestCase {
    String[] classPath;
    public EvaluationContext context;
    INameEnvironment env;
    LocalVirtualMachine launchedVM;
    TargetInterface target;

    public EvaluationTest(String name) {
        super(name);
    }

    public static Test setupSuite(Class clazz) {
        ArrayList<Class> testClasses = new ArrayList<Class>();
        testClasses.add(clazz);
        return EvaluationTest.buildAllCompliancesTestSuite(clazz, EvaluationSetup.class, testClasses);
    }

    public static Test suite(Class evaluationTestClass) {
        TestSuite suite = new TestSuite(evaluationTestClass);
        return suite;
    }

    public void assertEquals(String message, char[] expected, char[] actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null) {
            if (actual == null) {
                this.failNotEquals(message, expected, actual);
                return;
            }
            if (expected.length == actual.length) {
                int i = 0;
                while (i < expected.length) {
                    if (expected[i] != actual[i]) {
                        this.failNotEquals(message, expected, actual);
                        return;
                    }
                    ++i;
                }
                return;
            }
        }
        this.failNotEquals(message, expected, actual);
    }

    protected char[] buildCharArray(String[] lines) {
        String buffer = String.join((CharSequence)"\n", lines);
        int length = buffer.length();
        char[] result = new char[length];
        buffer.getChars(0, length, result, 0);
        return result;
    }

    public boolean equals(CategorizedProblem pb1, CategorizedProblem pb2) {
        if (pb1 == null && pb2 == null) {
            return true;
        }
        if (pb1 == null || pb2 == null) {
            return false;
        }
        return pb1.getID() == pb2.getID() && pb1.isError() == pb2.isError() && pb1.getSourceStart() == pb2.getSourceStart() && pb1.getSourceEnd() == pb2.getSourceEnd() && pb1.getSourceLineNumber() == pb2.getSourceLineNumber();
    }

    public void evaluateWithExpectedDisplayString(Map compilerOptions, char[] codeSnippet, char[] displayString) {
        Requestor requestor = new Requestor();
        try {
            this.context.evaluate(codeSnippet, this.getEnv(), compilerOptions, (IRequestor)requestor, this.getProblemFactory());
        }
        catch (InstallException e) {
            EvaluationTest.assertTrue((String)("Target exception " + e.getMessage()), (boolean)false);
        }
        if (requestor.resultIndex != 0) {
            int i = 0;
            while (i < requestor.resultIndex) {
                System.out.println("unexpected result[" + i + "]: " + String.valueOf(requestor.results[i]));
                ++i;
            }
        }
        EvaluationTest.assertTrue((String)"Unexpected result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        EvaluationTest.assertTrue((String)"Has problem", (!result.hasProblems() ? 1 : 0) != 0);
        EvaluationTest.assertTrue((String)"Empty problem list", (result.getProblems().length == 0 ? 1 : 0) != 0);
        if (displayString == null) {
            EvaluationTest.assertTrue((String)"Has value", (!result.hasValue() ? 1 : 0) != 0);
        } else {
            EvaluationTest.assertTrue((String)"Has value", (boolean)result.hasValue());
            EvaluationTest.assertEquals((String)"Evaluation type", (int)2, (int)result.getEvaluationType());
            this.assertEquals("Value display string", displayString, result.getValueDisplayString());
        }
    }

    public void evaluateWithExpectedDisplayString(char[] codeSnippet, char[] displayString) {
        Requestor requestor = new Requestor();
        try {
            this.context.evaluate(codeSnippet, this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
        }
        catch (InstallException e) {
            EvaluationTest.assertTrue((String)("Target exception " + e.getMessage()), (boolean)false);
        }
        if (requestor.resultIndex != 0) {
            int i = 0;
            while (i < requestor.resultIndex) {
                System.out.println("unexpected result[" + i + "]: " + String.valueOf(requestor.results[i]));
                ++i;
            }
        }
        EvaluationTest.assertTrue((String)"Unexpected result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        EvaluationTest.assertTrue((String)"Has problem", (!result.hasProblems() ? 1 : 0) != 0);
        EvaluationTest.assertTrue((String)"Empty problem list", (result.getProblems().length == 0 ? 1 : 0) != 0);
        if (displayString == null) {
            EvaluationTest.assertTrue((String)"Has value", (!result.hasValue() ? 1 : 0) != 0);
        } else {
            EvaluationTest.assertTrue((String)"Does not have expected value", (boolean)result.hasValue());
            EvaluationTest.assertEquals((String)"Evaluation type", (int)2, (int)result.getEvaluationType());
            this.assertEquals("Value display string", displayString, result.getValueDisplayString());
        }
    }

    protected void evaluateWithExpectedImportProblem(char[] codeSnippet, char[] importDeclaration, CategorizedProblem expected) {
        this.evaluateWithExpectedImportProblem(codeSnippet, importDeclaration, this.getCompilerOptions(), expected);
    }

    protected void evaluateWithExpectedImportProblem(char[] codeSnippet, char[] importDeclaration, Map options, CategorizedProblem expected) {
        Requestor requestor = new Requestor();
        try {
            this.context.evaluate(codeSnippet, this.getEnv(), options, (IRequestor)requestor, this.getProblemFactory());
        }
        catch (InstallException e) {
            EvaluationTest.assertTrue((String)("Target exception " + e.getMessage()), (boolean)false);
        }
        int i = 0;
        while (i <= requestor.resultIndex) {
            EvaluationResult result = requestor.results[i];
            EvaluationTest.assertTrue((String)"Has value", (!result.hasValue() ? 1 : 0) != 0);
            EvaluationTest.assertTrue((String)"Has problem", (boolean)result.hasProblems());
            EvaluationTest.assertEquals((String)"Evaluation type", (int)3, (int)result.getEvaluationType());
            this.assertEquals("Evaluation id", importDeclaration, result.getEvaluationID());
            CategorizedProblem[] problems = result.getProblems();
            if (this.equals(expected, problems[0])) {
                return;
            }
            ++i;
        }
        EvaluationTest.assertTrue((String)"Expected problem not found", (boolean)false);
    }

    protected void evaluateWithExpectedProblem(char[] codeSnippet, CategorizedProblem expected) {
        Requestor requestor = new Requestor();
        try {
            this.context.evaluate(codeSnippet, this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
        }
        catch (InstallException e) {
            EvaluationTest.assertTrue((String)("Target exception " + e.getMessage()), (boolean)false);
        }
        int i = 0;
        while (i <= requestor.resultIndex) {
            EvaluationResult result = requestor.results[i];
            EvaluationTest.assertTrue((String)"Has value", (!result.hasValue() ? 1 : 0) != 0);
            EvaluationTest.assertTrue((String)"Has problem", (boolean)result.hasProblems());
            EvaluationTest.assertEquals((String)"Evaluation type", (int)2, (int)result.getEvaluationType());
            this.assertEquals("Evaluation id", codeSnippet, result.getEvaluationID());
            CategorizedProblem[] problems = result.getProblems();
            if (this.equals(expected, problems[0])) {
                return;
            }
            ++i;
        }
        EvaluationTest.assertTrue((String)"Expected problem not found", (boolean)false);
    }

    protected void evaluateWithExpectedProblem(char[] codeSnippet, String problemsString) {
        Requestor requestor = new Requestor();
        try {
            this.context.evaluate(codeSnippet, this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
        }
        catch (InstallException e) {
            EvaluationTest.assertTrue((String)("Target exception " + e.getMessage()), (boolean)false);
        }
        EvaluationTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        EvaluationTest.assertTrue((String)"Has value", (!result.hasValue() ? 1 : 0) != 0);
        EvaluationTest.assertTrue((String)"Has problem", (boolean)result.hasProblems());
        EvaluationTest.assertEquals((String)"Evaluation type", (int)2, (int)result.getEvaluationType());
        this.assertEquals("Evaluation id", codeSnippet, result.getEvaluationID());
        StringBuilder problemBuffer = new StringBuilder(20);
        CategorizedProblem[] problems = result.getProblems();
        int i = 0;
        while (i < problems.length) {
            problemBuffer.append(problems[i].getMessage()).append('\n');
            ++i;
        }
        EvaluationTest.assertEquals("Unexpected problems", problemsString, problemBuffer.toString());
    }

    protected void evaluateWithExpectedProblem(GlobalVariable var, CategorizedProblem expected) {
        Requestor requestor = new Requestor();
        try {
            this.context.evaluateVariables(this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
        }
        catch (InstallException e) {
            EvaluationTest.assertTrue((String)("Target exception " + e.getMessage()), (boolean)false);
        }
        int i = 0;
        while (i <= requestor.resultIndex) {
            EvaluationResult result = requestor.results[i];
            EvaluationTest.assertTrue((String)"Has value", (!result.hasValue() ? 1 : 0) != 0);
            EvaluationTest.assertTrue((String)"Has problem", (boolean)result.hasProblems());
            EvaluationTest.assertEquals((String)"Evaluation type", (int)1, (int)result.getEvaluationType());
            this.assertEquals("Evaluation id", var.getName(), result.getEvaluationID());
            CategorizedProblem[] problems = result.getProblems();
            if (this.equals(expected, problems[0])) {
                return;
            }
            ++i;
        }
        EvaluationTest.assertTrue((String)"Expected problem not found", (boolean)false);
    }

    protected void evaluateWithExpectedType(char[] codeSnippet, char[] expectedTypeName) {
        Requestor requestor = new Requestor();
        try {
            this.context.evaluate(codeSnippet, this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
        }
        catch (InstallException e) {
            EvaluationTest.assertTrue((String)("Target exception " + e.getMessage()), (boolean)false);
        }
        if (requestor.resultIndex != 0) {
            int i = 0;
            while (i < requestor.resultIndex) {
                System.out.println("unexpected result[" + i + "]: " + String.valueOf(requestor.results[i]));
                ++i;
            }
        }
        EvaluationTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        if (expectedTypeName == null) {
            EvaluationTest.assertTrue((String)"Has value", (!result.hasValue() ? 1 : 0) != 0);
        } else {
            EvaluationTest.assertTrue((String)"Does not have expected value", (boolean)result.hasValue());
            EvaluationTest.assertEquals((String)"Evaluation type", (int)2, (int)result.getEvaluationType());
            this.assertEquals("Value type name", expectedTypeName, result.getValueTypeName());
        }
    }

    protected void evaluateWithExpectedValue(char[] codeSnippet, char[] displayString, char[] typeName) {
        Requestor requestor = new Requestor();
        try {
            this.context.evaluate(codeSnippet, this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
        }
        catch (InstallException e) {
            EvaluationTest.assertTrue((String)("Target exception " + e.getMessage()), (boolean)false);
        }
        EvaluationTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        if (displayString == null) {
            EvaluationTest.assertTrue((String)"Missing value", (!result.hasValue() ? 1 : 0) != 0);
        } else {
            EvaluationTest.assertTrue((String)"Has value", (boolean)result.hasValue());
            EvaluationTest.assertEquals((String)"Evaluation type", (int)2, (int)result.getEvaluationType());
            this.assertEquals("Value display string", displayString, result.getValueDisplayString());
            this.assertEquals("Value type name", typeName, result.getValueTypeName());
        }
    }

    protected void evaluateWithExpectedValue(GlobalVariable var, char[] displayString, char[] typeName) {
        Requestor requestor = new Requestor();
        try {
            this.context.evaluateVariable(var, this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
        }
        catch (InstallException e) {
            EvaluationTest.assertTrue((String)("Target exception " + e.getMessage()), (boolean)false);
        }
        if (requestor.resultIndex != 0) {
            int i = 0;
            while (i < requestor.resultIndex) {
                System.out.println("unexpected result[" + i + "]: " + String.valueOf(requestor.results[i]));
                ++i;
            }
        }
        EvaluationTest.assertTrue((String)"Unexpected result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        if (displayString == null) {
            EvaluationTest.assertTrue((String)"Has value", (!result.hasValue() ? 1 : 0) != 0);
        } else {
            EvaluationTest.assertTrue((String)"Has value", (boolean)result.hasValue());
            this.assertEquals("Value display string", displayString, result.getValueDisplayString());
            this.assertEquals("Value type name", typeName, result.getValueTypeName());
        }
    }

    protected void evaluateWithExpectedWarningAndDisplayString(char[] codeSnippet, CategorizedProblem[] expected, char[] displayString) {
        class ResultRequestor
        extends Requestor {
            ArrayList collectedProblems;
            boolean gotDisplayString;
            private final /* synthetic */ char[] val$displayString;

            ResultRequestor(char[] cArray) {
                this.val$displayString = cArray;
                this.collectedProblems = new ArrayList();
                this.gotDisplayString = false;
            }

            @Override
            public void acceptResult(EvaluationResult result) {
                EvaluationTest.assertEquals((String)"Evaluation type", (int)2, (int)result.getEvaluationType());
                if (result.hasValue()) {
                    if (CharOperation.equals((char[])result.getValueDisplayString(), (char[])this.val$displayString)) {
                        this.gotDisplayString = true;
                    }
                } else {
                    EvaluationTest.assertTrue((String)"Has problem", (boolean)result.hasProblems());
                    CategorizedProblem[] problems = result.getProblems();
                    this.collectedProblems.addAll(Arrays.asList(problems));
                }
            }
        }
        ResultRequestor requestor = new ResultRequestor(displayString);
        try {
            this.context.evaluate(codeSnippet, this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
        }
        catch (InstallException e) {
            EvaluationTest.assertTrue((String)("Target exception " + e.getMessage()), (boolean)false);
        }
        if (expected.length == requestor.collectedProblems.size()) {
            int i = 0;
            while (i < expected.length) {
                EvaluationTest.assertTrue((String)("Problem mismatch" + String.valueOf(requestor.collectedProblems.get(i))), (boolean)this.equals(expected[i], (CategorizedProblem)requestor.collectedProblems.get(i)));
                ++i;
            }
        } else {
            EvaluationTest.assertTrue((String)"Wrong problem count", (boolean)false);
        }
        EvaluationTest.assertTrue((String)"Expected display string", (boolean)requestor.gotDisplayString);
    }

    private void failNotEquals(String message, char[] expected, char[] actual) {
        Object formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        String expectedString = expected == null ? "null" : new String(expected);
        String actualString = actual == null ? "null" : new String(actual);
        EvaluationTest.fail((String)((String)formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">"));
    }

    @Override
    public Map getCompilerOptions() {
        Map defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
        defaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
        defaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", "warning");
        return defaultOptions;
    }

    public INameEnvironment getEnv() {
        return this.env;
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    @Override
    public void initialize(CompilerTestSetup setUp) {
        super.initialize(setUp);
        EvaluationSetup evalSetUp = (EvaluationSetup)setUp;
        this.context = evalSetUp.context;
        this.target = evalSetUp.target;
        this.launchedVM = evalSetUp.launchedVM;
        this.env = evalSetUp.env;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        EvaluationTest.assertNotNull((String)"Evaluation context is null, probably VM connection error", (Object)this.context);
    }

    protected void installVariables(int expectedNumber) {
        class InstallRequestor
        extends Requestor {
            int count;

            InstallRequestor() {
                this.count = 0;
            }

            @Override
            public void acceptResult(EvaluationResult result) {
                EvaluationTest.assertTrue((String)"Has problems", (!result.hasProblems() ? 1 : 0) != 0);
                EvaluationTest.assertTrue((String)"Has value", (boolean)result.hasValue());
                ++this.count;
            }
        }
        InstallRequestor installRequestor = new InstallRequestor();
        try {
            this.context.evaluateVariables(this.getEnv(), this.getCompilerOptions(), (IRequestor)installRequestor, this.getProblemFactory());
        }
        catch (InstallException e) {
            EvaluationTest.assertTrue((String)("Target exception: " + e.getMessage()), (boolean)false);
        }
        EvaluationTest.assertEquals((String)"Number of installed variables", (int)expectedNumber, (int)installRequestor.count);
    }

    public boolean isJRockitVM() {
        String vmName = System.getProperty("java.vm.name");
        return vmName != null && vmName.indexOf("JRockit") != -1;
    }

    protected DefaultProblem newProblem(int id, int severity, int startPos, int endPos, int line) {
        return new DefaultProblem(null, null, id, null, severity, startPos, endPos, line, 0);
    }

    public void resetEnv() {
        String encoding = (String)this.getCompilerOptions().get("org.eclipse.jdt.core.encoding");
        if ("".equals(encoding)) {
            encoding = null;
        }
        this.env = new FileSystem(Util.concatWithClassLibs(EvaluationSetup.EVAL_DIRECTORY + File.separator + "regularPath", false), new String[0], encoding);
    }

    @Override
    public void stop() {
        if (this.target != null) {
            this.target.disconnect();
        }
        if (this.launchedVM != null) {
            try {
                int retry = 0;
                while (this.launchedVM.isRunning() && ++retry < 20) {
                    try {
                        Thread.sleep(retry * 100);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.launchedVM.isRunning()) {
                    this.launchedVM.shutDown();
                }
            }
            catch (TargetException targetException) {
                // empty catch block
            }
        }
    }

    public void waitForAutoBuild() {
        if (EvaluationTest.isWorkspaceRuleAlreadyInUse((ISchedulingRule)this.getWorkspaceRoot())) {
            System.out.println("\n\nAborted waitForAutoBuild() because running with the workspace rule\n\n");
            return;
        }
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_BUILD);
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                JavaModelManager.getIndexManager().waitForIndex(this.isIndexDisabledForTest(), null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    private static boolean isWorkspaceRuleAlreadyInUse(ISchedulingRule rule) {
        ISchedulingRule currentJobRule = Job.getJobManager().currentRule();
        boolean workspaceRuleActive = currentJobRule != null && rule.contains(currentJobRule);
        return workspaceRuleActive;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return this.getWorkspace().getRoot();
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public class Requestor
    implements IRequestor {
        public int resultIndex = -1;
        public EvaluationResult[] results = new EvaluationResult[5];

        public boolean acceptClassFiles(ClassFile[] classFiles, char[] codeSnippetClassName) {
            try {
                EvaluationTest.this.target.sendClasses(codeSnippetClassName != null, classFiles);
            }
            catch (TargetException e) {
                return false;
            }
            if (codeSnippetClassName != null) {
                TargetInterface.Result result = EvaluationTest.this.target.getResult();
                if (result.displayString == null) {
                    this.acceptResult(new EvaluationResult(null, 2, null, null));
                } else {
                    this.acceptResult(new EvaluationResult(null, 2, result.displayString, result.typeName));
                }
            } else {
                int i = 0;
                int length = classFiles.length;
                while (i < length) {
                    char[][] compoundName = classFiles[i].getCompoundName();
                    if (new String(compoundName[compoundName.length - 1]).startsWith("GlobalVariable")) {
                        try {
                            IBinaryField[] fields = new ClassFileReader(classFiles[i].getBytes(), null).getFields();
                            if (fields != null) {
                                int j = 0;
                                while (j < fields.length) {
                                    IBinaryField field = fields[j];
                                    if (Modifier.isPublic(field.getModifiers())) {
                                        TargetInterface.Result result = EvaluationTest.this.target.getResult();
                                        if (result.displayString == null) {
                                            this.acceptResult(new EvaluationResult(field.getName(), 1, null, null));
                                        } else {
                                            this.acceptResult(new EvaluationResult(field.getName(), 1, result.displayString, result.typeName));
                                        }
                                    }
                                    ++j;
                                }
                            }
                        }
                        catch (ClassFormatException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
            return true;
        }

        public void acceptProblem(CategorizedProblem problem, char[] fragmentSource, int fragmentKind) {
            this.acceptResult(new EvaluationResult(fragmentSource, fragmentKind, new CategorizedProblem[]{problem}));
        }

        public void acceptResult(EvaluationResult result) {
            try {
                this.results[++this.resultIndex] = result;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                int oldResultLength = this.results.length;
                this.results = new EvaluationResult[oldResultLength * 2];
                System.arraycopy(this.results, 0, this.results, 0, oldResultLength);
                this.results[this.resultIndex] = result;
            }
        }
    }
}

