/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.eval.EvaluationTest;
import org.eclipse.jdt.internal.eval.GlobalVariable;

public class VariableTest
extends EvaluationTest {
    public VariableTest(String name) {
        super(name);
    }

    public static Test suite() {
        return VariableTest.setupSuite(VariableTest.testClass());
    }

    /*
     * Unable to fully structure code
     */
    public void testAllKindOfValues() {
        try {
            var1 = this.context.newVariable("int".toCharArray(), "var1".toCharArray(), "1".toCharArray());
            var2 = this.context.newVariable("boolean".toCharArray(), "var2".toCharArray(), "true".toCharArray());
            var3 = this.context.newVariable("char".toCharArray(), "var3".toCharArray(), "'c'".toCharArray());
            var4 = this.context.newVariable("float".toCharArray(), "var4".toCharArray(), "(float)1.0".toCharArray());
            var5 = this.context.newVariable("double".toCharArray(), "var5".toCharArray(), "1.0".toCharArray());
            var6 = this.context.newVariable("short".toCharArray(), "var6".toCharArray(), "(short)1".toCharArray());
            var7 = this.context.newVariable("long".toCharArray(), "var7".toCharArray(), "(long)1".toCharArray());
            var8 = this.context.newVariable("String".toCharArray(), "var8".toCharArray(), "\"hello\"".toCharArray());
            var9 = this.context.newVariable("Object".toCharArray(), "var9".toCharArray(), this.buildCharArray(new String[]{"new Object() {", "\tpublic String toString() {", "\t\treturn \"an object\";", "\t}", "}"}));
            var10 = this.context.newVariable("Object".toCharArray(), "var10".toCharArray(), null);
            this.installVariables(10);
            this.evaluateWithExpectedValue(var1, "1".toCharArray(), "int".toCharArray());
            this.evaluateWithExpectedValue(var2, "true".toCharArray(), "boolean".toCharArray());
            this.evaluateWithExpectedValue(var3, "c".toCharArray(), "char".toCharArray());
            this.evaluateWithExpectedValue(var4, "1.0".toCharArray(), "float".toCharArray());
            this.evaluateWithExpectedValue(var5, "1.0".toCharArray(), "double".toCharArray());
            this.evaluateWithExpectedValue(var6, "1".toCharArray(), "short".toCharArray());
            this.evaluateWithExpectedValue(var7, "1".toCharArray(), "long".toCharArray());
            this.evaluateWithExpectedValue(var8, "hello".toCharArray(), "java.lang.String".toCharArray());
            this.evaluateWithExpectedValue(var9, "an object".toCharArray(), "java.lang.Object".toCharArray());
            this.evaluateWithExpectedValue(var10, "null".toCharArray(), "java.lang.Object".toCharArray());
        }
        finally {
            vars = this.context.allVariables();
            i = 0;
            ** while (i < vars.length)
        }
lbl-1000:
        // 1 sources

        {
            this.context.deleteVariable(vars[i]);
            ++i;
            continue;
        }
lbl31:
        // 1 sources

    }

    public static Class testClass() {
        return VariableTest.class;
    }

    /*
     * Unable to fully structure code
     */
    public void testCodeSnippetVarAssign() {
        try {
            var1 = this.context.newVariable("int".toCharArray(), "var1".toCharArray(), null);
            var2 = this.context.newVariable("boolean".toCharArray(), "var2".toCharArray(), null);
            var3 = this.context.newVariable("char".toCharArray(), "var3".toCharArray(), null);
            var4 = this.context.newVariable("float".toCharArray(), "var4".toCharArray(), null);
            var5 = this.context.newVariable("double".toCharArray(), "var5".toCharArray(), null);
            var6 = this.context.newVariable("short".toCharArray(), "var6".toCharArray(), null);
            var7 = this.context.newVariable("long".toCharArray(), "var7".toCharArray(), null);
            var8 = this.context.newVariable("String".toCharArray(), "var8".toCharArray(), null);
            var9 = this.context.newVariable("Object".toCharArray(), "var9".toCharArray(), null);
            var10 = this.context.newVariable("Object".toCharArray(), "var10".toCharArray(), null);
            this.installVariables(10);
            this.evaluateWithExpectedDisplayString("var1 = 1;".toCharArray(), "1".toCharArray());
            this.evaluateWithExpectedValue(var1, "1".toCharArray(), "int".toCharArray());
            this.evaluateWithExpectedDisplayString("var2 = true;".toCharArray(), "true".toCharArray());
            this.evaluateWithExpectedValue(var2, "true".toCharArray(), "boolean".toCharArray());
            this.evaluateWithExpectedDisplayString("var3 = 'c';".toCharArray(), "c".toCharArray());
            this.evaluateWithExpectedValue(var3, "c".toCharArray(), "char".toCharArray());
            this.evaluateWithExpectedDisplayString("var4 = (float)1.0;".toCharArray(), "1.0".toCharArray());
            this.evaluateWithExpectedValue(var4, "1.0".toCharArray(), "float".toCharArray());
            this.evaluateWithExpectedDisplayString("var5 = 1.0;".toCharArray(), "1.0".toCharArray());
            this.evaluateWithExpectedValue(var5, "1.0".toCharArray(), "double".toCharArray());
            this.evaluateWithExpectedDisplayString("var6 = (short)1;".toCharArray(), "1".toCharArray());
            this.evaluateWithExpectedValue(var6, "1".toCharArray(), "short".toCharArray());
            this.evaluateWithExpectedDisplayString("var7 = (long)1;".toCharArray(), "1".toCharArray());
            this.evaluateWithExpectedValue(var7, "1".toCharArray(), "long".toCharArray());
            this.evaluateWithExpectedDisplayString("var8 = \"hello\";".toCharArray(), "hello".toCharArray());
            this.evaluateWithExpectedValue(var8, "hello".toCharArray(), "java.lang.String".toCharArray());
            this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"var9 = new Object() {", "\tpublic String toString() {", "\t\treturn \"an object\";", "\t}", "};"}), "an object".toCharArray());
            this.evaluateWithExpectedValue(var9, "an object".toCharArray(), "java.lang.Object".toCharArray());
            this.evaluateWithExpectedDisplayString("var10 = null;".toCharArray(), "null".toCharArray());
            this.evaluateWithExpectedValue(var10, "null".toCharArray(), "java.lang.Object".toCharArray());
        }
        finally {
            vars = this.context.allVariables();
            i = 0;
            ** while (i < vars.length)
        }
lbl-1000:
        // 1 sources

        {
            this.context.deleteVariable(vars[i]);
            ++i;
            continue;
        }
lbl41:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public void testCodeSnippetVarRetrieval() {
        try {
            var1 = this.context.newVariable("int".toCharArray(), "var1".toCharArray(), "1".toCharArray());
            var2 = this.context.newVariable("boolean".toCharArray(), "var2".toCharArray(), "true".toCharArray());
            var3 = this.context.newVariable("char".toCharArray(), "var3".toCharArray(), "'c'".toCharArray());
            var4 = this.context.newVariable("float".toCharArray(), "var4".toCharArray(), "(float)1.0".toCharArray());
            var5 = this.context.newVariable("double".toCharArray(), "var5".toCharArray(), "1.0".toCharArray());
            var6 = this.context.newVariable("short".toCharArray(), "var6".toCharArray(), "(short)1".toCharArray());
            var7 = this.context.newVariable("long".toCharArray(), "var7".toCharArray(), "(long)1".toCharArray());
            var8 = this.context.newVariable("String".toCharArray(), "var8".toCharArray(), "\"hello\"".toCharArray());
            var9 = this.context.newVariable("Object".toCharArray(), "var9".toCharArray(), this.buildCharArray(new String[]{"new Object() {", "\tpublic String toString() {", "\t\treturn \"an object\";", "\t}", "}"}));
            var10 = this.context.newVariable("Object".toCharArray(), "var10".toCharArray(), null);
            this.installVariables(10);
            this.evaluateWithExpectedValue(var1, "1".toCharArray(), "int".toCharArray());
            this.evaluateWithExpectedValue(var2, "true".toCharArray(), "boolean".toCharArray());
            this.evaluateWithExpectedValue(var3, "c".toCharArray(), "char".toCharArray());
            this.evaluateWithExpectedValue(var4, "1.0".toCharArray(), "float".toCharArray());
            this.evaluateWithExpectedValue(var5, "1.0".toCharArray(), "double".toCharArray());
            this.evaluateWithExpectedValue(var6, "1".toCharArray(), "short".toCharArray());
            this.evaluateWithExpectedValue(var7, "1".toCharArray(), "long".toCharArray());
            this.evaluateWithExpectedValue(var8, "hello".toCharArray(), "java.lang.String".toCharArray());
            this.evaluateWithExpectedValue(var9, "an object".toCharArray(), "java.lang.Object".toCharArray());
            this.evaluateWithExpectedValue(var10, "null".toCharArray(), "java.lang.Object".toCharArray());
        }
        finally {
            vars = this.context.allVariables();
            i = 0;
            ** while (i < vars.length)
        }
lbl-1000:
        // 1 sources

        {
            this.context.deleteVariable(vars[i]);
            ++i;
            continue;
        }
lbl31:
        // 1 sources

    }

    public void testImports() {
        try {
            this.context.setImports((char[][])new char[][]{"java.io.*".toCharArray()});
            GlobalVariable file = this.context.newVariable("boolean".toCharArray(), "file".toCharArray(), "new File(\"!@#%\").exists()".toCharArray());
            this.installVariables(1);
            this.evaluateWithExpectedValue(file, "false".toCharArray(), "boolean".toCharArray());
            this.context.deleteVariable(file);
            this.context.setImports((char[][])new char[][]{"java.math.BigInteger".toCharArray()});
            GlobalVariable big = this.context.newVariable("BigInteger".toCharArray(), "big".toCharArray(), "new BigInteger(\"123456789012345678901234567890\")".toCharArray());
            this.installVariables(1);
            this.evaluateWithExpectedValue(big, "123456789012345678901234567890".toCharArray(), "java.math.BigInteger".toCharArray());
            this.context.deleteVariable(big);
            this.context.setImports((char[][])new char[][]{"java.util.Enumeration".toCharArray(), "java.lang.reflect.*".toCharArray()});
            GlobalVariable fields = this.context.newVariable("Field[]".toCharArray(), "fields".toCharArray(), "Enumeration.class.getDeclaredFields()".toCharArray());
            this.installVariables(1);
            this.evaluateWithExpectedType("return fields;".toCharArray(), "[Ljava.lang.reflect.Field;".toCharArray());
            this.context.deleteVariable(fields);
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void testSeveralVariableInstallations() {
        try {
            var1 = this.context.newVariable("int".toCharArray(), "var1".toCharArray(), "1".toCharArray());
            var2 = this.context.newVariable("boolean".toCharArray(), "var2".toCharArray(), "true".toCharArray());
            var3 = this.context.newVariable("char".toCharArray(), "var3".toCharArray(), "'c'".toCharArray());
            var4 = this.context.newVariable("float".toCharArray(), "var4".toCharArray(), "(float)1.0".toCharArray());
            var5 = this.context.newVariable("double".toCharArray(), "var5".toCharArray(), "1.0".toCharArray());
            var6 = this.context.newVariable("short".toCharArray(), "var6".toCharArray(), "(short)1".toCharArray());
            this.installVariables(6);
            this.evaluateWithExpectedValue(var1, "1".toCharArray(), "int".toCharArray());
            this.evaluateWithExpectedValue(var2, "true".toCharArray(), "boolean".toCharArray());
            this.evaluateWithExpectedValue(var3, "c".toCharArray(), "char".toCharArray());
            this.evaluateWithExpectedValue(var4, "1.0".toCharArray(), "float".toCharArray());
            this.evaluateWithExpectedValue(var5, "1.0".toCharArray(), "double".toCharArray());
            this.evaluateWithExpectedValue(var6, "1".toCharArray(), "short".toCharArray());
            this.context.deleteVariable(var2);
            this.context.deleteVariable(var5);
            this.context.deleteVariable(var6);
            this.installVariables(3);
            this.evaluateWithExpectedValue(var1, "1".toCharArray(), "int".toCharArray());
            this.evaluateWithExpectedValue(var3, "c".toCharArray(), "char".toCharArray());
            this.evaluateWithExpectedValue(var4, "1.0".toCharArray(), "float".toCharArray());
            var7 = this.context.newVariable("long".toCharArray(), "var7".toCharArray(), "(long)1".toCharArray());
            var8 = this.context.newVariable("String".toCharArray(), "var8".toCharArray(), "\"hello\"".toCharArray());
            var9 = this.context.newVariable("Object".toCharArray(), "var9".toCharArray(), this.buildCharArray(new String[]{"new Object() {", "\tpublic String toString() {", "\t\treturn \"an object\";", "\t}", "}"}));
            var10 = this.context.newVariable("Object".toCharArray(), "var10".toCharArray(), null);
            this.installVariables(7);
            this.evaluateWithExpectedValue("var3 = 'z'; return var3;".toCharArray(), "z".toCharArray(), "char".toCharArray());
            this.context.deleteVariable(var3);
            this.context.deleteVariable(var4);
            this.installVariables(5);
            var3 = this.context.newVariable(var3.getTypeName(), var3.getName(), var3.getInitializer());
            var4 = this.context.newVariable("java.net.URI".toCharArray(), "var4".toCharArray(), "new java.net.URI(\"http://www.ibm.com/index.html\")".toCharArray());
            this.installVariables(7);
            this.evaluateWithExpectedValue(var1, "1".toCharArray(), "int".toCharArray());
            this.evaluateWithExpectedValue(var3, "c".toCharArray(), "char".toCharArray());
            this.evaluateWithExpectedValue(var4, "http://www.ibm.com/index.html".toCharArray(), "java.net.URI".toCharArray());
            this.evaluateWithExpectedValue(var7, "1".toCharArray(), "long".toCharArray());
            this.evaluateWithExpectedValue(var8, "hello".toCharArray(), "java.lang.String".toCharArray());
            this.evaluateWithExpectedValue(var9, "an object".toCharArray(), "java.lang.Object".toCharArray());
            this.evaluateWithExpectedValue(var10, "null".toCharArray(), "java.lang.Object".toCharArray());
        }
        finally {
            vars = this.context.allVariables();
            i = 0;
            ** while (i < vars.length)
        }
lbl-1000:
        // 1 sources

        {
            this.context.deleteVariable(vars[i]);
            ++i;
            continue;
        }
lbl49:
        // 1 sources

    }
}

