/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.runtime;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jdt.core.tests.runtime.J9VirtualMachine;
import org.eclipse.jdt.core.tests.runtime.LocalVMLauncher;
import org.eclipse.jdt.core.tests.runtime.LocalVirtualMachine;
import org.eclipse.jdt.core.tests.runtime.TargetException;
import org.eclipse.jdt.core.tests.util.Util;

public class J9VMLauncher
extends LocalVMLauncher {
    int internalDebugPort = -1;
    String proxyOutFile;
    String symbolPath;

    protected String buildBootClassPath() {
        StringBuilder bootPathString = new StringBuilder();
        char pathSeparator = File.pathSeparatorChar;
        if (this.bootPath != null) {
            int length = this.bootPath.length;
            int i = 0;
            while (i < length) {
                bootPathString.append(this.bootPath[i]);
                bootPathString.append(pathSeparator);
                ++i;
            }
        } else {
            bootPathString.append(this.vmPath);
            bootPathString.append(File.separator);
            bootPathString.append("lib");
            bootPathString.append(File.separator);
            bootPathString.append("jclMax");
            bootPathString.append(File.separator);
            bootPathString.append("classes.zip");
            bootPathString.append(pathSeparator);
        }
        if (this.evalTargetPath != null) {
            bootPathString.append(this.evalTargetPath);
            bootPathString.append(File.separatorChar);
            bootPathString.append("bootPath");
        }
        return bootPathString.toString();
    }

    @Override
    protected Process execCommandLine() throws TargetException {
        if (this.debugPort != -1 && this.internalDebugPort == -1) {
            throw new TargetException("Internal debug port has not been specified");
        }
        return super.execCommandLine();
    }

    @Override
    public String[] getCommandLine() {
        int i;
        ArrayList<Object> commandLine = new ArrayList<Object>();
        commandLine.add(this.vmPath + (this.vmPath.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "j9");
        if (this.vmArguments != null) {
            i = 0;
            while (i < this.vmArguments.length) {
                commandLine.add(this.vmArguments[i]);
                ++i;
            }
        }
        if (this.debugPort != -1 && this.internalDebugPort != -1) {
            commandLine.add("-debug:" + this.internalDebugPort);
        }
        commandLine.add("-Xbootclasspath:" + this.buildBootClassPath());
        commandLine.add("-classpath");
        commandLine.add(this.buildClassPath());
        if (this.evalPort != -1) {
            commandLine.add("org.eclipse.jdt.core.tests.eval.target.CodeSnippetRunner");
        }
        if (this.evalPort != -1) {
            commandLine.add("-evalport");
            commandLine.add(Integer.toString(this.evalPort));
            commandLine.add("-cscp");
            commandLine.add(this.evalTargetPath + File.separator + "regularPath");
            commandLine.add("-csbp");
            commandLine.add(this.evalTargetPath + File.separator + "bootPath");
        }
        if (this.programClass != null) {
            commandLine.add(this.programClass);
        }
        if (this.programArguments != null) {
            i = 0;
            while (i < this.programArguments.length) {
                commandLine.add(this.programArguments[i]);
                ++i;
            }
        }
        String[] result = new String[commandLine.size()];
        commandLine.toArray(result);
        int i2 = 0;
        while (i2 < result.length) {
            String argument = result[i2];
            if (argument.indexOf(32) != -1) {
                result[i2] = "\"" + argument + "\"";
            }
            ++i2;
        }
        return result;
    }

    public int getInternalDebugPort() {
        return this.internalDebugPort;
    }

    public String[] getProxyCommandLine() {
        ArrayList<Object> commandLine = new ArrayList<Object>();
        commandLine.add(this.vmPath + (this.vmPath.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "j9proxy");
        commandLine.add(this.getTargetAddress() + ":" + this.internalDebugPort);
        commandLine.add(Integer.toString(this.debugPort));
        if (this.symbolPath != null && this.symbolPath != "") {
            commandLine.add(this.symbolPath);
        }
        String[] result = new String[commandLine.size()];
        commandLine.toArray(result);
        return result;
    }

    public String getProxyOutFile() {
        return this.proxyOutFile;
    }

    public String getSymbolPath() {
        return this.symbolPath;
    }

    @Override
    public LocalVirtualMachine launch() throws TargetException {
        LocalVirtualMachine localVM = super.launch();
        Process proxyProcess = null;
        if (this.debugPort != -1) {
            try {
                String[] commandLine = this.getProxyCommandLine();
                proxyProcess = Runtime.getRuntime().exec(commandLine);
            }
            catch (IOException e) {
                localVM.shutDown();
                throw new TargetException("Error launching J9 Proxy at " + this.vmPath);
            }
        }
        Process vmProcess = localVM.process;
        this.runningVMs.remove(localVM);
        J9VirtualMachine vm = new J9VirtualMachine(vmProcess, this.debugPort, this.evalTargetPath, proxyProcess, this.proxyOutFile);
        this.runningVMs.add(vm);
        return vm;
    }

    @Override
    public void setDebugPort(int debugPort) {
        super.setDebugPort(debugPort);
        this.setInternalDebugPort(Util.getFreePort());
    }

    public void setInternalDebugPort(int internalDebugPort) {
        this.internalDebugPort = internalDebugPort;
    }

    public void setProxyOutFile(String proxyOutFile) {
        this.proxyOutFile = proxyOutFile;
    }

    public void setSymbolPath(String symbolPath) {
        this.symbolPath = symbolPath;
    }
}

