/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.tests.runtime.LocalVMLauncher;

public class JRockitVMLauncher
extends LocalVMLauncher {
    String batchFileName;

    protected String buildBootClassPath() {
        StringBuilder bootPathString = new StringBuilder();
        if (this.evalTargetPath != null) {
            bootPathString.append(this.evalTargetPath);
            bootPathString.append(File.separatorChar);
            bootPathString.append("bootPath");
        }
        return bootPathString.toString();
    }

    public String getBatchFileName() {
        return this.batchFileName;
    }

    @Override
    public String[] getCommandLine() {
        String[] result;
        ArrayList<String> commandLine = new ArrayList<String>();
        if (System.getProperty("java.vm.version").startsWith("1.4.2")) {
            commandLine.add(this.vmPath + (this.vmPath.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "java");
        } else {
            String vmLocation = this.vmPath + (this.vmPath.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "javaw";
            String osName = System.getProperty("os.name");
            if (osName.indexOf("win32") != -1) {
                vmLocation = vmLocation + ".exe";
            }
            if (!new File(vmLocation).exists()) {
                vmLocation = this.vmPath + (this.vmPath.endsWith(File.separator) ? "" : File.separator) + "bin" + File.separator + "java";
            }
            commandLine.add(vmLocation);
        }
        if (this.vmArguments != null) {
            int i = 0;
            while (i < this.vmArguments.length) {
                commandLine.add(this.vmArguments[i]);
                ++i;
            }
        }
        if (this.debugPort != -1) {
            commandLine.add("-Xdebug");
            commandLine.add("-Xnoagent");
            commandLine.add("-Xrunjdwp:transport=dt_socket,address=" + this.debugPort + ",server=y,suspend=n");
        }
        commandLine.add("-classpath");
        String classpath = this.buildBootClassPath() + File.pathSeparator + this.buildClassPath();
        System.out.println(classpath);
        commandLine.add(classpath);
        if (this.evalPort != -1) {
            commandLine.add("org.eclipse.jdt.core.tests.eval.target.CodeSnippetRunner");
        }
        if (this.evalPort != -1) {
            commandLine.add("-evalport");
            commandLine.add(Integer.toString(this.evalPort));
            commandLine.add("-cscp");
            commandLine.add(this.evalTargetPath + File.separator + "regularPath");
            commandLine.add("-csbp");
            commandLine.add(this.evalTargetPath + File.separator + "bootPath");
        }
        if (this.programClass != null) {
            commandLine.add(this.programClass);
        }
        if (this.programArguments != null) {
            int i = 0;
            while (i < this.programArguments.length) {
                commandLine.add(this.programArguments[i]);
                ++i;
            }
        }
        if (this.batchFileName != null) {
            this.writeBatchFile(this.batchFileName, commandLine);
            result = new String[]{this.batchFileName};
        } else {
            result = new String[commandLine.size()];
            commandLine.toArray(result);
        }
        int i = 0;
        while (i < result.length) {
            String argument = result[i];
            if (argument.indexOf(32) != -1) {
                result[i] = "\"" + argument + "\"";
            }
            ++i;
        }
        return result;
    }

    public void setBatchFileName(String batchFileName) {
        this.batchFileName = batchFileName;
    }

    protected void writeBatchFile(String fileName, List<String> commandLine) {
        block13: {
            FileOutputStream output = null;
            try {
                try {
                    output = new FileOutputStream(fileName);
                    PrintWriter out = new PrintWriter(output);
                    for (String string : commandLine) {
                        out.print(string);
                        out.print(" ");
                    }
                    out.println("pause");
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (output == null) break block13;
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

