/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.tests.runtime.LocalVMLauncher;
import org.eclipse.jdt.core.tests.util.Util;

public class StandardVMLauncher
extends LocalVMLauncher {
    String batchFileName;
    private boolean isJrtBasedVM;

    public StandardVMLauncher(boolean isJrtBasedVM) {
        this.isJrtBasedVM = isJrtBasedVM;
    }

    public StandardVMLauncher() {
    }

    protected String buildBootClassPath() {
        StringBuilder bootPathString = new StringBuilder();
        char pathSeparator = File.pathSeparatorChar;
        if (this.bootPath != null) {
            int length = this.bootPath.length;
            int i = 0;
            while (i < length) {
                bootPathString.append(this.bootPath[i]);
                bootPathString.append(pathSeparator);
                ++i;
            }
        } else if (!this.isJrtBasedVM) {
            bootPathString.append(this.vmPath);
            bootPathString.append(File.separator);
            if (!this.vmPath.toLowerCase().endsWith("jre") && !this.vmPath.toLowerCase().endsWith("jre" + File.separator)) {
                bootPathString.append("jre");
                bootPathString.append(File.separator);
            }
            bootPathString.append("lib");
            bootPathString.append(File.separator);
            bootPathString.append("rt.jar");
            bootPathString.append(pathSeparator);
        }
        if (this.evalTargetPath != null) {
            bootPathString.append(this.evalTargetPath);
            bootPathString.append(File.separatorChar);
            bootPathString.append("bootPath");
        }
        return bootPathString.toString();
    }

    public String getBatchFileName() {
        return this.batchFileName;
    }

    @Override
    public String[] getCommandLine() {
        String[] result;
        long vmVersion;
        ArrayList<String> commandLine = new ArrayList<String>();
        StringBuilder vmLocation = new StringBuilder(this.vmPath);
        vmLocation.append(this.vmPath.endsWith(File.separator) ? "" : File.separator).append("bin").append(File.separator).append("java");
        commandLine.add(String.valueOf(vmLocation));
        if (this.vmArguments != null) {
            int i = 0;
            while (i < this.vmArguments.length) {
                commandLine.add(this.vmArguments[i]);
                ++i;
            }
        }
        if ((vmVersion = Util.getMajorMinorVMVersion()) != -1L) {
            if (vmVersion < 0x390000L) {
                commandLine.add("-XX:-FailOverToOldVerifier");
            }
            commandLine.add("-Xverify:all");
            commandLine.add("-XX:+UnlockExperimentalVMOptions");
        }
        if (this.debugPort != -1) {
            this.addDebugOptions(commandLine);
            this.addXnoagent(commandLine);
            commandLine.add("-Xrunjdwp:transport=dt_socket,address=" + this.debugPort + ",server=y,suspend=n");
        }
        commandLine.add("-Xbootclasspath/a:" + this.buildBootClassPath());
        commandLine.add("-classpath");
        commandLine.add(this.buildClassPath());
        if (this.evalPort != -1) {
            commandLine.add("org.eclipse.jdt.core.tests.eval.target.CodeSnippetRunner");
        }
        if (this.evalPort != -1) {
            commandLine.add("-evalport");
            commandLine.add(Integer.toString(this.evalPort));
            commandLine.add("-cscp");
            commandLine.add(this.evalTargetPath + File.separator + "regularPath");
            commandLine.add("-csbp");
            commandLine.add(this.evalTargetPath + File.separator + "bootPath");
        }
        if (this.programClass != null) {
            commandLine.add(this.programClass);
        }
        if (this.programArguments != null) {
            int i = 0;
            while (i < this.programArguments.length) {
                commandLine.add(this.programArguments[i]);
                ++i;
            }
        }
        if (this.batchFileName != null) {
            this.writeBatchFile(this.batchFileName, commandLine);
            result = new String[]{this.batchFileName};
        } else {
            result = new String[commandLine.size()];
            commandLine.toArray(result);
        }
        int i = 0;
        while (i < result.length) {
            String argument = result[i];
            if (argument.indexOf(32) != -1) {
                result[i] = "\"" + argument + "\"";
            }
            ++i;
        }
        return result;
    }

    private void addXnoagent(List<String> commandLine) {
        long vmVersion = Util.getMajorMinorVMVersion();
        if (vmVersion != -1L && vmVersion < 0x420000L) {
            commandLine.add("-Xnoagent");
        }
    }

    public void setBatchFileName(String batchFileName) {
        this.batchFileName = batchFileName;
    }

    protected void writeBatchFile(String fileName, List<String> commandLine) {
        block13: {
            FileOutputStream output = null;
            try {
                try {
                    output = new FileOutputStream(fileName);
                    PrintWriter out = new PrintWriter(output);
                    for (String string : commandLine) {
                        out.print(string);
                        out.print(" ");
                    }
                    out.println("pause");
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (output == null) break block13;
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

