/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.runtime;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.jdt.core.tests.runtime.TargetException;
import org.eclipse.jdt.internal.compiler.ClassFile;

public class TargetInterface {
    static final boolean DEBUG = false;
    String codeSnippetClassName;
    static final boolean TIMING = false;
    private long sentTimeNanos;
    Socket socket;

    public void connect(ServerSocket server, int timeoutMs) {
        if (this.isConnected()) {
            return;
        }
        if (server != null) {
            long timeoutNanos = System.nanoTime() + (long)timeoutMs * 1000000L;
            while (true) {
                try {
                    this.socket = server.accept();
                    this.socket.setTcpNoDelay(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (this.socket != null) continue;
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.isConnected() && System.nanoTime() < timeoutNanos) continue;
                }
                break;
            }
        }
    }

    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.socket = null;
        }
    }

    public Result getResult() {
        String toString;
        String typeName;
        block5: {
            boolean hasValue = false;
            typeName = null;
            toString = null;
            if (this.isConnected()) {
                try {
                    DataInputStream in = new DataInputStream(this.socket.getInputStream());
                    hasValue = in.readBoolean();
                    if (hasValue) {
                        typeName = in.readUTF();
                        toString = in.readUTF();
                        break block5;
                    }
                    typeName = null;
                    toString = null;
                }
                catch (IOException e) {
                    hasValue = true;
                    typeName = e.getMessage();
                    toString = "";
                    this.disconnect();
                }
            } else {
                hasValue = true;
                typeName = "Connection has been lost";
                toString = "";
            }
        }
        Result result = new Result();
        result.displayString = toString == null ? null : toString.toCharArray();
        result.typeName = typeName == null ? null : typeName.toCharArray();
        return result;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public void sendClasses(boolean mustRun, ClassFile[] classes) throws TargetException {
        if (!this.isConnected()) {
            throw new TargetException("Connection to the target VM has been lost");
        }
        try {
            DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
            out.writeBoolean(mustRun);
            out.writeInt(classes.length);
            int i = 0;
            while (i < classes.length) {
                byte[] classDefinition = classes[i].getBytes();
                out.writeInt(classDefinition.length);
                out.write(classDefinition);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.disconnect();
        }
    }

    public static class Result {
        public char[] displayString;
        public char[] typeName;
    }
}

