/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.runtime;

import java.io.IOException;
import java.io.InputStream;

public class VMInputStream
extends InputStream {
    InputStream input;
    Process process;

    public VMInputStream(Process process, InputStream input) {
        this.process = process;
        this.input = input;
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private boolean isRunning() {
        boolean hasExited;
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
            hasExited = true;
        }
        catch (IllegalThreadStateException e) {
            hasExited = false;
        }
        return !hasExited;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.input.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.input.markSupported();
    }

    @Override
    public int read() throws IOException {
        try {
            return this.input.read();
        }
        catch (IOException e) {
            if (this.isRunning()) {
                return this.read();
            }
            throw e;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b) throws IOException {
        int read;
        block5: {
            block4: {
                int i = 0;
                while (i < b.length) {
                    b[i] = 0;
                    ++i;
                }
                try {
                    return this.input.read(b);
                }
                catch (IOException e) {
                    if (!this.isRunning()) throw e;
                    read = 0;
                    if (!true) break block4;
                    if (read >= b.length) return read;
                    if (b[read] == 0) break block5;
                }
            }
            do {
                ++read;
                if (read >= b.length) return read;
            } while (b[read] != 0);
        }
        return read;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        block5: {
            block4: {
                int i = off;
                while (i < len) {
                    b[i] = 0;
                    ++i;
                }
                try {
                    return this.input.read(b, off, len);
                }
                catch (IOException e) {
                    if (!this.isRunning()) throw e;
                    read = 0;
                    if (!true) break block4;
                    if (off + read >= len) return read;
                    if (b[off + read] == 0) break block5;
                }
            }
            do {
                ++read;
                if (off + read >= len) return read;
            } while (b[off + read] != 0);
        }
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.input.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.input.skip(n);
    }
}

