/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.tests.compiler.regression.RegressionTestSetup;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;
import org.eclipse.jdt.core.tests.util.PreviewTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class AbstractCompilerTest
extends TestCase {
    public static final int F_1_8 = 32;
    public static final int F_9 = 64;
    public static final int F_10 = 128;
    public static final int F_11 = 256;
    public static final int F_12 = 512;
    public static final int F_13 = 1024;
    public static final int F_14 = 2048;
    public static final int F_15 = 4096;
    public static final int F_16 = 8192;
    public static final int F_17 = 16384;
    public static final int F_18 = 32768;
    public static final int F_19 = 65536;
    public static final int F_20 = 131072;
    public static final int F_21 = 262144;
    public static final int F_22 = 524288;
    public static final int F_23 = 0x100000;
    public static final int F_24 = 0x200000;
    public static final int FIRST_SUPPORTED_JAVA_VERSION = 32;
    public static final boolean RUN_JAVAC = "enabled".equals(System.getProperty("run.javac"));
    public static final boolean RUN_JAVAC_OPT_IN = "optin".equalsIgnoreCase(System.getProperty("run.javac"));
    protected boolean runJavacOptIn = false;
    public static final boolean PERFORMANCE_ASSERTS = !"disabled".equals(System.getProperty("jdt.performance.asserts"));
    private static final int UNINITIALIZED = -1;
    private static final int NONE = 0;
    private static int possibleComplianceLevels = -1;
    protected long complianceLevel;
    protected boolean enableAPT = false;
    protected boolean enablePreview = false;
    protected static boolean isJRE9Plus = false;
    protected static boolean isJRE10Plus = false;
    protected static boolean isJRE11Plus = false;
    protected static boolean isJRE12Plus = false;
    protected static boolean isJRE13Plus = false;
    protected static boolean isJRE14Plus = false;
    protected static boolean isJRE15Plus = false;
    protected static boolean isJRE16Plus = false;
    protected static boolean isJRE17Plus = false;
    protected static boolean isJRE18Plus = false;
    protected static boolean isJRE19Plus = false;
    protected static boolean isJRE20Plus = false;
    protected static boolean isJRE21Plus = false;
    protected static boolean isJRE22Plus = false;
    protected static boolean isJRE23Plus = false;
    protected static boolean isJRE24Plus = false;
    protected static boolean reflectNestedClassUseDollar;
    public static int[][] complianceTestLevelMapping;
    protected IPath outputRootDirectoryPath = new Path(Util.getOutputDirectory());
    protected File outputTestDirectory;
    protected static Map TESTS_COUNTERS;

    static {
        complianceTestLevelMapping = new int[][]{{32, 52}, {64, 53}, {128, 54}, {256, 55}, {512, 56}, {1024, 57}, {2048, 58}, {4096, 59}, {8192, 60}, {16384, 61}, {32768, 62}, {65536, 63}, {131072, 64}, {262144, 65}, {524288, 66}, {0x100000, 67}, {0x200000, 68}};
        TESTS_COUNTERS = new HashMap();
    }

    public static Test buildAllCompliancesTestSuite(Class evaluationTestClass) {
        TestSuite suite = new TestSuite(evaluationTestClass.getName());
        AbstractCompilerTest.buildAllCompliancesTestSuite(suite, evaluationTestClass);
        return suite;
    }

    public static void buildAllCompliancesTestSuite(TestSuite suite, Class evaluationTestClass) {
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        int[][] nArray = complianceTestLevelMapping;
        int n = complianceTestLevelMapping.length;
        int n2 = 0;
        while (n2 < n) {
            int[] map = nArray[n2];
            if ((complianceLevels & map[0]) != 0) {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, ClassFileConstants.getComplianceLevelForJavaVersion((int)map[1])));
            }
            ++n2;
        }
    }

    public static Test buildAllCompliancesTestSuite(Class testSuiteClass, Class setupClass, List testClasses) {
        TestSuite suite = new TestSuite(testSuiteClass.getName());
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        int[][] nArray = complianceTestLevelMapping;
        int n = complianceTestLevelMapping.length;
        int n2 = 0;
        while (n2 < n) {
            int[] map = nArray[n2];
            if ((complianceLevels & map[0]) != 0) {
                suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, ClassFileConstants.getComplianceLevelForJavaVersion((int)map[1])));
            }
            ++n2;
        }
        return suite;
    }

    public static void setpossibleComplianceLevels(int complianceLevel) {
        possibleComplianceLevels = complianceLevel;
    }

    public static Test buildComplianceTestSuite(long complianceLevel, List testClasses) {
        return AbstractCompilerTest.buildComplianceTestSuite(testClasses, RegressionTestSetup.class, complianceLevel);
    }

    private static Test buildComplianceTestSuite(List testClasses, Class setupClass, long complianceLevel) {
        TestSuite complianceSuite = null;
        try {
            Constructor constructor = setupClass.getConstructor(Long.TYPE);
            complianceSuite = (TestSuite)constructor.newInstance(complianceLevel);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (complianceSuite == null) {
            return null;
        }
        String specVersion = System.getProperty("java.specification.version");
        int spec = Integer.parseInt(specVersion);
        boolean futureJREUsed = spec > Integer.parseInt(CompilerOptions.getLatestVersion());
        int i = 0;
        int m = testClasses.size();
        while (i < m) {
            PreviewTest annotation;
            Class testClass = (Class)testClasses.get(i);
            if (!futureJREUsed || (annotation = testClass.getAnnotation(PreviewTest.class)) == null) {
                TestSuite suite = new TestSuite(testClass.getName());
                int inheritedDepth = 0;
                try {
                    Field depthField = testClass.getDeclaredField("INHERITED_DEPTH");
                    if (depthField != null) {
                        inheritedDepth = depthField.getInt(null);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException depthField) {
                    // empty catch block
                }
                List tests = AbstractCompilerTest.buildTestsList(testClass, inheritedDepth, ORDERING);
                int index = 0;
                int size = tests.size();
                while (index < size) {
                    suite.addTest((Test)tests.get(index));
                    ++index;
                }
                complianceSuite.addTest((Test)suite);
            }
            ++i;
        }
        return complianceSuite;
    }

    public static Test buildMinimalComplianceTestSuite(Class evaluationTestClass, int minimalCompliance) {
        TestSuite suite = new TestSuite(evaluationTestClass.getName());
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        int[][] nArray = complianceTestLevelMapping;
        int n = complianceTestLevelMapping.length;
        int n2 = 0;
        while (n2 < n) {
            int[] map = nArray[n2];
            if ((complianceLevels & map[0]) != 0) {
                long complianceLevelForJavaVersion = ClassFileConstants.getComplianceLevelForJavaVersion((int)map[1]);
                AbstractCompilerTest.checkCompliance(evaluationTestClass, minimalCompliance, suite, complianceLevels, map[0], map[1], AbstractCompilerTest.getVersionString(complianceLevelForJavaVersion));
            }
            ++n2;
        }
        return suite;
    }

    protected static void checkCompliance(Class evaluationTestClass, int minimalCompliance, TestSuite suite, int complianceLevels, int abstractCompilerTestCompliance, int classFileConstantsVersion, String release) {
        int lev = complianceLevels & abstractCompilerTestCompliance;
        if (lev != 0) {
            if (lev < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + release + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, ClassFileConstants.getComplianceLevelForJavaVersion((int)classFileConstantsVersion)));
            }
        }
    }

    public static Test buildUniqueComplianceTestSuite(Class evaluationTestClass, long uniqueCompliance) {
        long highestLevel = AbstractCompilerTest.highestComplianceLevels();
        if (highestLevel < uniqueCompliance) {
            String complianceString = highestLevel == 0x360000L ? "10" : (highestLevel == 0x350000L ? "9" : (highestLevel == 0x340000L ? "1.8" : ((highestLevel = ClassFileConstants.getLatestJDKLevel()) > 0L ? CompilerOptions.versionFromJdkLevel((long)highestLevel) : "unknown")));
            System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + complianceString + "!");
            return new TestSuite();
        }
        RegressionTestSetup complianceSuite = new RegressionTestSetup(uniqueCompliance);
        List tests = AbstractCompilerTest.buildTestsList(evaluationTestClass);
        int index = 0;
        int size = tests.size();
        while (index < size) {
            complianceSuite.addTest((Test)tests.get(index));
            ++index;
        }
        return complianceSuite;
    }

    public static long highestComplianceLevels() {
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        int size = complianceTestLevelMapping.length;
        int i = size - 1;
        while (i >= 0) {
            int[] map = complianceTestLevelMapping[i];
            if ((complianceLevels & map[0]) != 0) {
                return ClassFileConstants.getComplianceLevelForJavaVersion((int)map[1]);
            }
            --i;
        }
        return CompilerOptions.getFirstSupportedJdkLevel();
    }

    static void initReflectionVersion() {
        if (isJRE9Plus) {
            reflectNestedClassUseDollar = true;
            System.out.println("reflectNestedClassUseDollar=" + reflectNestedClassUseDollar + " due to isJRE9Plus");
        } else {
            String version = System.getProperty("java.version");
            if (version.startsWith("1.8.0_")) {
                int build = Integer.parseInt(version.substring("1.8.0_".length()));
                reflectNestedClassUseDollar = build >= 171;
            } else if (version.startsWith("1.8.0-")) {
                reflectNestedClassUseDollar = true;
            } else {
                throw new IllegalStateException("Unrecognized Java version: " + version);
            }
            System.out.println("reflectNestedClassUseDollar=" + reflectNestedClassUseDollar + " based on version=" + version);
        }
    }

    public static int getPossibleComplianceLevels() {
        if (possibleComplianceLevels == -1) {
            String specVersion = System.getProperty("java.specification.version");
            int spec = Integer.parseInt(specVersion);
            if (spec > Integer.parseInt(CompilerOptions.getLatestVersion())) {
                specVersion = CompilerOptions.getLatestVersion();
            }
            isJRE23Plus = (isJRE24Plus = "24".equals(specVersion)) || "23".equals(specVersion);
            isJRE22Plus = isJRE23Plus || "22".equals(specVersion);
            isJRE21Plus = isJRE22Plus || "21".equals(specVersion);
            isJRE20Plus = isJRE21Plus || "20".equals(specVersion);
            isJRE19Plus = isJRE20Plus || "19".equals(specVersion);
            isJRE18Plus = isJRE19Plus || "18".equals(specVersion);
            isJRE17Plus = isJRE18Plus || "17".equals(specVersion);
            isJRE16Plus = isJRE17Plus || "16".equals(specVersion);
            isJRE15Plus = isJRE16Plus || "15".equals(specVersion);
            isJRE14Plus = isJRE15Plus || "14".equals(specVersion);
            isJRE13Plus = isJRE14Plus || "13".equals(specVersion);
            isJRE12Plus = isJRE13Plus || "12".equals(specVersion);
            isJRE11Plus = isJRE12Plus || "11".equals(specVersion);
            isJRE10Plus = isJRE11Plus || "10".equals(specVersion);
            isJRE9Plus = isJRE10Plus || "9".equals(specVersion);
            AbstractCompilerTest.initReflectionVersion();
            String key = "compliance.jre." + specVersion;
            String compliances = System.getProperty(key);
            if (compliances == null) {
                compliances = System.getProperty("compliance");
            }
            if (compliances != null) {
                possibleComplianceLevels = 0;
                String[] stringArray = compliances.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String compliance = stringArray[n2];
                    boolean versionValid = false;
                    int i = 0;
                    while (i < complianceTestLevelMapping.length) {
                        int[] versionMap = complianceTestLevelMapping[i];
                        long jdkLevel = ClassFileConstants.getComplianceLevelForJavaVersion((int)versionMap[1]);
                        String versionString = CompilerOptions.versionFromJdkLevel((long)jdkLevel);
                        if (versionString.equals(compliance)) {
                            possibleComplianceLevels |= versionMap[0];
                            versionValid = true;
                            break;
                        }
                        ++i;
                    }
                    if (!versionValid) {
                        System.out.println("Ignoring invalid compliance (" + compliance + ")");
                        System.out.print("Use one of ");
                        System.out.print("1.8, ");
                        System.out.print("9, ");
                        System.out.print("10, ");
                        System.out.print("11, ");
                        System.out.print("12, ");
                        System.out.print("13, ");
                        System.out.println("14, ");
                        System.out.println("15, ");
                        System.out.println("16, ");
                        System.out.println("17, ");
                        System.out.println("18, ");
                        System.out.println("19, ");
                        System.out.println("20, ");
                        System.out.println("21, ");
                        System.out.println("22, ");
                        System.out.println("23, ");
                        System.out.println("24");
                    }
                    ++n2;
                }
                if (possibleComplianceLevels == 0) {
                    System.out.println("Defaulting to all possible compliances");
                    possibleComplianceLevels = -1;
                }
            }
            if (possibleComplianceLevels == -1) {
                if (!RUN_JAVAC) {
                    possibleComplianceLevels = 32;
                    boolean canRunPrevious = true;
                    String previousVersion = CompilerOptions.getFirstSupportedJavaVersion();
                    int i = 0;
                    while (i < complianceTestLevelMapping.length) {
                        boolean canRunNext;
                        int[] versionMap = complianceTestLevelMapping[i];
                        long jdkLevel = ClassFileConstants.getComplianceLevelForJavaVersion((int)versionMap[1]);
                        String versionString = CompilerOptions.versionFromJdkLevel((long)jdkLevel);
                        boolean bl = canRunNext = canRunPrevious && !previousVersion.equals(specVersion);
                        if (canRunNext) {
                            possibleComplianceLevels |= versionMap[0];
                            previousVersion = versionString;
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else {
                    int i = 0;
                    while (i < complianceTestLevelMapping.length) {
                        int[] versionMap = complianceTestLevelMapping[i];
                        long jdkLevel = ClassFileConstants.getComplianceLevelForJavaVersion((int)versionMap[1]);
                        String versionString = CompilerOptions.versionFromJdkLevel((long)jdkLevel);
                        if (versionString.equals(specVersion)) {
                            possibleComplianceLevels |= versionMap[0];
                        }
                        ++i;
                    }
                }
            }
        }
        if (possibleComplianceLevels == 0) {
            System.out.println("Skipping all compliances (found none compatible with run.javac=enabled).");
        }
        return possibleComplianceLevels;
    }

    public static Test suite(String suiteName, Class setupClass, ArrayList testClasses) {
        TestSuite all = new TestSuite(suiteName);
        return all;
    }

    public static Test suiteForComplianceLevel(long complianceLevel, Class setupClass, ArrayList testClasses) {
        TestSuite suite = null;
        try {
            Constructor constructor = setupClass.getConstructor(String.class);
            suite = (TestSuite)constructor.newInstance(CompilerOptions.versionFromJdkLevel((long)complianceLevel));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (suite == null) {
            return null;
        }
        if (testClasses.size() == 1) {
            testClass = (Class)testClasses.get(0);
            suite = new TestSuite(testClass, CompilerOptions.versionFromJdkLevel((long)complianceLevel));
            TESTS_COUNTERS.put(testClass.getName(), suite.countTestCases());
        } else {
            suite = new TestSuite(CompilerOptions.versionFromJdkLevel((long)complianceLevel));
            int i = 0;
            int length = testClasses.size();
            while (i < length) {
                testClass = (Class)testClasses.get(i);
                TestSuite innerSuite = new TestSuite(testClass);
                TESTS_COUNTERS.put(testClass.getName(), innerSuite.countTestCases());
                suite.addTest((Test)innerSuite);
                ++i;
            }
        }
        return suite;
    }

    public static Test setupSuite(Class clazz) {
        ArrayList<Class> testClasses = new ArrayList<Class>();
        testClasses.add(clazz);
        return AbstractCompilerTest.suite(clazz.getName(), RegressionTestSetup.class, testClasses);
    }

    public static Test buildTestSuite(Class evaluationTestClass) {
        if (TESTS_PREFIX != null || TESTS_NAMES != null || TESTS_NUMBERS != null || TESTS_RANGE != null) {
            return AbstractCompilerTest.buildTestSuite(evaluationTestClass, AbstractCompilerTest.highestComplianceLevels());
        }
        return AbstractCompilerTest.setupSuite(evaluationTestClass);
    }

    public static Test buildTestSuite(Class evaluationTestClass, long complianceLevel) {
        RegressionTestSetup suite = new RegressionTestSetup(complianceLevel);
        List tests = AbstractCompilerTest.buildTestsList(evaluationTestClass);
        int index = 0;
        int size = tests.size();
        while (index < size) {
            suite.addTest((Test)tests.get(index));
            ++index;
        }
        String className = evaluationTestClass.getName();
        int newTestsNb = suite.countTestCases();
        Integer testsNb = (Integer)TESTS_COUNTERS.get(className);
        if (testsNb != null) {
            newTestsNb += testsNb.intValue();
        }
        TESTS_COUNTERS.put(className, newTestsNb);
        return suite;
    }

    public static boolean isJRELevel(int compliance) {
        return (AbstractCompilerTest.getPossibleComplianceLevels() & compliance) != 0;
    }

    public String decorateAnnotationValueLiteral(String val) {
        if (!isJRE9Plus) {
            return val;
        }
        StringBuilder builder = new StringBuilder(val);
        builder.insert(0, "\"");
        builder.append("\"");
        return builder.toString();
    }

    public AbstractCompilerTest(String name) {
        super(name);
    }

    protected Map getCompilerOptions() {
        Map options = new CompilerOptions().getMap();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        if (this.complianceLevel == 0x340000L) {
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
            options.put("org.eclipse.jdt.core.compiler.source", "1.8");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        } else if (this.complianceLevel == 0x350000L) {
            options.put("org.eclipse.jdt.core.compiler.compliance", "9");
            options.put("org.eclipse.jdt.core.compiler.source", "9");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "9");
        } else if (this.complianceLevel == 0x360000L) {
            options.put("org.eclipse.jdt.core.compiler.compliance", "10");
            options.put("org.eclipse.jdt.core.compiler.source", "10");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "10");
        } else {
            String ver = CompilerOptions.versionFromJdkLevel((long)this.complianceLevel);
            options.put("org.eclipse.jdt.core.compiler.compliance", ver);
            options.put("org.eclipse.jdt.core.compiler.source", ver);
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", ver);
        }
        return options;
    }

    public String getName() {
        Object name = super.getName();
        if (this.complianceLevel != 0L) {
            name = (String)name + " - " + CompilerOptions.versionFromJdkLevel((long)this.complianceLevel);
        }
        return name;
    }

    protected static String getVersionString(long compliance) {
        String version = "version 17 : 61.0";
        if (compliance < 0x350000L) {
            return "version 1.8 : 52.0";
        }
        if (compliance == 0x350000L) {
            return "version 9 : 53.0";
        }
        if (compliance == 0x360000L) {
            return "version 10 : 54.0";
        }
        if (compliance > 0x360000L) {
            String ver = CompilerOptions.versionFromJdkLevel((long)compliance);
            int major = Integer.parseInt(ver) + 44;
            return "version " + ver + " : " + major + ".0";
        }
        if (compliance >= ClassFileConstants.getComplianceLevelForJavaVersion((int)68)) {
            return version;
        }
        return version;
    }

    public void initialize(CompilerTestSetup setUp) {
        this.complianceLevel = setUp.complianceLevel;
        this.enableAPT = System.getProperty("enableAPT") != null;
    }

    protected String testName() {
        return super.getName();
    }

    protected void createOutputTestDirectory(String suffixPath) {
        this.outputTestDirectory = new File(this.outputRootDirectoryPath.toFile(), suffixPath);
        if (!this.outputTestDirectory.exists()) {
            this.outputTestDirectory.mkdirs();
        }
    }

    protected void writeFiles(String[] testFiles) {
        this.createOutputTestDirectory(this.testName());
        int i = 0;
        int length = testFiles.length;
        while (i < length) {
            File dir;
            String fileName = testFiles[i++];
            String contents = testFiles[i++];
            File file = new File(this.outputTestDirectory, fileName);
            if (fileName.lastIndexOf(47) >= 0 && !(dir = file.getParentFile()).exists()) {
                dir.mkdirs();
            }
            Util.writeToFile(contents, file.getPath());
        }
    }
}

