/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.ref.Cleaner;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.jdt.core.tests.runtime.LocalVMLauncher;
import org.eclipse.jdt.core.tests.runtime.LocalVirtualMachine;
import org.eclipse.jdt.core.tests.runtime.TargetException;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.core.tests.util.VerifyTests;

public class TestVerifier {
    public String failureReason;
    private final boolean reuseVM;
    private String[] classpathCache;
    private StringBuilder outputBuffer;
    private StringBuilder errorBuffer;
    private final VmCleaner managedVMs = new VmCleaner();
    private static final Cleaner cleaner = Cleaner.create();
    static final String VERIFY_TEST_CODE_DEFAULT = "/*******************************************************************************\n * Copyright (c) 2000, 2021 IBM Corporation and others.\n *\n * This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License 2.0\n * which accompanies this distribution, and is available at\n * https://www.eclipse.org/legal/epl-2.0/\n *\n * SPDX-License-Identifier: EPL-2.0\n *\n * Contributors:\n *     IBM Corporation - initial API and implementation\n *     Alexander Kriegisch - bug 286316: Get classpath via DataInputStream and\n *         use it in an isolated URLClassLoader, enabling formerly locked\n *         classpath JARs to be closed on Windows\n *******************************************************************************/\npackage org.eclipse.jdt.core.tests.util;\n\nimport java.io.DataInputStream;\nimport java.io.DataOutputStream;\nimport java.io.File;\nimport java.io.IOException;\nimport java.lang.reflect.InvocationTargetException;\nimport java.lang.reflect.Method;\nimport java.net.MalformedURLException;\nimport java.net.Socket;\nimport java.net.URL;\nimport java.net.URLClassLoader;\n\n/**\n * <b>IMPORTANT NOTE:</b> When modifying this class, please copy the source into the static initialiser block for field\n * {@link TestVerifier#VERIFY_TEST_CODE_DEFAULT}. See also {@link TestVerifier#READ_VERIFY_TEST_FROM_FILE}, if you want\n * to dynamically load the source code directly from this file when running tests, which is a convenient way to test if\n * changes in this class work as expected, without the need to update the hard-coded default value every single time\n * during an ongoing refactoring.\n * <p>\n * In order to make the copying job easier, keep this class compatible with the lowest supported Java language level (1.8).\n */\npublic class VerifyTests {\n\tint portNumber;\n\tSocket socket;\n\nprivate static URL[] classPathToURLs(String[] classPath) throws MalformedURLException {\n\tURL[] urls = new URL[classPath.length];\n\tfor (int i = 0; i < classPath.length; i++) {\n\t\turls[i] = new File(classPath[i]).toURI().toURL();\n\t}\n\treturn urls;\n}\n\npublic void loadAndRun(String className, String[] classPath) throws Throwable {\n\ttry (URLClassLoader urlClassLoader = new URLClassLoader(classPathToURLs(classPath))) {\n\t\t//System.out.println(\"Loading \" + className + \"...\");\n\t\tClass<?> testClass = urlClassLoader.loadClass(className);\n\t\t//System.out.println(\"Loaded \" + className);\n\t\ttry {\n\t\t\tMethod main = testClass.getMethod(\"main\", new Class[] {String[].class});\n\t\t\t//System.out.println(\"Running \" + className);\n\t\t\tmain.invoke(null, new Object[] {new String[] {}});\n\t\t\t//System.out.println(\"Finished running \" + className);\n\t\t} catch (NoSuchMethodException e) {\n\t\t\treturn;\n\t\t} catch (InvocationTargetException e) {\n\t\t\tthrow e.getTargetException();\n\t\t}\n\t}\n}\npublic static void main(String[] args) throws IOException {\n\tVerifyTests verify = new VerifyTests();\n\tverify.portNumber = Integer.parseInt(args[0]);\n\tverify.run();\n}\npublic void run() throws IOException {\n\tthis.socket = new Socket(\"localhost\", this.portNumber);\n\tthis.socket.setTcpNoDelay(true);\n\n\tDataInputStream in = new DataInputStream(this.socket.getInputStream());\n\tfinal DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());\n\twhile (true) {\n\t\tfinal String className = in.readUTF();\n\t\tfinal int length = in.readInt();\n\t\tfinal String[] classPath = new String[length];\n\t\tfor (int i = 0; i < length; i++) {\n\t\t\tclassPath[i] = in.readUTF();\n\t\t}\n\t\tThread thread = new Thread() {\n\t\t\t@Override\n\t\t\tpublic void run() {\n\t\t\t\ttry {\n\t\t\t\t\tloadAndRun(className, classPath);\n\t\t\t\t\tout.writeBoolean(true);\n\t\t\t\t\tSystem.out.println(VerifyTests.class.getName());\n\t\t\t\t\tSystem.err.println(VerifyTests.class.getName());\n\t\t\t\t} catch (Throwable e) {\n\t\t\t\t\te.printStackTrace();\n\t\t\t\t\ttry {\n\t\t\t\t\t\tout.writeBoolean(false);\n\t\t\t\t\t\tSystem.out.println(VerifyTests.class.getName());\n\t\t\t\t\t\tSystem.err.println(VerifyTests.class.getName());\n\t\t\t\t\t} catch (IOException e1) {\n\t\t\t\t\t\te1.printStackTrace();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t// Flush all streams, in case the test executor VM is shut down before\n\t\t\t\t// the controlling VM receives the responses it depends on\n\t\t\t\ttry {\n\t\t\t\t\tout.flush();\n\t\t\t\t} catch (IOException e) {\n\t\t\t\t\te.printStackTrace();\n\t\t\t\t}\n\t\t\t\tSystem.out.flush();\n\t\t\t\tSystem.err.flush();\n\t\t\t}\n\t\t};\n\t\tthread.start();\n\t}\n}\n}\n";
    public static boolean READ_VERIFY_TEST_FROM_FILE = false;
    public static String PROJECT_BASE_DIR = System.getenv("PROJECT_BASE_DIR");
    private static String verifyTestCode;
    private static final Object verifyTestCodeLock;

    static {
        verifyTestCodeLock = new Object();
    }

    public TestVerifier(boolean reuseVM) {
        this.reuseVM = reuseVM;
        cleaner.register(this, this.managedVMs);
    }

    private boolean checkBuffers(String outputString, String errorString, String sourceFileName, String expectedOutputString, String expectedErrorStringStart) {
        String platformIndependantString;
        boolean didMatchExpectation = true;
        this.failureReason = null;
        if (expectedOutputString != null) {
            platformIndependantString = Util.convertToIndependantLineDelimiter(outputString.trim());
            if (!Util.convertToIndependantLineDelimiter(expectedOutputString).equals(platformIndependantString)) {
                System.out.println(Util.displayString(platformIndependantString, 2));
                this.failureReason = "Unexpected output running resulting class file for " + sourceFileName + ":\n--[START]--\n" + outputString + "---[END]---\n";
                didMatchExpectation = false;
            }
        }
        String trimmedErrorString = errorString.trim();
        if (expectedErrorStringStart != null) {
            platformIndependantString = Util.convertToIndependantLineDelimiter(trimmedErrorString);
            if (expectedErrorStringStart.length() == 0 && platformIndependantString.length() > 0 || !platformIndependantString.startsWith(Util.convertToIndependantLineDelimiter(expectedErrorStringStart))) {
                System.out.println(Util.displayString(platformIndependantString, 2));
                this.failureReason = "Unexpected error running resulting class file for " + sourceFileName + ":\n--[START]--\n" + errorString + "---[END]---\n";
                didMatchExpectation = false;
            }
        } else if (trimmedErrorString.length() != 0) {
            platformIndependantString = Util.convertToIndependantLineDelimiter(trimmedErrorString);
            System.out.println(Util.displayString(platformIndependantString, 2));
            this.failureReason = "Unexpected error running resulting class file for " + sourceFileName + ":\n--[START]--\n" + errorString + "---[END]---\n";
            didMatchExpectation = false;
        }
        return didMatchExpectation;
    }

    private void compileVerifyTests(String verifierDir) {
        String fullyQualifiedName = VerifyTests.class.getName();
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        String packageName = fullyQualifiedName.substring(0, lastDot);
        String simpleName = fullyQualifiedName.substring(lastDot + 1);
        String dirName = verifierDir.replace('\\', '/') + "/" + packageName.replace('.', '/');
        File dir = new File(dirName.replace('/', File.separatorChar));
        if (!dir.exists() && !dir.mkdirs()) {
            System.out.println("Could not create " + String.valueOf(dir));
            return;
        }
        String fileName = String.valueOf(dir) + File.separator + simpleName + ".java";
        Util.writeToFile(this.getVerifyTestsCode(), fileName);
        BatchCompiler.compile((String)("\"" + fileName + "\" -d \"" + verifierDir + "\" -warn:-resource -classpath \"" + Util.getJavaClassLibsAsString() + "\""), (PrintWriter)new PrintWriter(System.out), (PrintWriter)new PrintWriter(System.err), null);
    }

    public void execute(String className, String[] classpaths) {
        this.setOutputBuffer(new StringBuilder());
        this.setErrorBuffer(new StringBuilder());
        this.launchAndRun(className, classpaths, null, null);
    }

    public void execute(String className, String[] classpaths, String[] programArguments, String[] vmArguments) {
        this.setOutputBuffer(new StringBuilder());
        this.setErrorBuffer(new StringBuilder());
        this.launchAndRun(className, classpaths, programArguments, vmArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExecutionOutput() {
        StringBuilder ob;
        StringBuilder stringBuilder = ob = this.getOutputBuffer();
        synchronized (stringBuilder) {
            return ob.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExecutionError() {
        StringBuilder eb;
        StringBuilder stringBuilder = eb = this.getErrorBuffer();
        synchronized (stringBuilder) {
            return this.getErrorBuffer().toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getVerifyTestsCode() {
        Object object = verifyTestCodeLock;
        synchronized (object) {
            if (verifyTestCode == null && READ_VERIFY_TEST_FROM_FILE) {
                Object sourceFile = "src/org/eclipse/jdt/core/tests/util/VerifyTests.java";
                if (!new File((String)sourceFile).exists()) {
                    sourceFile = PROJECT_BASE_DIR + "/org.eclipse.jdt.core.tests.compiler/" + (String)sourceFile;
                }
                try {
                    verifyTestCode = Files.readString(Path.of((String)sourceFile, new String[0]));
                }
                catch (IOException e) {
                    System.out.println("WARNING: Cannot read & filter VerifyTests source code from file, using default value");
                    System.out.println("\t- exception: " + String.valueOf(e));
                }
            }
            if (verifyTestCode == null) {
                verifyTestCode = VERIFY_TEST_CODE_DEFAULT;
            }
            return verifyTestCode;
        }
    }

    private String[] getMinimalClassPath(String[] classPath) {
        return (String[])Arrays.stream(classPath).filter(s -> {
            String path = s.replace('\\', '/');
            return !path.contains("/comptest/") || path.endsWith("/verifier");
        }).toArray(String[]::new);
    }

    private void launchAndRun(String className, String[] classpaths, String[] programArguments, String[] vmArguments) {
        Thread errorThread;
        Thread outputThread;
        for (LocalVirtualMachine vm : this.managedVMs.vmByClassPath.values()) {
            try {
                vm.shutDown();
            }
            catch (TargetException targetException) {
                // empty catch block
            }
        }
        this.managedVMs.vmByClassPath.clear();
        this.classpathCache = null;
        LocalVMLauncher launcher = LocalVMLauncher.getLauncher();
        launcher.setClassPath(classpaths);
        launcher.setVMPath(Util.getJREDirectory());
        if (vmArguments != null) {
            launcher.setVMArguments(vmArguments);
        }
        launcher.setProgramClass(className);
        launcher.setProgramArguments(programArguments);
        try {
            LocalVirtualMachine vm = launcher.launch();
            this.managedVMs.vmByClassPath.put(new ClassPath(classpaths), vm);
            InputStream input = vm.getInputStream();
            outputThread = new Thread(() -> TestVerifier.transferTo(input, this::getOutputBuffer), "stdOutReader");
            InputStream errorStream = vm.getErrorStream();
            errorThread = new Thread(() -> TestVerifier.transferTo(errorStream, this::getErrorBuffer), "stdErrReader");
            outputThread.start();
            errorThread.start();
        }
        catch (TargetException e) {
            throw new Error(e.getMessage());
        }
        try {
            outputThread.join(10000L);
            errorThread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transferTo(InputStream stream, Supplier<StringBuilder> b) {
        try {
            try {
                int c = stream.read();
                while (c != -1) {
                    StringBuilder buffer;
                    StringBuilder stringBuilder = buffer = b.get();
                    synchronized (stringBuilder) {
                        buffer.append((char)c);
                    }
                    c = stream.read();
                }
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void launchVerifyTestsIfNeeded(String[] classpaths, String[] vmArguments) {
        LocalVirtualMachine vm = this.managedVMs.vmByClassPath.get(new ClassPath(classpaths));
        if (vm != null && vm.isRunning() && this.classpathCache != null) {
            return;
        }
        if (vm != null) {
            try {
                vm.shutDown();
            }
            catch (TargetException targetException) {
                // empty catch block
            }
            vm = null;
        }
        this.classpathCache = classpaths;
        LocalVMLauncher launcher = LocalVMLauncher.getLauncher();
        int length = classpaths.length;
        String[] cp = new String[length + 1];
        System.arraycopy(classpaths, 0, cp, 0, length);
        String verifierDir = Util.getOutputDirectory() + File.separator + "verifier";
        this.compileVerifyTests(verifierDir);
        cp[length] = verifierDir;
        launcher.setClassPath(this.getMinimalClassPath(cp));
        launcher.setVMPath(Util.getJREDirectory());
        launcher.setProgramClass(VerifyTests.class.getName());
        try {
            Throwable throwable = null;
            Object var9_12 = null;
            try (ServerSocket server = new ServerSocket(0);){
                int portNumber = server.getLocalPort();
                launcher.setProgramArguments(new String[]{Integer.toString(portNumber)});
                try {
                    vm = launcher.launch();
                    this.managedVMs.vmByClassPath.put(new ClassPath(classpaths), vm);
                    InputStream input = vm.getInputStream();
                    Thread outputThread = new Thread(() -> TestVerifier.transferTo(input, this::getOutputBuffer), "stdOutReader");
                    InputStream errorStream = vm.getErrorStream();
                    Thread errorThread = new Thread(() -> TestVerifier.transferTo(errorStream, this::getErrorBuffer), "stdErrReader");
                    outputThread.start();
                    errorThread.start();
                }
                catch (TargetException e) {
                    e.printStackTrace();
                    throw new Error(e.getMessage());
                }
                boolean isVMRunning = false;
                Socket socket = null;
                do {
                    try {
                        socket = server.accept();
                        this.managedVMs.socketByClassPath.put(new ClassPath(classpaths), socket);
                        socket.setTcpNoDelay(true);
                        break;
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (socket != null) continue;
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    isVMRunning = vm.isRunning();
                } while (socket == null && isVMRunning);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
    }

    private boolean loadAndRun(String className, String[] classPath) {
        Socket socket = this.managedVMs.socketByClassPath.get(new ClassPath(classPath));
        if (socket != null) {
            try {
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                out.writeUTF(className);
                if (classPath == null) {
                    classPath = new String[]{};
                }
                out.writeInt(classPath.length);
                String[] stringArray = classPath;
                int n = classPath.length;
                int n2 = 0;
                while (n2 < n) {
                    String classpath = stringArray[n2];
                    out.writeUTF(classpath);
                    ++n2;
                }
                DataInputStream in = new DataInputStream(socket.getInputStream());
                try {
                    boolean result = in.readBoolean();
                    this.waitForFullBuffers();
                    return result;
                }
                catch (SocketException e) {
                    return true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void shutDown() {
        this.managedVMs.run();
    }

    public boolean verifyClassFiles(String sourceFilePath, String className, String expectedSuccessOutputString, String[] classpaths) {
        return this.verifyClassFiles(sourceFilePath, className, expectedSuccessOutputString, "", classpaths, null, null);
    }

    public boolean verifyClassFiles(String sourceFilePath, String className, String expectedSuccessOutputString, String[] classpaths, String[] programArguments, String[] vmArguments) {
        return this.verifyClassFiles(sourceFilePath, className, expectedSuccessOutputString, "", classpaths, programArguments, vmArguments);
    }

    public boolean verifyClassFiles(String sourceFilePath, String className, String expectedOutputString, String expectedErrorStringStart, String[] classpaths, String[] programArguments, String[] vmArguments) {
        this.setOutputBuffer(new StringBuilder());
        this.setErrorBuffer(new StringBuilder());
        if (this.reuseVM && programArguments == null) {
            this.launchVerifyTestsIfNeeded(classpaths, vmArguments);
            this.loadAndRun(className, classpaths);
        } else {
            this.launchAndRun(className, classpaths, programArguments, vmArguments);
        }
        this.failureReason = null;
        return this.checkBuffers(this.getExecutionOutput(), this.getExecutionError(), sourceFilePath, expectedOutputString, expectedErrorStringStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFullBuffers() {
        StringBuilder ob;
        StringBuilder eb;
        int outputEndStringStart;
        int errorEndStringStart;
        block9: {
            String endString = VerifyTests.class.getName();
            long n0 = System.nanoTime();
            do {
                errorEndStringStart = this.getExecutionError().indexOf(endString);
                outputEndStringStart = this.getExecutionOutput().indexOf(endString);
                if (errorEndStringStart != -1 && outputEndStringStart != -1) break block9;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (System.nanoTime() - n0 <= 5000000000L);
            throw new RuntimeException("Timeout after " + (System.nanoTime() - n0) / 1000000L + "ms");
        }
        StringBuilder stringBuilder = eb = this.getErrorBuffer();
        synchronized (stringBuilder) {
            eb.setLength(errorEndStringStart);
        }
        StringBuilder stringBuilder2 = ob = this.getOutputBuffer();
        synchronized (stringBuilder2) {
            ob.setLength(outputEndStringStart);
        }
    }

    public StringBuilder getOutputBuffer() {
        return this.outputBuffer;
    }

    public void setOutputBuffer(StringBuilder outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    public StringBuilder getErrorBuffer() {
        return this.errorBuffer;
    }

    public void setErrorBuffer(StringBuilder errorBuffer) {
        this.errorBuffer = errorBuffer;
    }

    static class ClassPath {
        private String[] classpath;

        ClassPath(String[] classpath) {
            this.classpath = classpath;
        }

        public int hashCode() {
            return Arrays.hashCode(this.classpath);
        }

        public boolean equals(Object obj) {
            ClassPath other = (ClassPath)obj;
            return Arrays.equals(this.classpath, other.classpath);
        }
    }

    private static class VmCleaner
    implements Runnable {
        private final Map<ClassPath, LocalVirtualMachine> vmByClassPath = new HashMap<ClassPath, LocalVirtualMachine>();
        private final Map<ClassPath, Socket> socketByClassPath = new HashMap<ClassPath, Socket>();

        private VmCleaner() {
        }

        @Override
        public void run() {
            for (Socket socket : this.socketByClassPath.values()) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.socketByClassPath.clear();
            for (LocalVirtualMachine vm : this.vmByClassPath.values()) {
                try {
                    long n0 = System.nanoTime();
                    while (vm.isRunning() && System.nanoTime() - n0 < 2000000000L) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!vm.isRunning()) continue;
                    vm.shutDown();
                }
                catch (TargetException e) {
                    e.printStackTrace();
                }
            }
            this.vmByClassPath.clear();
        }
    }
}

