/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;

public class VerifyTests {
    int portNumber;
    Socket socket;

    private static URL[] classPathToURLs(String[] classPath) throws MalformedURLException {
        URL[] urls = new URL[classPath.length];
        int i = 0;
        while (i < classPath.length) {
            urls[i] = new File(classPath[i]).toURI().toURL();
            ++i;
        }
        return urls;
    }

    public void loadAndRun(String className, String[] classPath) throws Throwable {
        Throwable throwable = null;
        Object var4_5 = null;
        try (URLClassLoader urlClassLoader = new URLClassLoader(VerifyTests.classPathToURLs(classPath));){
            Class<?> testClass = urlClassLoader.loadClass(className);
            try {
                Method main = testClass.getMethod("main", String[].class);
                main.invoke(null, new Object[]{new String[0]});
            }
            catch (NoSuchMethodException e) {
                if (urlClassLoader != null) {
                    urlClassLoader.close();
                }
                return;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws IOException {
        VerifyTests verify = new VerifyTests();
        verify.portNumber = Integer.parseInt(args[0]);
        verify.run();
    }

    public void run() throws IOException {
        this.socket = new Socket("localhost", this.portNumber);
        this.socket.setTcpNoDelay(true);
        DataInputStream in = new DataInputStream(this.socket.getInputStream());
        final DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
        while (true) {
            final String className = in.readUTF();
            int length = in.readInt();
            final String[] classPath = new String[length];
            int i = 0;
            while (i < length) {
                classPath[i] = in.readUTF();
                ++i;
            }
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        VerifyTests.this.loadAndRun(className, classPath);
                        out.writeBoolean(true);
                        System.out.println(VerifyTests.class.getName());
                        System.err.println(VerifyTests.class.getName());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        try {
                            out.writeBoolean(false);
                            System.out.println(VerifyTests.class.getName());
                            System.err.println(VerifyTests.class.getName());
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    try {
                        out.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    System.out.flush();
                    System.err.flush();
                }
            };
            thread.start();
        }
    }
}

