/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcherExtension;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractPairMatcherTest {
    private final boolean fCaretEitherSideOfBracket;
    private static String DEFAULT_PARTITION = "__dftl_partition_content_type";

    public AbstractPairMatcherTest(boolean caretEitherSideOfBracket) {
        this.fCaretEitherSideOfBracket = caretEitherSideOfBracket;
    }

    protected ICharacterPairMatcher createMatcher(String chars) {
        return new DefaultCharacterPairMatcher(chars.toCharArray(), this.getDocumentPartitioning(), this.fCaretEitherSideOfBracket);
    }

    protected String getDocumentPartitioning() {
        return "__dftl_partitioning";
    }

    @Test
    public void testTestCaseReader() {
        this.performReaderTest("%( )#", 0, 3, "( )");
        this.performReaderTest("#%", 0, 0, "");
    }

    @Test
    public void testSimpleMatchSameMatcher() throws BadLocationException {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, "#(   )%");
        this.performMatch(matcher, "#[   ]%");
        this.performMatch(matcher, "#{   }%");
        this.performMatch(matcher, "(%   )#");
        this.performMatch(matcher, "[%   ]#");
        this.performMatch(matcher, "{%   }#");
        this.performMatch(matcher, "#(   %)%");
        this.performMatch(matcher, "#[   %]%");
        this.performMatch(matcher, "#{   %}%");
        this.performMatch(matcher, "%(%   )#");
        this.performMatch(matcher, "%[%   ]#");
        this.performMatch(matcher, "%{%   }#");
        this.performMatch(matcher, "#(  %  )#");
        this.performMatch(matcher, "#[  %  ]#");
        this.performMatch(matcher, "#{  %  }#");
        this.performMatch(matcher, "#(  % %  )#");
        this.performMatch(matcher, "#[  % %  ]#");
        this.performMatch(matcher, "#{  % %  }#");
        matcher.dispose();
    }

    @Test
    public void testSimpleMatchDifferentMatchers() throws BadLocationException {
        this.performMatch("()[]{}", "#(   )%");
        this.performMatch("()[]{}", "#[   ]%");
        this.performMatch("()[]{}", "#{   }%");
        this.performMatch("()[]{}", "(%   )#");
        this.performMatch("()[]{}", "[%   ]#");
        this.performMatch("()[]{}", "{%   }#");
        this.performMatch("()[]{}", "#(  %  )#");
        this.performMatch("()[]{}", "#[  %  ]#");
        this.performMatch("()[]{}", "#{  %  }#");
    }

    @Test
    public void testCloseMatches() throws BadLocationException {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, "(%)#");
        this.performMatch(matcher, "#(())%");
        this.performMatch(matcher, "(%())#");
        this.performMatch(matcher, "((%)#)");
        this.performMatch(matcher, "%(%)#");
        this.performMatch(matcher, "#(()%)%");
        this.performMatch(matcher, "%(%())#");
        this.performMatch(matcher, "(%(%)#)");
        this.performMatch(matcher, "#(%)#");
        this.performMatch(matcher, "#(%())#");
        this.performMatch(matcher, "#(% %)#");
        this.performMatch(matcher, "#(% %())#");
        matcher.dispose();
    }

    @Test
    public void testIncompleteMatch() throws BadLocationException {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, "(% ");
        this.performMatch(matcher, "( % )");
        this.performMatch(matcher, "%");
        matcher.dispose();
    }

    @Test
    public void testPartitioned() throws BadLocationException {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, "(% |a a| )#");
        this.performMatch(matcher, "#( |a a| )%");
        this.performMatch(matcher, "|b #( )% b|");
        this.performMatch(matcher, "( |b )% b|");
        this.performMatch(matcher, "(% |b ) b|");
        this.performMatch(matcher, "|a ( a| )%");
        this.performMatch(matcher, "|a (% a| )");
        this.performMatch(matcher, "|c #( c| ) ( |c )% c|");
        this.performMatch(matcher, "|c (% c| ) ( |c )# c|");
        this.performMatch(matcher, "(% |a ) a| |b ) b| |c ) c| )#");
        this.performMatch(matcher, "#( % |a a| )#");
        this.performMatch(matcher, "|b #( % )# b|");
        this.performMatch(matcher, "|c #( % c| ) ( |c )# c|");
        this.performMatch(matcher, "|c #( c| ) ( |c % )# c|");
        this.performMatch(matcher, "#( % |a ) a| |b ) b| |c ) c| )#");
        this.performMatch(matcher, "#( |a % a| )#");
        this.performMatch(matcher, "( |a #( a| ( |a % a| ) |a )# a| )");
        this.performMatch(matcher, "#( % % |a a| )#");
        this.performMatch(matcher, "|b #( % % )# b|");
        this.performMatch(matcher, "|c #( % % c| ) ( |c )# c|");
        this.performMatch(matcher, "|c #( c| ) ( |c % % )# c|");
        this.performMatch(matcher, "#( % % |a ) a| |b ) b| |c ) c| )#");
        this.performMatch(matcher, " #( |c ( c| % % |c ) c| )#");
        matcher.dispose();
    }

    @Test
    public void testTightPartitioned() throws BadLocationException {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, "(|b)%b|");
        this.performMatch(matcher, "(%|b)b|");
        this.performMatch(matcher, "|a(a|)%");
        this.performMatch(matcher, "|a(%a|)");
        this.performMatch(matcher, "|c#(c|)(|c)%c|");
        this.performMatch(matcher, "|c(%c|)(|c)#c|");
        this.performMatch(matcher, "(%|a)a||b)b||c)c|)#");
        this.performMatch(matcher, "|c#(c|)(|%c)#c|");
        this.performMatch(matcher, "|c#(c%|)(|c)#c|");
        this.performMatch(matcher, "#(%|a)a||b)b||c)c|)#");
        matcher.dispose();
    }

    @Test
    public void testNesting() {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, " ( #( ( ( ) ) ( ) )% ) ");
        this.performMatch(matcher, " ( (% ( ( ) ) ( ) )# ) ");
        this.performMatch(matcher, " ( #( { ( ) } [ ] )% ) ");
        this.performMatch(matcher, " ( (% { ( ) } [ ] )# ) ");
        this.performMatch(matcher, " ( ( #{ ( ) }% [ ] ) ) ");
        this.performMatch(matcher, " ( ( {% ( ) }# [ ] ) ) ");
        this.performMatch(matcher, "a(b#(c(d(e)f)g(h)i)%j)k");
        this.performMatch(matcher, "a(b(%c(d(e)f)g(h)i)#j)k");
        this.performMatch(matcher, "a(b#(c{d(e)f}g[h]i)%j)k");
        this.performMatch(matcher, "a(b(%c{d(e)f}g[h]i)#j)k");
        this.performMatch(matcher, "a(b(c#{d(e)f}%g[h]i)j)k");
        this.performMatch(matcher, "a(b(c{%d(e)f}#g[h]i)j)k");
        this.performMatch(matcher, " ( #( ( ( ) ) ( ) % )# ) ");
        this.performMatch(matcher, " ( #( % ( ( ) ) ( ) )# ) ");
        this.performMatch(matcher, " ( #( { ( ) } [ ] % )# ) ");
        this.performMatch(matcher, " ( #( % { ( ) } [ ] )# ) ");
        this.performMatch(matcher, " ( ( #{ ( ) % }# [ ] ) ) ");
        this.performMatch(matcher, " ( ( #{ % ( ) }# [ ] ) ) ");
        this.performMatch(matcher, "a(b#(c(d(e)f)g(h)i%)#j)k");
        this.performMatch(matcher, "a(b#(%c(d(e)f)g(h)i)#j)k");
        this.performMatch(matcher, "a(b#(c{d(e)f}g[h]i%)#j)k");
        this.performMatch(matcher, "a(b#(%c{d(e)f}g[h]i)#j)k");
        this.performMatch(matcher, "a(b(c#{d(e)f%}#g[h]i)j)k");
        this.performMatch(matcher, "a(b(c#{%d(e)f}#g[h]i)j)k");
        matcher.dispose();
    }

    @Test
    public void testBoundaries() throws BadLocationException {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        StringDocument doc = new StringDocument("abcdefghijkl");
        Assert.assertNull((Object)matcher.match(null, 0));
        Assert.assertNull((Object)matcher.match((IDocument)doc, -1));
        Assert.assertNull((Object)matcher.match((IDocument)doc, doc.getLength() + 1));
        matcher.dispose();
    }

    @Test
    public void testBug156426() {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}<>");
        this.performMatch(matcher, " #( a < b )% ");
        this.performMatch(matcher, " (% a < b )# ");
        this.performMatch(matcher, " #( a > b )% ");
        this.performMatch(matcher, " (% a > b )# ");
        matcher.dispose();
    }

    @Test
    public void testBug377417() {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, "#( %  )%#");
        this.performMatch(matcher, "#[ %  ]%#");
        this.performMatch(matcher, "#{ %  }%#");
        matcher.dispose();
    }

    protected void performReaderTest(String testString, int expectedPos, int expectedMatch, String expectedString) {
        TestCase t0 = this.createTestCase(testString);
        Assert.assertEquals((long)expectedPos, (long)t0.fPos1);
        Assert.assertEquals((long)expectedMatch, (long)t0.fMatch2);
        Assert.assertEquals((Object)expectedString, (Object)t0.fString);
    }

    protected void performMatch(ICharacterPairMatcher matcher, String testCase) {
        IRegion region;
        TestCase test = this.createTestCase(testCase);
        matcher.clear();
        if (test.isSelectionTestCase()) {
            Assert.assertTrue((boolean)(matcher instanceof ICharacterPairMatcherExtension));
            matcherExtension = (ICharacterPairMatcherExtension)matcher;
            region = test.isEnclosingTestCase() ? matcherExtension.findEnclosingPeerCharacters(test.getDocument(), test.fPos1, test.fPos2 - test.fPos1) : matcherExtension.match(test.getDocument(), test.fPos1, test.fPos2 - test.fPos1);
        } else if (test.isEnclosingTestCase()) {
            Assert.assertTrue((boolean)(matcher instanceof ICharacterPairMatcherExtension));
            matcherExtension = (ICharacterPairMatcherExtension)matcher;
            region = matcherExtension.findEnclosingPeerCharacters(test.getDocument(), test.fPos1, test.fPos2 - test.fPos1);
        } else {
            region = matcher.match(test.getDocument(), test.fPos1);
        }
        if (test.fMatch2 == -1) {
            if (region != null) {
                System.out.println(region.getOffset());
            }
            Assert.assertNull((Object)region);
        } else {
            Assert.assertNotNull((Object)region);
            boolean isBackward = test.isEnclosingTestCase() ? false : test.fPos1 > test.fMatch2;
            Assert.assertEquals((Object)isBackward, (Object)(matcher.getAnchor() == 0 ? 1 : 0));
            Assert.assertEquals((long)test.getLength(), (long)region.getLength());
            Assert.assertEquals((long)test.getOffset(), (long)region.getOffset());
        }
    }

    private void performMatch(String delims, String testCase) {
        ICharacterPairMatcher matcher = this.createMatcher(delims);
        this.performMatch(matcher, testCase);
        matcher.dispose();
    }

    public TestCase createTestCase(String str) {
        boolean enclosingTest;
        int pos1 = str.indexOf(37);
        Assert.assertNotEquals((long)-1L, (long)pos1);
        int pos2 = str.lastIndexOf(37);
        boolean selectionTest = pos1 != pos2;
        int match1 = str.indexOf(35);
        int match2 = str.lastIndexOf(35);
        boolean bl = enclosingTest = match1 != match2;
        if (selectionTest) {
            if (!enclosingTest) {
                Assert.assertEquals((long)2L, (long)(pos2 - pos1));
                if (match1 != -1 && match1 < pos1) {
                    --pos1;
                    pos2 -= 2;
                }
                if (pos1 < match1) {
                    --pos2;
                    match1 -= 2;
                }
            } else {
                --pos1;
                pos2 -= 2;
                match2 -= 3;
            }
        } else {
            if (!enclosingTest) {
                if (match1 != -1 && match1 < pos1) {
                    --pos1;
                }
                if (pos1 < match1) {
                    --match1;
                }
            } else {
                --pos1;
                match2 -= 2;
            }
            pos2 = pos1;
        }
        String stripped = str.replaceAll("%", "").replaceAll("#", "");
        if (enclosingTest) {
            return new TestCase(stripped, pos1, pos2, match1, match2);
        }
        if (selectionTest) {
            return new TestCase(stripped, pos1, pos2, pos1 < match1 ? pos1 : pos2, match1);
        }
        if (match1 == -1) {
            return new TestCase(stripped, pos1, pos2, pos1, match1);
        }
        match2 = match1;
        match1 = pos1;
        if (!selectionTest && !enclosingTest) {
            char ch;
            String chars = "()[]{}<>";
            if (this.fCaretEitherSideOfBracket && pos1 < stripped.length()) {
                char prevCh;
                ch = stripped.charAt(pos1);
                char c = prevCh = pos1 - 1 >= 0 ? stripped.charAt(pos1 - 1) : (char)'\u0000';
                if (chars.indexOf(ch) % 2 == 1 && chars.indexOf(prevCh) % 2 != 0) {
                    ++match1;
                }
            }
            if (pos1 - 1 >= 0 && chars.indexOf(ch = stripped.charAt(pos1 - 1)) % 2 == 0) {
                --match1;
            }
        }
        return new TestCase(stripped, pos1, pos2, match1, match2);
    }

    private static IDocumentPartitioner createPartitioner() {
        RuleBasedPartitionScanner scan = new RuleBasedPartitionScanner();
        ArrayList<SingleLineRule> rules = new ArrayList<SingleLineRule>();
        rules.add(new SingleLineRule("|a", "a|", (IToken)new Token((Object)"a")));
        rules.add(new SingleLineRule("|b", "b|", (IToken)new Token((Object)"b")));
        rules.add(new SingleLineRule("|c", "c|", (IToken)new Token((Object)"c")));
        scan.setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
        scan.setDefaultReturnToken((IToken)new Token((Object)DEFAULT_PARTITION));
        return new FastPartitioner((IPartitionTokenScanner)scan, new String[]{DEFAULT_PARTITION, "a", "b", "c"});
    }

    private class StringDocument
    extends Document {
        public StringDocument(String str) {
            this.setTextStore(new StringTextStore(str));
            this.set(str);
            IDocumentPartitioner part = AbstractPairMatcherTest.createPartitioner();
            this.setDocumentPartitioner(AbstractPairMatcherTest.this.getDocumentPartitioning(), part);
            part.connect((IDocument)this);
        }
    }

    private static class StringTextStore
    implements ITextStore {
        private String fString;

        public StringTextStore(String str) {
            this.fString = str;
        }

        public char get(int offset) {
            return this.fString.charAt(offset);
        }

        public String get(int offset, int length) {
            return this.fString.substring(offset, offset + length);
        }

        public int getLength() {
            return this.fString.length();
        }

        public void replace(int offset, int length, String text) {
            throw new UnsupportedOperationException();
        }

        public void set(String text) {
            this.fString = text;
        }
    }

    private class TestCase {
        public final String fString;
        public final int fPos1;
        public final int fPos2;
        public final int fMatch1;
        public final int fMatch2;

        public TestCase(String string, int pos1, int pos2, int match1, int match2) {
            this.fString = string;
            this.fPos1 = pos1;
            this.fPos2 = pos2;
            this.fMatch1 = match1;
            this.fMatch2 = match2;
        }

        public IDocument getDocument() {
            return new StringDocument(this.fString);
        }

        public int getLength() {
            return Math.abs(this.fMatch1 - this.fMatch2);
        }

        public int getOffset() {
            if (this.fMatch1 > this.fMatch2) {
                return this.fMatch2;
            }
            return this.fMatch1;
        }

        public boolean isEnclosingTestCase() {
            return this.fPos1 != this.fMatch1 && this.fPos2 != this.fMatch1;
        }

        public boolean isSelectionTestCase() {
            return this.fPos1 != this.fPos2;
        }
    }
}

