/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.junit.Assert;
import org.junit.Test;

public class DefaultTextDoubleClickStrategyTest {
    @Test
    public void testUnderscoreHandling() throws Exception {
        String content = "foo_bar foo__bar foo_1  foo1_bar foo_bar__baz___1 __aaaa a_aa___a   _asdf_  _____1";
        Document document = new Document(content);
        TestSpecificDefaultTextDoubleClickStrategy doubleClickStrategy = new TestSpecificDefaultTextDoubleClickStrategy();
        String[] stringArray = content.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int offsetWordStart;
            String word = stringArray[n2];
            int offset = offsetWordStart = content.indexOf(word);
            while (offset < offsetWordStart + word.length()) {
                IRegion selection = doubleClickStrategy.findWord((IDocument)document, offset);
                String actualWord = document.get(selection.getOffset(), selection.getLength());
                Assert.assertEquals((Object)word, (Object)actualWord);
                ++offset;
            }
            ++n2;
        }
    }

    @Test
    public void testClickAtLineEnd() throws Exception {
        String content = "Hello world\nhow are you";
        Document document = new Document(content);
        TestSpecificDefaultTextDoubleClickStrategy doubleClickStrategy = new TestSpecificDefaultTextDoubleClickStrategy();
        IRegion selection = doubleClickStrategy.findWord((IDocument)document, 11);
        Assert.assertNotNull((String)"Should have selected a word", (Object)selection);
        Assert.assertEquals((String)"Unexpected selection", (Object)"world", (Object)document.get(selection.getOffset(), selection.getLength()));
        selection = doubleClickStrategy.findWord((IDocument)document, document.getLength());
        Assert.assertNotNull((String)"Should have selected a word", (Object)selection);
        Assert.assertEquals((String)"Unexpected selection", (Object)"you", (Object)document.get(selection.getOffset(), selection.getLength()));
    }

    private static final class TestSpecificDefaultTextDoubleClickStrategy
    extends DefaultTextDoubleClickStrategy {
        private TestSpecificDefaultTextDoubleClickStrategy() {
        }

        public IRegion findWord(IDocument document, int offset) {
            return super.findWord(document, offset);
        }
    }
}

