/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.junit.Assert;
import org.junit.Test;

public class FindReplaceDocumentAdapterContentProposalProviderTest {
    private final FindReplaceDocumentAdapterContentProposalProvider provider = new FindReplaceDocumentAdapterContentProposalProvider(true);

    private void assertProposal(IContentProposal[] proposals, String prefix, String replacement) {
        IContentProposal match = null;
        IContentProposal[] iContentProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            IContentProposal p = iContentProposalArray[n2];
            if (p.getLabel().startsWith(prefix)) {
                match = p;
                break;
            }
            ++n2;
        }
        Assert.assertNotNull((String)("No proposal for " + prefix + " found"), match);
        Assert.assertEquals((String)"Unexpected replacement", (Object)replacement, (Object)match.getContent());
    }

    @Test
    public void testEmptyTextProposal() {
        this.assertProposal(this.provider.getProposals("", 0), "\\r", "\\r");
    }

    @Test
    public void testNonEmptyProposal() {
        this.assertProposal(this.provider.getProposals("text", 3), "\\r", "\\r");
    }

    @Test
    public void testBackslashOddProposal() {
        this.assertProposal(this.provider.getProposals("te\\xt", 3), "\\r", "r");
        this.assertProposal(this.provider.getProposals("te\\\\\\xt", 5), "\\r", "r");
    }

    @Test
    public void testBackslashEvenProposal() {
        this.assertProposal(this.provider.getProposals("te\\\\xt", 4), "\\r", "\\r");
        this.assertProposal(this.provider.getProposals("te\\\\\\xt", 4), "\\r", "\\r");
        this.assertProposal(this.provider.getProposals("te\\\\\\\\xt", 6), "\\r", "\\r");
    }
}

