/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.jface.internal.text.SelectionProcessor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMultiTextSelection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MultiTextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MultiSelectionTest {
    @Test
    public void testSelectionProcessor() throws MalformedTreeException, BadLocationException {
        Shell shell = new Shell();
        TextViewer textViewer = new TextViewer((Composite)shell, 0);
        String content = "ababa\nbaba";
        Document document = new Document(content);
        ArrayList<Region> regions = new ArrayList<Region>();
        int index = 0;
        while ((index = document.get().indexOf(97, index)) >= 0) {
            regions.add(new Region(index, 1));
            ++index;
        }
        textViewer.setDocument((IDocument)document);
        SelectionProcessor selectionProcessor = new SelectionProcessor((ITextViewer)textViewer);
        MultiTextSelection selection = new MultiTextSelection((IDocument)document, regions.toArray(new IRegion[regions.size()]));
        Assert.assertEquals((long)2L, (long)selectionProcessor.getCoveredLines((ISelection)selection));
        Assert.assertEquals((Object)"aaaaa", (Object)selectionProcessor.getText((ISelection)selection));
        document.set(content);
        selectionProcessor.doDelete((ISelection)selection);
        Assert.assertEquals((Object)"bb\nbb", (Object)document.get());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0), new Region(1, 0), new Region(2, 0), new Region(4, 0), new Region(5, 0)}, (Object[])((IMultiTextSelection)textViewer.getSelectionProvider().getSelection()).getRegions());
        document.set(content);
        selectionProcessor.doBackspace((ISelection)selection);
        Assert.assertEquals((Object)"bb\nbb", (Object)document.get());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0), new Region(1, 0), new Region(2, 0), new Region(4, 0), new Region(5, 0)}, (Object[])((IMultiTextSelection)textViewer.getSelectionProvider().getSelection()).getRegions());
        document.set(content);
        selectionProcessor.doReplace((ISelection)selection, "cc");
        Assert.assertEquals((Object)"ccbccbcc\nbccbcc", (Object)document.get());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(2, 0), new Region(5, 0), new Region(8, 0), new Region(12, 0), new Region(15, 0)}, (Object[])((IMultiTextSelection)textViewer.getSelectionProvider().getSelection()).getRegions());
        selection = new MultiTextSelection((IDocument)document, (IRegion[])regions.stream().map(region -> new Region(region.getOffset(), 0)).toArray(IRegion[]::new));
        document.set(content);
        selectionProcessor.doDelete((ISelection)selection);
        Assert.assertEquals((Object)"bb\nbb", (Object)document.get());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0), new Region(1, 0), new Region(2, 0), new Region(4, 0), new Region(5, 0)}, (Object[])((IMultiTextSelection)textViewer.getSelectionProvider().getSelection()).getRegions());
        document.set(content);
        selectionProcessor.doBackspace((ISelection)selection);
        Assert.assertEquals((Object)"aaa\naa", (Object)document.get());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0), new Region(1, 0), new Region(2, 0), new Region(4, 0), new Region(5, 0)}, (Object[])((IMultiTextSelection)textViewer.getSelectionProvider().getSelection()).getRegions());
        document.set(content);
        selectionProcessor.doReplace((ISelection)selection, "cc");
        Assert.assertEquals((Object)"ccabccabcca\nbccabcca", (Object)document.get());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(2, 0), new Region(6, 0), new Region(10, 0), new Region(15, 0), new Region(19, 0)}, (Object[])((IMultiTextSelection)textViewer.getSelectionProvider().getSelection()).getRegions());
    }

    @Test
    public void testCopyPaste() throws MalformedTreeException, BadLocationException {
        Shell shell = new Shell();
        TextViewer textViewer = new TextViewer((Composite)shell, 0);
        String content = "ababa\nbaba";
        Document document = new Document(content);
        ArrayList<Region> regions = new ArrayList<Region>();
        int index = 0;
        while ((index = document.get().indexOf(97, index)) >= 0) {
            regions.add(new Region(index, 0));
            ++index;
        }
        textViewer.setDocument((IDocument)document);
        SelectionProcessor selectionProcessor = new SelectionProcessor((ITextViewer)textViewer);
        MultiTextSelection selection = new MultiTextSelection((IDocument)document, regions.toArray(new IRegion[regions.size()]));
        AtomicInteger idx = new AtomicInteger();
        selectionProcessor.doReplace((ISelection)selection, Arrays.stream(selection.getRegions()).mapToInt(r -> idx.getAndIncrement()).mapToObj(Integer::toString).collect(Collectors.joining(System.lineSeparator())));
        Assert.assertEquals((Object)"0ab1ab2a\nb3ab4a", (Object)document.get());
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(1, 0), new Region(4, 0), new Region(7, 0), new Region(11, 0), new Region(14, 0)}, (Object[])((IMultiTextSelection)textViewer.getSelectionProvider().getSelection()).getRegions());
    }

    @Test
    public void testBackspace() throws MalformedTreeException {
        Shell shell = new Shell();
        TextViewer textViewer = new TextViewer((Composite)shell, 0);
        String content = "ababa\nbaba";
        Document document = new Document(content);
        ArrayList<Region> regions = new ArrayList<Region>();
        int index = 0;
        while ((index = document.get().indexOf(97, index)) >= 0) {
            regions.add(new Region(index + 1, 0));
            ++index;
        }
        textViewer.setDocument((IDocument)document);
        MultiTextSelection selection = new MultiTextSelection((IDocument)document, regions.toArray(new IRegion[regions.size()]));
        textViewer.setSelection((ISelection)selection);
        Event keyEvent = new Event();
        keyEvent.type = 1;
        keyEvent.widget = textViewer.getTextWidget();
        keyEvent.display = textViewer.getTextWidget().getDisplay();
        keyEvent.doit = true;
        keyEvent.keyCode = 8;
        keyEvent.character = '\u0000';
        textViewer.getTextWidget().notifyListeners(1, keyEvent);
        Assert.assertEquals((Object)"bb\nbb", (Object)textViewer.getDocument().get());
        ISelection sel = textViewer.getSelection();
        Assert.assertTrue((boolean)(sel instanceof IMultiTextSelection));
        selection = (IMultiTextSelection)sel;
        Assert.assertArrayEquals((Object[])new IRegion[]{new Region(0, 0), new Region(1, 0), new Region(2, 0), new Region(4, 0), new Region(5, 0)}, (Object[])selection.getRegions());
    }

    @Test
    @Ignore(value="this is currently for manual testing")
    public void testViewer() {
        Shell shell = new Shell();
        Button b = new Button((Composite)shell, 8);
        b.setText("Reset selection");
        TextViewer textViewer = new TextViewer((Composite)shell, 0);
        String content = "ababa\nbaba";
        Document document = new Document(content);
        ArrayList<Region> regions = new ArrayList<Region>();
        int index = 0;
        while ((index = document.get().indexOf(97, index)) >= 0) {
            regions.add(new Region(index, 1));
            ++index;
        }
        MultiTextSelection selection = new MultiTextSelection((IDocument)document, regions.toArray(new IRegion[regions.size()]));
        textViewer.setDocument((IDocument)document);
        shell.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)shell);
        shell.pack();
        shell.setVisible(true);
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            textViewer.setSelection((ISelection)selection);
            textViewer.getTextWidget().setFocus();
        }));
        DisplayHelper.sleep((Display)textViewer.getTextWidget().getDisplay(), (long)1000000L);
    }
}

