/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Test;

public class ProjectionViewerTest {
    @Test
    public void testCopyPaste() {
        Shell shell = new Shell();
        shell.setLayout((Layout)new FillLayout());
        ProjectionViewer viewer = new ProjectionViewer((Composite)shell, null, null, false, 0);
        Document document = new Document("/*\n * content\n */");
        viewer.setDocument((IDocument)document, (IAnnotationModel)new AnnotationModel());
        viewer.enableProjection();
        viewer.getProjectionAnnotationModel().addAnnotation((Annotation)new ProjectionAnnotation(false), (Position)new ProjectionPosition((IDocument)document));
        shell.setVisible(true);
        viewer.getTextOperationTarget().doOperation(21);
        viewer.getTextOperationTarget().doOperation(7);
        try {
            Assert.assertEquals((Object)document.get(), (Object)((ITextSelection)viewer.getSelection()).getText());
            viewer.getTextOperationTarget().doOperation(4);
            Assert.assertEquals((Object)document.get(), (Object)new Clipboard(viewer.getTextWidget().getDisplay()).getContents((Transfer)TextTransfer.getInstance()));
        }
        finally {
            shell.dispose();
        }
    }

    private static final class ProjectionPosition
    extends Position
    implements IProjectionPosition {
        public ProjectionPosition(IDocument document) {
            super(0, document.getLength());
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            int firstNewLine = document.get().indexOf(10);
            int secondNewLine = document.get().indexOf(10, firstNewLine + 1);
            return new IRegion[]{new Region(0, firstNewLine + 1), new Region(secondNewLine + 1, document.getLength() - secondNewLine - 1)};
        }

        public int computeCaptionOffset(IDocument document) throws BadLocationException {
            return document.get().indexOf(10) + 1;
        }
    }
}

