/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TabsToSpacesConverter;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.text.tests.TextViewerTest;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Test;

public class TabsToSpacesConverterTest {
    private void doTest(String input, String output, int keyCode, int tabWidth) {
        Shell shell = new Shell();
        TextViewer textViewer = new TextViewer((Composite)shell, 0);
        TabsToSpacesConverter tabToSpacesConverter = new TabsToSpacesConverter();
        tabToSpacesConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
        tabToSpacesConverter.setNumberOfSpacesPerTab(tabWidth);
        tabToSpacesConverter.setDeleteSpacesAsTab(true);
        textViewer.setTabsToSpacesConverter((IAutoEditStrategy)tabToSpacesConverter);
        int selectionFrom = input.indexOf(124);
        int selectionTo = input.indexOf(124, selectionFrom + 1) - 1;
        Document document = new Document(input.replace("|", ""));
        textViewer.setDocument((IDocument)document);
        textViewer.setSelectedRange(selectionFrom, selectionTo - selectionFrom);
        TextViewerTest.postKeyEvent((Control)textViewer.getTextWidget(), keyCode, 0, 1);
        Assert.assertEquals((Object)output, (Object)document.get());
    }

    @Test
    public void testDelete1() {
        this.doTest("||        ABC", "    ABC", 127, 4);
    }

    @Test
    public void testDelete2() {
        this.doTest("    ||    ABC", "    ABC", 127, 4);
    }

    @Test
    public void testDelete3() {
        this.doTest("     ||   ABC", "     ABC", 127, 4);
    }

    @Test
    public void testDelete4() {
        this.doTest("       || ABC", "       ABC", 127, 4);
    }

    @Test
    public void testDeleteRange1() {
        this.doTest("   | |    ABC", "       ABC", 127, 4);
    }

    @Test
    public void testDeleteRange2() {
        this.doTest("    | |   ABC", "       ABC", 127, 4);
    }

    @Test
    public void testDeleteInside1() {
        this.doTest("    ABCD||    EFG", "    ABCDEFG", 127, 4);
    }

    @Test
    public void testDeleteInside2() {
        this.doTest("    ABCD  ||    EFG", "    ABCD    EFG", 127, 4);
    }

    @Test
    public void testDeleteInside3() {
        this.doTest("    ABCD||  EFG", "    ABCDEFG", 127, 4);
    }

    @Test
    public void testDeleteLargeWidth1() {
        this.doTest("  ||          ABC", "    ABC", 127, 10);
    }

    @Test
    public void testDeleteLargeWidth2() {
        this.doTest("        ||    ABC", "          ABC", 127, 10);
    }

    @Test
    public void testDeleteSmallWidth() {
        this.doTest("  ||          ABC", "          ABC", 127, 2);
    }

    @Test
    public void testBackspace1() {
        this.doTest("    ||    ABC", "    ABC", 8, 4);
    }

    @Test
    public void testBackspace2() {
        this.doTest("        ||ABC", "    ABC", 8, 4);
    }

    @Test
    public void testBackspace3() {
        this.doTest("   ||     ABC", "     ABC", 8, 4);
    }

    @Test
    public void testBackspace4() {
        this.doTest("      ||  ABC", "      ABC", 8, 4);
    }

    @Test
    public void testBackspaceRange1() {
        this.doTest("   | |    ABC", "       ABC", 8, 4);
    }

    @Test
    public void testBackspaceRange2() {
        this.doTest("    | |   ABC", "       ABC", 8, 4);
    }

    @Test
    public void testBackspaceInside1() {
        this.doTest("    ABCD    ||EFG", "    ABCDEFG", 8, 4);
    }

    @Test
    public void testBackspaceInside2() {
        this.doTest("    ABCD      ||EFG", "    ABCD    EFG", 8, 4);
    }

    @Test
    public void testBackspaceInside3() {
        this.doTest("    ABCDEF  ||G", "    ABCDEFG", 8, 4);
    }

    @Test
    public void testBackspaceLargeWidth1() {
        this.doTest("            ||  ABC", "            ABC", 8, 10);
    }

    @Test
    public void testBackspaceLargeWidth2() {
        this.doTest("          ||    ABC", "    ABC", 8, 10);
    }

    @Test
    public void testBackspaceSmallWidth() {
        this.doTest("            ||  ABC", "            ABC", 8, 2);
    }

    @Test
    public void testDeleteAfterCollapsedRegion() throws BadLocationException {
        Shell shell = new Shell();
        ProjectionViewer textViewer = new ProjectionViewer((Composite)shell, null, null, false, 0);
        TabsToSpacesConverter tabToSpacesConverter = new TabsToSpacesConverter();
        tabToSpacesConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
        tabToSpacesConverter.setNumberOfSpacesPerTab(4);
        tabToSpacesConverter.setDeleteSpacesAsTab(true);
        textViewer.setTabsToSpacesConverter((IAutoEditStrategy)tabToSpacesConverter);
        Document document = new Document("    COLLAPSED!!!\n    REGION!!!\n    VISIBLE\n    REGION");
        int caretPosition = document.get().indexOf("VISIBLE") - 4;
        textViewer.setDocument((IDocument)document, (IAnnotationModel)new ProjectionAnnotationModel());
        textViewer.enableProjection();
        textViewer.setSelectedRange(caretPosition, 0);
        ProjectionAnnotation annotation = new ProjectionAnnotation(true);
        textViewer.getProjectionAnnotationModel().addAnnotation((Annotation)annotation, new Position(0, document.getLineOffset(2)));
        textViewer.doOperation(21);
        TextViewerTest.postKeyEvent((Control)textViewer.getTextWidget(), 127, 0, 1);
        Assert.assertEquals((Object)"    COLLAPSED!!!\n    REGION!!!\nVISIBLE\n    REGION", (Object)document.get());
    }
}

