/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestWhitespaceCharacterPainter {
    private Shell shell;

    @Before
    public void before() {
        this.shell = new Shell();
        this.shell.setSize(500, 200);
        this.shell.setLayout((Layout)new FillLayout());
    }

    @After
    public void after() {
        this.shell.dispose();
    }

    @Test
    public void multipleSpacesAfterNewLine() throws Exception {
        List<DrawStringParams> params = this.collectDrawStringParamsInPaintControl("\n     \n  ", Arrays.asList(6));
        Assert.assertEquals((long)4L, (long)params.size());
        DrawStringParams first = params.get(0);
        Assert.assertEquals((Object)"\u00b6", (Object)first.str);
        DrawStringParams second = params.get(1);
        Assert.assertEquals((Object)"\u00b7\u00b7\u00b7\u00b7\u00b7", (Object)second.str);
        Assert.assertNotEquals((long)first.y, (long)second.y);
    }

    @Test
    public void multipleSpacesAfterCarriageReturn() throws Exception {
        List<DrawStringParams> params = this.collectDrawStringParamsInPaintControl("\r\n     \r\n  ", Arrays.asList(7));
        Assert.assertEquals((long)4L, (long)params.size());
        DrawStringParams first = params.get(0);
        Assert.assertEquals((Object)"\u00a4\u00b6", (Object)first.str);
        DrawStringParams second = params.get(1);
        Assert.assertEquals((Object)"\u00b7\u00b7\u00b7\u00b7\u00b7", (Object)second.str);
        Assert.assertNotEquals((long)first.y, (long)second.y);
    }

    @Test
    public void glyphMetricsTakenIntoAccount() throws Exception {
        this.verifyDrawStringCalledNTimes("first  \nsecond  \nthird  \n", Arrays.asList(6, 15), 5);
    }

    @Test
    public void glyphMetricsAtNewTakenIntoAccount() throws Exception {
        this.verifyDrawStringCalledNTimes("first  \nsecond", Arrays.asList(7), 2);
    }

    @Test
    public void glyphMetricsAtCarriageReturnTakenIntoAccount() throws Exception {
        this.verifyDrawStringCalledNTimes("first  \r\nsecond", Arrays.asList(7), 2);
    }

    private void verifyDrawStringCalledNTimes(String str, List<Integer> styleRangeOffsets, int times) {
        SourceViewer sourceViewer = new SourceViewer((Composite)this.shell, null, 2560);
        sourceViewer.setDocument((IDocument)new Document(str));
        StyledText textWidget = sourceViewer.getTextWidget();
        textWidget.setFont(JFaceResources.getTextFont());
        WhitespaceCharacterPainter whitespaceCharPainter = new WhitespaceCharacterPainter((ITextViewer)sourceViewer, true, true, true, true, true, true, true, true, true, true, true, 100);
        sourceViewer.addPainter((IPainter)whitespaceCharPainter);
        for (Integer offset : styleRangeOffsets) {
            textWidget.setStyleRange(this.createStyleRangeWithMetrics(offset));
        }
        Event e = new Event();
        e.widget = textWidget;
        PaintEvent ev = new PaintEvent(e);
        ev.gc = (GC)Mockito.mock(GC.class);
        Mockito.when((Object)ev.gc.getClipping()).thenReturn((Object)new Rectangle(0, 0, 100, 100));
        Mockito.when((Object)ev.gc.stringExtent(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<Point>(){

            public Point answer(InvocationOnMock invocation) throws Throwable {
                GC gc = new GC((Drawable)TestWhitespaceCharacterPainter.this.shell);
                gc.setFont(JFaceResources.getTextFont());
                Point result = gc.stringExtent((String)invocation.getArgument(0));
                gc.dispose();
                return result;
            }
        });
        Mockito.when((Object)ev.gc.textExtent(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<Point>(){

            public Point answer(InvocationOnMock invocation) throws Throwable {
                GC gc = new GC((Drawable)TestWhitespaceCharacterPainter.this.shell);
                gc.setFont(JFaceResources.getTextFont());
                Point result = gc.textExtent((String)invocation.getArgument(0));
                gc.dispose();
                return result;
            }
        });
        Mockito.when((Object)ev.gc.getFontMetrics()).thenAnswer((Answer)new Answer<FontMetrics>(){

            public FontMetrics answer(InvocationOnMock invocation) throws Throwable {
                GC gc = new GC((Drawable)TestWhitespaceCharacterPainter.this.shell);
                gc.setFont(JFaceResources.getTextFont());
                FontMetrics metrics = gc.getFontMetrics();
                gc.dispose();
                return metrics;
            }
        });
        ev.x = 0;
        ev.y = 0;
        ev.width = 100;
        ev.height = 100;
        whitespaceCharPainter.paintControl(ev);
        ((GC)Mockito.verify((Object)ev.gc, (VerificationMode)Mockito.times((int)times))).drawString(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean());
    }

    private List<DrawStringParams> collectDrawStringParamsInPaintControl(String source, List<Integer> styleRangeOffsets) {
        SourceViewer sourceViewer = new SourceViewer((Composite)this.shell, null, 2560);
        sourceViewer.setDocument((IDocument)new Document(source));
        StyledText textWidget = sourceViewer.getTextWidget();
        textWidget.setFont(JFaceResources.getTextFont());
        WhitespaceCharacterPainter whitespaceCharPainter = new WhitespaceCharacterPainter((ITextViewer)sourceViewer, true, true, true, true, true, true, true, true, true, true, true, 100);
        sourceViewer.addPainter((IPainter)whitespaceCharPainter);
        for (Integer offset : styleRangeOffsets) {
            textWidget.setStyleRange(this.createStyleRangeWithMetrics(offset));
        }
        Event e = new Event();
        e.widget = textWidget;
        PaintEvent ev = new PaintEvent(e);
        ev.gc = (GC)Mockito.mock(GC.class);
        Mockito.when((Object)ev.gc.getClipping()).thenReturn((Object)new Rectangle(0, 0, 100, 100));
        Mockito.when((Object)ev.gc.stringExtent(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<Point>(){

            public Point answer(InvocationOnMock invocation) throws Throwable {
                GC gc = new GC((Drawable)TestWhitespaceCharacterPainter.this.shell);
                gc.setFont(JFaceResources.getTextFont());
                Point result = gc.stringExtent((String)invocation.getArgument(0));
                gc.dispose();
                return result;
            }
        });
        Mockito.when((Object)ev.gc.textExtent(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<Point>(){

            public Point answer(InvocationOnMock invocation) throws Throwable {
                GC gc = new GC((Drawable)TestWhitespaceCharacterPainter.this.shell);
                gc.setFont(JFaceResources.getTextFont());
                Point result = gc.textExtent((String)invocation.getArgument(0));
                gc.dispose();
                return result;
            }
        });
        Mockito.when((Object)ev.gc.getFontMetrics()).thenAnswer((Answer)new Answer<FontMetrics>(){

            public FontMetrics answer(InvocationOnMock invocation) throws Throwable {
                GC gc = new GC((Drawable)TestWhitespaceCharacterPainter.this.shell);
                gc.setFont(JFaceResources.getTextFont());
                FontMetrics metrics = gc.getFontMetrics();
                gc.dispose();
                return metrics;
            }
        });
        final ArrayList<DrawStringParams> params = new ArrayList<DrawStringParams>();
        ((GC)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                String str = (String)invocation.getArgument(0, String.class);
                Integer x = (Integer)invocation.getArgument(1, Integer.class);
                Integer y = (Integer)invocation.getArgument(2, Integer.class);
                params.add(new DrawStringParams(str, x, y));
                return null;
            }
        }).when((Object)ev.gc)).drawString(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean());
        ev.x = 0;
        ev.y = 0;
        ev.width = 100;
        ev.height = 100;
        whitespaceCharPainter.paintControl(ev);
        return params;
    }

    private StyleRange createStyleRangeWithMetrics(int start) {
        StyleRange sr = new StyleRange();
        sr.start = start;
        sr.metrics = new GlyphMetrics(20, 20, 20);
        return sr;
    }

    private record DrawStringParams(String str, int x, int y) {
    }
}

