/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextPresentationTest {
    private static final int NORMAL = 0;
    private static final int BOLD = 1;
    private TextPresentation fTextPresentation;
    private StyleRange[] fAllRanges;
    private StyleRange[] fNonDefaultRanges;
    private final ArrayList<Color> fColors = new ArrayList();
    private Display fDisplay;

    @Before
    public void setUp() {
        this.fDisplay = Display.getDefault();
        this.setUpStyleRanges();
        this.setUpTextPresentation();
    }

    private void setUpStyleRanges() {
        this.fAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        this.fNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
    }

    private void setUpTextPresentation() {
        this.fTextPresentation = new TextPresentation();
        this.fTextPresentation.setDefaultStyleRange(this.createStyleRange(0, 140, 0));
        StyleRange[] styleRangeArray = this.fAllRanges;
        int n = this.fAllRanges.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange range = styleRangeArray[n2];
            this.fTextPresentation.addStyleRange(range);
            ++n2;
        }
    }

    @After
    public void tearDown() {
        this.fColors.clear();
        if (!this.fDisplay.isDisposed()) {
            Shell[] shellArray = this.fDisplay.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                shell.dispose();
                ++n2;
            }
        }
    }

    private StyleRange createStyleRange(int start, int end, int style) {
        return this.createStyleRange(start, end, style, null, null);
    }

    private StyleRange createStyleRange(int start, int end, int style, Color foreground, Color background) {
        return new StyleRange(start, end - start, foreground, background, style);
    }

    private StyleRange createStyleRange(int start, int end, int style, int foreground, int background) {
        return this.createStyleRange(start, end, style, this.createColor(foreground, foreground, foreground), this.createColor(background, background, background));
    }

    private Color createColor(int red, int green, int blue) {
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            return null;
        }
        Color c = new Color((Device)this.fDisplay, red, green, blue);
        this.fColors.add(c);
        return c;
    }

    protected void checkRegions(StyleRange[] expectedAllRanges, StyleRange[] expectedNonDefaultRanges) {
        this.checkRegions(expectedAllRanges, this.fTextPresentation.getAllStyleRangeIterator(), true);
        this.checkRegions(expectedNonDefaultRanges, this.fTextPresentation.getNonDefaultStyleRangeIterator(), false);
        StyleRange defaultRange = this.fTextPresentation.getDefaultStyleRange();
        this.fTextPresentation.setDefaultStyleRange(null);
        this.checkRegions(expectedAllRanges, this.fTextPresentation.getAllStyleRangeIterator(), true);
        this.checkRegions(expectedAllRanges, this.fTextPresentation.getNonDefaultStyleRangeIterator(), true);
        this.fTextPresentation.setDefaultStyleRange(defaultRange);
    }

    private void checkRegions(StyleRange[] expectedRanges, Iterator<StyleRange> rangeIterator, boolean withDefaults) {
        StyleRange defaultRange = this.fTextPresentation.getDefaultStyleRange();
        int start = -1;
        int end = -1;
        int lastEnd = defaultRange != null ? defaultRange.start : Integer.MIN_VALUE;
        int i = 0;
        while (i < expectedRanges.length) {
            StyleRange expectedRange = expectedRanges[i];
            Assert.assertTrue((String)"Presentation has less ranges than expected.", (boolean)rangeIterator.hasNext());
            StyleRange actualRange = rangeIterator.next();
            Assert.assertEquals((Object)expectedRange, (Object)actualRange);
            Assert.assertTrue((String)"Unexpected default style.", (withDefaults || !actualRange.similarTo(defaultRange) ? 1 : 0) != 0);
            Assert.assertTrue((String)"Overlapping or wrong ordered style.", (lastEnd <= actualRange.start ? 1 : 0) != 0);
            lastEnd = actualRange.start + actualRange.length;
            if (i == 0) {
                start = actualRange.start;
                StyleRange first = this.fTextPresentation.getFirstStyleRange();
                if (withDefaults) {
                    Assert.assertEquals((String)"getFirstStyleRange() failed", (Object)expectedRange, (Object)first);
                } else {
                    Assert.assertTrue((String)"getFirstStyleRange() failed", (first.equals((Object)expectedRange) || first.similarTo(defaultRange) ? 1 : 0) != 0);
                }
            } else if (i == expectedRanges.length - 1) {
                end = actualRange.start + actualRange.length;
                StyleRange last = this.fTextPresentation.getLastStyleRange();
                if (withDefaults) {
                    Assert.assertEquals((String)"getLastStyleRange() failed", (Object)expectedRange, (Object)last);
                } else {
                    Assert.assertTrue((String)"getLastStyleRange() failed", (last.equals((Object)expectedRange) || last.similarTo(defaultRange) ? 1 : 0) != 0);
                }
            }
            ++i;
        }
        Assert.assertTrue((String)"Presentation has more ranges than expected.", (!rangeIterator.hasNext() ? 1 : 0) != 0);
        if (withDefaults) {
            Assert.assertEquals((String)"getDenumerableRanges() failed", (long)expectedRanges.length, (long)this.fTextPresentation.getDenumerableRanges());
        }
        Assert.assertEquals((String)"isEmpty() failed", (Object)(expectedRanges.length == 0 && defaultRange == null ? 1 : 0), (Object)this.fTextPresentation.isEmpty());
        Object expectedCover = defaultRange == null ? (start == -1 && end == -1 ? null : new Region(start, end - start)) : new Region(defaultRange.start, defaultRange.length);
        Assert.assertEquals((String)"Wrong coverage", (Object)expectedCover, (Object)this.fTextPresentation.getCoverage());
    }

    @Test
    public void testUnclippedRegions() {
        this.checkRegions(this.fAllRanges, this.fNonDefaultRanges);
    }

    @Test
    public void testClippedRegions1() {
        this.fTextPresentation.setResultWindow((IRegion)new Region(0, 140));
        this.checkRegions(this.fAllRanges, this.fNonDefaultRanges);
    }

    @Test
    public void testClippedRegions2() {
        this.fTextPresentation.setResultWindow((IRegion)new Region(30, 70));
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 17, 0), this.createStyleRange(17, 24, 1), this.createStyleRange(24, 66, 0), this.createStyleRange(66, 70, 1)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(17, 24, 1), this.createStyleRange(66, 70, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange1() {
        StyleRange range = this.createStyleRange(0, 2, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 2, 0, 1, -1), this.createStyleRange(2, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(0, 2, 0, 1, -1), this.createStyleRange(4, 20, 1), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange2() {
        StyleRange range = this.createStyleRange(138, 140, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 138, 0), this.createStyleRange(138, 140, 0, 1, -1)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1), this.createStyleRange(138, 140, 0, 1, -1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange3() {
        StyleRange range = this.createStyleRange(20, 22, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 22, 0, 1, -1), this.createStyleRange(22, 47, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(20, 22, 0, 1, -1), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange4() {
        StyleRange range = this.createStyleRange(22, 24, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 22, 0), this.createStyleRange(22, 24, 0, 1, -1), this.createStyleRange(24, 47, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(22, 24, 0, 1, -1), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange5() {
        StyleRange range = this.createStyleRange(45, 47, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 45, 0), this.createStyleRange(45, 47, 0, 1, -1), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(45, 47, 0, 1, -1), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange6() {
        StyleRange range = this.createStyleRange(47, 49, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 49, 1, 1, -1), this.createStyleRange(49, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 49, 1, 1, -1), this.createStyleRange(49, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange7() {
        StyleRange range = this.createStyleRange(49, 51, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 49, 1), this.createStyleRange(49, 51, 1, 1, -1), this.createStyleRange(51, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 49, 1), this.createStyleRange(49, 51, 1, 1, -1), this.createStyleRange(51, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange8() {
        StyleRange range = this.createStyleRange(52, 54, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 52, 1), this.createStyleRange(52, 54, 1, 1, -1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 52, 1), this.createStyleRange(52, 54, 1, 1, -1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange9() {
        StyleRange range = this.createStyleRange(45, 49, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 45, 0), this.createStyleRange(45, 47, 0, 1, -1), this.createStyleRange(47, 49, 1, 1, -1), this.createStyleRange(49, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(45, 47, 0, 1, -1), this.createStyleRange(47, 49, 1, 1, -1), this.createStyleRange(49, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange10() {
        StyleRange range = this.createStyleRange(52, 56, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 52, 1), this.createStyleRange(52, 54, 1, 1, -1), this.createStyleRange(54, 56, 0, 1, -1), this.createStyleRange(56, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 52, 1), this.createStyleRange(52, 54, 1, 1, -1), this.createStyleRange(54, 56, 0, 1, -1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange11() {
        StyleRange range = this.createStyleRange(45, 56, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 45, 0), this.createStyleRange(45, 47, 0, 1, -1), this.createStyleRange(47, 54, 1, 1, -1), this.createStyleRange(54, 56, 0, 1, -1), this.createStyleRange(56, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(45, 47, 0, 1, -1), this.createStyleRange(47, 54, 1, 1, -1), this.createStyleRange(54, 56, 0, 1, -1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange12() {
        StyleRange range = this.createStyleRange(52, 98, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 52, 1), this.createStyleRange(52, 54, 1, 1, -1), this.createStyleRange(54, 96, 0, 1, -1), this.createStyleRange(96, 98, 1, 1, -1), this.createStyleRange(98, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 52, 1), this.createStyleRange(52, 54, 1, 1, -1), this.createStyleRange(54, 96, 0, 1, -1), this.createStyleRange(96, 98, 1, 1, -1), this.createStyleRange(98, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange13() {
        StyleRange range = this.createStyleRange(20, 47, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0, 1, -1), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0, 1, -1), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange14() {
        StyleRange range = this.createStyleRange(47, 54, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 54, 1, 1, -1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 54, 1, 1, -1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange15() {
        StyleRange range = this.createStyleRange(0, 140, 0, 1, -1);
        Color expectedColor = this.createColor(1, 1, 1);
        StyleRange[] expectedAllRanges = new StyleRange[this.fAllRanges.length];
        int i = 0;
        while (i < this.fAllRanges.length) {
            expectedAllRanges[i] = (StyleRange)this.fAllRanges[i].clone();
            expectedAllRanges[i].foreground = expectedColor;
            ++i;
        }
        StyleRange[] expectedNonDefaultRanges = expectedAllRanges;
        this.fTextPresentation.mergeStyleRange(range);
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
        range = this.createStyleRange(-100, 200, 1);
        int i2 = 0;
        while (i2 < expectedAllRanges.length) {
            expectedAllRanges[i2].fontStyle = 1;
            ++i2;
        }
        this.fTextPresentation.mergeStyleRange(range);
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
        this.fTextPresentation.setDefaultStyleRange(null);
        range = this.createStyleRange(-150, 250, 0, -1, 2);
        expectedColor = this.createColor(2, 2, 2);
        i2 = 0;
        while (i2 < expectedAllRanges.length) {
            expectedAllRanges[i2].background = expectedColor;
            ++i2;
        }
        StyleRange[] newExpectedRanges = new StyleRange[expectedAllRanges.length + 2];
        System.arraycopy(expectedAllRanges, 0, newExpectedRanges, 1, expectedAllRanges.length);
        newExpectedRanges[0] = this.createStyleRange(-150, 0, 0, -1, 2);
        newExpectedRanges[newExpectedRanges.length - 1] = this.createStyleRange(140, 250, 0, -1, 2);
        this.fTextPresentation.mergeStyleRange(range);
        this.checkRegions(newExpectedRanges, newExpectedRanges);
    }

    @Test
    public void testMergeStyleRange16() {
        StyleRange range = this.createStyleRange(20, 47, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0, 1, -1), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0, 1, -1), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange17() {
        StyleRange range = this.createStyleRange(47, 54, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 54, 1, 1, -1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(47, 54, 1, 1, -1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange18() {
        StyleRange range = this.createStyleRange(20, 96, 0, 1, -1);
        this.fTextPresentation.mergeStyleRange(range);
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0, 1, -1), this.createStyleRange(47, 54, 1, 1, -1), this.createStyleRange(54, 96, 0, 1, -1), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0, 1, -1), this.createStyleRange(47, 54, 1, 1, -1), this.createStyleRange(54, 96, 0, 1, -1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange22() {
        StyleRange range = this.createStyleRange(-5, 145, 1, 1, -1);
        Color expectedColor = this.createColor(1, 1, 1);
        StyleRange[] expectedAllRanges = new StyleRange[this.fAllRanges.length];
        int i = 0;
        while (i < this.fAllRanges.length) {
            expectedAllRanges[i] = (StyleRange)this.fAllRanges[i].clone();
            expectedAllRanges[i].fontStyle = 1;
            expectedAllRanges[i].foreground = expectedColor;
            ++i;
        }
        StyleRange[] expectedNonDefaultRanges = expectedAllRanges;
        this.fTextPresentation.mergeStyleRange(range);
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRange23() {
        this.fTextPresentation.setDefaultStyleRange(null);
        StyleRange range = this.createStyleRange(-5, 145, 1, 1, -1);
        Color expectedColor = this.createColor(1, 1, 1);
        StyleRange[] expectedAllRanges = new StyleRange[this.fAllRanges.length + 2];
        expectedAllRanges[0] = this.createStyleRange(-5, 0, 1, 1, -1);
        int i = 0;
        while (i < this.fAllRanges.length) {
            expectedAllRanges[i + 1] = (StyleRange)this.fAllRanges[i].clone();
            expectedAllRanges[i + 1].fontStyle = 1;
            expectedAllRanges[i + 1].foreground = expectedColor;
            ++i;
        }
        expectedAllRanges[expectedAllRanges.length - 1] = this.createStyleRange(140, 145, 1, 1, -1);
        StyleRange[] expectedNonDefaultRanges = expectedAllRanges;
        this.fTextPresentation.mergeStyleRange(range);
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testApplyStyleRange1() {
        StyleRange range;
        this.fTextPresentation.clear();
        this.fTextPresentation.setDefaultStyleRange(this.createStyleRange(0, 140, 0));
        StyleRange[] styleRangeArray = TextPresentationTest.deepClone(this.fAllRanges);
        int n = styleRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            range = styleRangeArray[n2];
            this.fTextPresentation.mergeStyleRange(range);
            ++n2;
        }
        this.checkRegions(this.fAllRanges, this.fNonDefaultRanges);
        this.fTextPresentation.clear();
        this.fTextPresentation.setDefaultStyleRange(this.createStyleRange(0, 140, 0));
        styleRangeArray = TextPresentationTest.deepClone(this.fAllRanges);
        n = styleRangeArray.length;
        n2 = 0;
        while (n2 < n) {
            range = styleRangeArray[n2];
            this.fTextPresentation.replaceStyleRange(range);
            ++n2;
        }
        this.checkRegions(this.fAllRanges, this.fNonDefaultRanges);
    }

    @Test
    public void testApplyStyleRange2() {
        StyleRange range;
        this.fTextPresentation.clear();
        StyleRange[] styleRangeArray = TextPresentationTest.deepClone(this.fAllRanges);
        int n = styleRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            range = styleRangeArray[n2];
            this.fTextPresentation.mergeStyleRange(range);
            ++n2;
        }
        this.checkRegions(this.fAllRanges, this.fAllRanges);
        this.fTextPresentation.clear();
        styleRangeArray = TextPresentationTest.deepClone(this.fAllRanges);
        n = styleRangeArray.length;
        n2 = 0;
        while (n2 < n) {
            range = styleRangeArray[n2];
            this.fTextPresentation.replaceStyleRange(range);
            ++n2;
        }
        this.checkRegions(this.fAllRanges, this.fAllRanges);
    }

    @Test
    public void testApplyStyleRange3() {
        StyleRange range;
        this.fTextPresentation.clear();
        this.fTextPresentation.mergeStyleRange(this.createStyleRange(0, 140, 0));
        StyleRange[] styleRangeArray = TextPresentationTest.deepClone(this.fAllRanges);
        int n = styleRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            range = styleRangeArray[n2];
            this.fTextPresentation.mergeStyleRange(range);
            ++n2;
        }
        this.checkRegions(this.fAllRanges, this.fAllRanges);
        this.fTextPresentation.clear();
        this.fTextPresentation.mergeStyleRange(this.createStyleRange(0, 140, 0));
        styleRangeArray = TextPresentationTest.deepClone(this.fAllRanges);
        n = styleRangeArray.length;
        n2 = 0;
        while (n2 < n) {
            range = styleRangeArray[n2];
            this.fTextPresentation.replaceStyleRange(range);
            ++n2;
        }
        this.checkRegions(this.fAllRanges, this.fAllRanges);
    }

    @Test
    public void testApplyStyleRange4() {
        StyleRange empty = this.createStyleRange(0, 0, 1);
        this.fTextPresentation.mergeStyleRange(empty);
        this.checkRegions(this.fAllRanges, this.fNonDefaultRanges);
        this.fTextPresentation.replaceStyleRange(empty);
        this.checkRegions(this.fAllRanges, this.fNonDefaultRanges);
    }

    @Test
    public void testLinkMerge() {
        Color linkColor = this.createColor(0, 0, 255);
        StyleRange[] ranges = new StyleRange[]{this.createStyleRange(4, 20, 0), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 54, 0), this.createStyleRange(96, 102, 0, 1, -1), this.createStyleRange(102, 140, 0)};
        ranges[0].underline = true;
        ranges[1].underline = true;
        ranges[1].underlineStyle = 0;
        ranges[2].underline = true;
        ranges[2].underlineStyle = 1;
        ranges[4].underline = true;
        ranges[4].underlineStyle = 4;
        ranges[4].foreground = linkColor;
        StyleRange[] styleRangeArray = TextPresentationTest.deepClone(ranges);
        int n = styleRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange range = styleRangeArray[n2];
            this.fTextPresentation.mergeStyleRange(range);
            ++n2;
        }
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1, 1, -1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{expectedAllRanges[1], expectedAllRanges[2], expectedAllRanges[3], expectedAllRanges[5], expectedAllRanges[6]};
        expectedNonDefaultRanges[0].underline = true;
        expectedNonDefaultRanges[1].underline = true;
        expectedNonDefaultRanges[1].underlineStyle = 0;
        expectedNonDefaultRanges[2].underline = true;
        expectedNonDefaultRanges[2].underlineStyle = 1;
        expectedNonDefaultRanges[4].underline = true;
        expectedNonDefaultRanges[4].underlineStyle = 4;
        expectedNonDefaultRanges[4].foreground = linkColor;
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
        int i = 0;
        while (i < 3) {
            ranges[i].underlineStyle = 4;
            ranges[i].foreground = linkColor;
            expectedNonDefaultRanges[i].underlineStyle = 4;
            expectedNonDefaultRanges[i].foreground = linkColor;
            ++i;
        }
        ranges[3].underlineStyle = 4;
        ranges[3].foreground = null;
        expectedNonDefaultRanges[3].underlineStyle = 4;
        expectedNonDefaultRanges[3].foreground = null;
        ranges[4].underlineStyle = 3;
        StyleRange[] styleRangeArray2 = ranges;
        int n3 = ranges.length;
        int n4 = 0;
        while (n4 < n3) {
            StyleRange range = styleRangeArray2[n4];
            this.fTextPresentation.mergeStyleRange(range);
            ++n4;
        }
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeAll() {
        StyleRange range = this.createStyleRange(4, 20, 1, 1, 2);
        range.borderColor = this.createColor(3, 3, 3);
        range.borderStyle = 2;
        range.font = this.fDisplay.getSystemFont();
        range.metrics = new GlyphMetrics(0, 0, 10);
        range.strikeout = true;
        range.strikeoutColor = this.createColor(4, 4, 4);
        range.underline = true;
        range.underlineColor = this.createColor(5, 5, 5);
        range.underlineStyle = 3;
        this.fTextPresentation.mergeStyleRange((StyleRange)range.clone());
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 4, 0), (StyleRange)range.clone(), this.createStyleRange(20, 47, 0), this.createStyleRange(47, 54, 1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 140, 0)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{(StyleRange)range.clone(), this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
        range.background = null;
        range.borderColor = null;
        range.borderStyle = 0;
        range.font = null;
        range.fontStyle = 0;
        range.foreground = null;
        range.metrics = null;
        range.strikeout = false;
        range.strikeoutColor = null;
        range.underline = false;
        range.underlineColor = null;
        range.underlineStyle = 0;
        this.fTextPresentation.mergeStyleRange((StyleRange)range.clone());
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
        this.fTextPresentation.replaceStyleRange((StyleRange)range.clone());
        expectedAllRanges[1] = range;
        expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(47, 54, 1), this.createStyleRange(96, 102, 1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testMergeStyleRanges1() {
        StyleRange[] ranges = new StyleRange[]{this.createStyleRange(0, 2, 0, 1, -1), this.createStyleRange(20, 22, 0, 1, -1), this.createStyleRange(24, 26, 0, 1, -1), this.createStyleRange(45, 47, 0, 1, -1), this.createStyleRange(47, 49, 0, 1, -1), this.createStyleRange(50, 51, 0, 1, -1), this.createStyleRange(52, 54, 0, 1, -1), this.createStyleRange(138, 140, 0, 1, -1)};
        this.fTextPresentation.mergeStyleRanges(TextPresentationTest.deepClone(ranges));
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 2, 0, 1, -1), this.createStyleRange(2, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 22, 0, 1, -1), this.createStyleRange(22, 24, 0), this.createStyleRange(24, 26, 0, 1, -1), this.createStyleRange(26, 45, 0), this.createStyleRange(45, 47, 0, 1, -1), this.createStyleRange(47, 49, 1, 1, -1), this.createStyleRange(49, 50, 1), this.createStyleRange(50, 51, 1, 1, -1), this.createStyleRange(51, 52, 1), this.createStyleRange(52, 54, 1, 1, -1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 138, 0), this.createStyleRange(138, 140, 0, 1, -1)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(0, 2, 0, 1, -1), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 22, 0, 1, -1), this.createStyleRange(24, 26, 0, 1, -1), this.createStyleRange(45, 47, 0, 1, -1), this.createStyleRange(47, 49, 1, 1, -1), this.createStyleRange(49, 50, 1), this.createStyleRange(50, 51, 1, 1, -1), this.createStyleRange(51, 52, 1), this.createStyleRange(52, 54, 1, 1, -1), this.createStyleRange(96, 102, 1), this.createStyleRange(138, 140, 0, 1, -1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
        StyleRange[] styleRangeArray = ranges;
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange r = styleRangeArray[n2];
            Color c = r.foreground;
            r.foreground = r.background;
            r.background = c;
            ++n2;
        }
        styleRangeArray = new StyleRange[][]{expectedAllRanges, expectedNonDefaultRanges};
        n = styleRangeArray.length;
        n2 = 0;
        while (n2 < n) {
            StyleRange rs;
            StyleRange styleRange = rs = styleRangeArray[n2];
            int n3 = ((StyleRange)styleRange).length;
            int n4 = 0;
            while (n4 < n3) {
                StyleRange r = styleRange[n4];
                r.background = r.foreground;
                ++n4;
            }
            ++n2;
        }
        this.fTextPresentation.mergeStyleRanges(ranges);
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testReplaceStyleRanges1() {
        StyleRange[] ranges = new StyleRange[]{this.createStyleRange(0, 2, 0, 1, -1), this.createStyleRange(20, 22, 0, 1, -1), this.createStyleRange(24, 26, 0, 1, -1), this.createStyleRange(45, 47, 0, 1, -1), this.createStyleRange(47, 49, 0, 1, -1), this.createStyleRange(50, 51, 0, 1, -1), this.createStyleRange(52, 54, 0, 1, -1), this.createStyleRange(138, 140, 0, 1, -1)};
        this.fTextPresentation.replaceStyleRanges(TextPresentationTest.deepClone(ranges));
        StyleRange[] expectedAllRanges = new StyleRange[]{this.createStyleRange(0, 2, 0, 1, -1), this.createStyleRange(2, 4, 0), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 22, 0, 1, -1), this.createStyleRange(22, 24, 0), this.createStyleRange(24, 26, 0, 1, -1), this.createStyleRange(26, 45, 0), this.createStyleRange(45, 47, 0, 1, -1), this.createStyleRange(47, 49, 0, 1, -1), this.createStyleRange(49, 50, 1), this.createStyleRange(50, 51, 0, 1, -1), this.createStyleRange(51, 52, 1), this.createStyleRange(52, 54, 0, 1, -1), this.createStyleRange(54, 96, 0), this.createStyleRange(96, 102, 1), this.createStyleRange(102, 138, 0), this.createStyleRange(138, 140, 0, 1, -1)};
        StyleRange[] expectedNonDefaultRanges = new StyleRange[]{this.createStyleRange(0, 2, 0, 1, -1), this.createStyleRange(4, 20, 1), this.createStyleRange(20, 22, 0, 1, -1), this.createStyleRange(24, 26, 0, 1, -1), this.createStyleRange(45, 47, 0, 1, -1), this.createStyleRange(47, 49, 0, 1, -1), this.createStyleRange(49, 50, 1), this.createStyleRange(50, 51, 0, 1, -1), this.createStyleRange(51, 52, 1), this.createStyleRange(52, 54, 0, 1, -1), this.createStyleRange(96, 102, 1), this.createStyleRange(138, 140, 0, 1, -1)};
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
        StyleRange[][] styleRangeArrayArray = new StyleRange[][]{ranges, expectedAllRanges, expectedNonDefaultRanges};
        int n = styleRangeArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange[] rs;
            StyleRange[] styleRangeArray = rs = styleRangeArrayArray[n2];
            int n3 = rs.length;
            int n4 = 0;
            while (n4 < n3) {
                StyleRange r = styleRangeArray[n4];
                Color c = r.foreground;
                r.foreground = r.background;
                r.background = c;
                ++n4;
            }
            ++n2;
        }
        this.fTextPresentation.replaceStyleRanges(ranges);
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testReplaceStyleRange2() {
        StyleRange range = this.createStyleRange(0, 140, 1, 1, -1);
        this.fTextPresentation.replaceStyleRange(range);
        Color expectedColor = this.createColor(1, 1, 1);
        StyleRange[] expectedAllRanges = new StyleRange[this.fAllRanges.length];
        int i = 0;
        while (i < this.fAllRanges.length) {
            expectedAllRanges[i] = (StyleRange)this.fAllRanges[i].clone();
            expectedAllRanges[i].fontStyle = 1;
            expectedAllRanges[i].foreground = expectedColor;
            ++i;
        }
        StyleRange[] expectedNonDefaultRanges = expectedAllRanges;
        this.checkRegions(expectedAllRanges, expectedNonDefaultRanges);
    }

    @Test
    public void testExtend() {
        this.fTextPresentation.setDefaultStyleRange(null);
        Assert.assertEquals((Object)new Region(0, 140), (Object)this.fTextPresentation.getExtent());
        this.fTextPresentation.setDefaultStyleRange(this.createStyleRange(0, 150, 0));
        Assert.assertEquals((Object)new Region(0, 150), (Object)this.fTextPresentation.getExtent());
        this.fTextPresentation.setDefaultStyleRange(null);
        this.fTextPresentation.setResultWindow((IRegion)new Region(100, 10));
        Assert.assertEquals((Object)new Region(0, 10), (Object)this.fTextPresentation.getExtent());
        this.fTextPresentation.setDefaultStyleRange(this.createStyleRange(0, 150, 0));
        Assert.assertEquals((Object)new Region(0, 10), (Object)this.fTextPresentation.getExtent());
        this.fTextPresentation = new TextPresentation((IRegion)new Region(0, 160), 10);
        Assert.assertEquals((Object)new Region(0, 160), (Object)this.fTextPresentation.getExtent());
        this.fTextPresentation.setDefaultStyleRange(this.createStyleRange(0, 150, 0));
        Assert.assertEquals((Object)new Region(0, 160), (Object)this.fTextPresentation.getExtent());
        this.fTextPresentation.setDefaultStyleRange(null);
        this.fTextPresentation.setResultWindow((IRegion)new Region(100, 10));
        Assert.assertEquals((Object)new Region(0, 10), (Object)this.fTextPresentation.getExtent());
        this.fTextPresentation.setDefaultStyleRange(this.createStyleRange(0, 150, 0));
        Assert.assertEquals((Object)new Region(0, 10), (Object)this.fTextPresentation.getExtent());
    }

    @Test
    public void testExtendUndefined() {
        this.fTextPresentation = new TextPresentation((IRegion)new Region(0, 160), 10);
        this.fTextPresentation.setResultWindow((IRegion)new Region(-10, 5));
        Assert.assertEquals((Object)new Region(10, -5), (Object)this.fTextPresentation.getExtent());
        this.fTextPresentation.setResultWindow((IRegion)new Region(-10, 30));
        Assert.assertEquals((Object)new Region(10, 20), (Object)this.fTextPresentation.getExtent());
        this.fTextPresentation.setResultWindow((IRegion)new Region(150, 30));
        Assert.assertEquals((Object)new Region(0, 10), (Object)this.fTextPresentation.getExtent());
        this.fTextPresentation.setResultWindow((IRegion)new Region(200, 30));
        Assert.assertEquals((Object)new Region(0, -40), (Object)this.fTextPresentation.getExtent());
    }

    @Test
    public void testEmptyPresentation() {
        this.fTextPresentation.clear();
        this.checkRegions(new StyleRange[0], new StyleRange[0]);
        this.fTextPresentation.setResultWindow((IRegion)new Region(4, 10));
        this.checkRegions(new StyleRange[0], new StyleRange[0]);
        this.fTextPresentation.setResultWindow(null);
        StyleRange defaultRange = this.createStyleRange(0, 50, 1);
        this.fTextPresentation.setDefaultStyleRange(defaultRange);
        this.checkRegions(new StyleRange[0], new StyleRange[0]);
        this.fTextPresentation.setResultWindow((IRegion)new Region(4, 10));
        this.checkRegions(new StyleRange[0], new StyleRange[0]);
        this.fTextPresentation = new TextPresentation((IRegion)new Region(0, 100), 1);
        Assert.assertEquals((Object)new Region(0, 100), (Object)this.fTextPresentation.getExtent());
        this.fTextPresentation.setResultWindow((IRegion)new Region(4, 10));
        Assert.assertEquals((Object)new Region(0, 10), (Object)this.fTextPresentation.getExtent());
    }

    @Test
    public void testApplyTextPresentation() {
        Shell shell = new Shell(this.fDisplay);
        try {
            StyledText text = new StyledText((Composite)shell, 0);
            text.setText(String.join((CharSequence)"", Collections.nCopies(this.fTextPresentation.getCoverage().getLength(), ".")));
            TextPresentation.applyTextPresentation((TextPresentation)this.fTextPresentation, (StyledText)text);
            Assert.assertArrayEquals((Object[])this.fAllRanges, (Object[])text.getStyleRanges());
        }
        finally {
            shell.dispose();
        }
    }

    @Test
    public void testIterator() {
        Iterator e = this.fTextPresentation.getAllStyleRangeIterator();
        try {
            int i = 0;
            while (i < 1000) {
                e.next();
                ++i;
            }
            Assert.fail((String)"Iterator has no end.");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        e = this.fTextPresentation.getNonDefaultStyleRangeIterator();
        try {
            int i = 0;
            while (i < 1000) {
                e.next();
                ++i;
            }
            Assert.fail((String)"Iterator has no end.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private static StyleRange[] deepClone(StyleRange[] original) {
        StyleRange[] clone = new StyleRange[original.length];
        int i = 0;
        while (i < original.length) {
            clone[i] = (StyleRange)original[i].clone();
            ++i;
        }
        return clone;
    }
}

