/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.test.Screenshots;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class TextViewerTest {
    private Shell fShell;
    @Rule
    public TestWatcher screenshotRule = Screenshots.onFailure(() -> this.fShell);

    @Before
    public void before() {
        this.fShell = new Shell();
    }

    @Test
    public void testSetRedraw_Bug441827() throws Exception {
        TextViewer textViewer = new TextViewer((Composite)this.fShell, 0);
        Document document = new Document("abc");
        textViewer.setDocument((IDocument)document);
        int len = document.getLength();
        textViewer.setSelectedRange(len, -len);
        Assert.assertEquals((long)0L, (long)textViewer.getSelectedRange().x);
        Assert.assertEquals((long)len, (long)textViewer.getSelectedRange().y);
        Assert.assertEquals((long)0L, (long)textViewer.getTextWidget().getCaretOffset());
        textViewer.setRedraw(false);
        textViewer.setRedraw(true);
        Assert.assertEquals((long)0L, (long)textViewer.getSelectedRange().x);
        Assert.assertEquals((long)len, (long)textViewer.getSelectedRange().y);
        Assert.assertEquals((long)0L, (long)textViewer.getTextWidget().getCaretOffset());
    }

    @Test
    public void testCaretMoveChangesSelection() throws Exception {
        TextViewer textViewer = new TextViewer((Composite)this.fShell, 0);
        Document document = new Document("abc");
        textViewer.setDocument((IDocument)document);
        int len = document.getLength();
        textViewer.setSelectedRange(0, len);
        ITextSelection selection = (ITextSelection)textViewer.getSelectionProvider().getSelection();
        Assert.assertEquals((long)0L, (long)selection.getOffset());
        Assert.assertEquals((long)len, (long)selection.getLength());
        textViewer.getTextWidget().setCaretOffset(1);
        selection = (ITextSelection)textViewer.getSelectionProvider().getSelection();
        Assert.assertEquals((long)1L, (long)selection.getOffset());
        Assert.assertEquals((long)0L, (long)selection.getLength());
    }

    @Test
    public void testGetCachedSelection() throws Exception {
        TextViewer textViewer = new TextViewer((Composite)this.fShell, 0);
        Document document = new Document("abc");
        textViewer.setDocument((IDocument)document);
        int len = document.getLength();
        textViewer.setSelectedRange(0, len);
        this.checkInAndOutUIThread(() -> {
            ITextSelection selection = textViewer.getLastKnownSelection();
            Assert.assertEquals((long)0L, (long)selection.getOffset());
            Assert.assertEquals((long)len, (long)selection.getLength());
        });
    }

    @Test
    public void testBlockSelectionAccessors() throws Exception {
        TextViewer textViewer = new TextViewer((Composite)this.fShell, 0);
        Document document = new Document("0123\n4567\n89ab\ncdef");
        textViewer.setDocument((IDocument)document);
        StyledText textWidget = textViewer.getTextWidget();
        textWidget.setBlockSelection(true);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fShell.open();
        textViewer.getSelectionProvider().setSelection((ISelection)new BlockTextSelection(textViewer.getDocument(), 1, 1, 2, 2, textWidget.getTabs()));
        BlockTextSelection sel = (BlockTextSelection)textViewer.getSelectionProvider().getSelection();
        Assert.assertEquals((long)1L, (long)sel.getStartLine());
        Assert.assertEquals((long)2L, (long)sel.getEndLine());
        Assert.assertEquals((long)1L, (long)sel.getStartColumn());
        Assert.assertEquals((long)2L, (long)sel.getEndColumn());
    }

    private void checkInAndOutUIThread(Runnable r) throws InterruptedException {
        r.run();
        Job job = Job.create((String)"Check in non-UI Thread", monitor -> {
            try {
                r.run();
                return Status.OK_STATUS;
            }
            catch (Throwable t) {
                return new Status(4, "org.eclipse.jface.text.tests", t.getMessage(), t);
            }
        });
        job.schedule();
        job.join();
        if (!job.getResult().isOK()) {
            Throwable ex = job.getResult().getException();
            if (ex != null) {
                throw new AssertionError("Assertion fail in non-UI Thread", ex);
            }
            Assert.fail((String)job.getResult().toString());
        }
    }

    @Test
    public void testCtrlHomeViewportListener() {
        Assume.assumeFalse((String)"See bug 541415. For whatever reason, this shortcut doesn't work on Mac", (boolean)Util.isMac());
        this.fShell.setLayout((Layout)new FillLayout());
        this.fShell.setSize(500, 200);
        SourceViewer textViewer = new SourceViewer((Composite)this.fShell, null, 0);
        textViewer.setDocument((IDocument)new Document(TextViewerTest.generate5000Lines()));
        this.fShell.open();
        textViewer.revealRange(4000, 1);
        final AtomicBoolean notifyHomeReached = new AtomicBoolean();
        TextViewerTest.ctrlEnd((ITextViewer)textViewer);
        DisplayHelper.sleep((Display)textViewer.getTextWidget().getDisplay(), (long)1000L);
        textViewer.addViewportListener(offset -> notifyHomeReached.set(offset == 0));
        TextViewerTest.ctrlHome((ITextViewer)textViewer);
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return notifyHomeReached.get();
            }
        }.waitForCondition(textViewer.getTextWidget().getDisplay(), 3000L));
    }

    @Test
    public void testCtrlEndViewportListener() {
        Assume.assumeFalse((String)"See bug 541415. For whatever reason, this shortcut doesn't work on Mac", (boolean)Util.isMac());
        this.fShell.setLayout((Layout)new FillLayout());
        this.fShell.setSize(500, 200);
        SourceViewer textViewer = new SourceViewer((Composite)this.fShell, null, 0);
        Document document = new Document(TextViewerTest.generate5000Lines());
        textViewer.setDocument((IDocument)document);
        this.fShell.open();
        final AtomicBoolean notifyEndReached = new AtomicBoolean();
        textViewer.addViewportListener(offset -> notifyEndReached.set(offset > 4000));
        TextViewerTest.ctrlEnd((ITextViewer)textViewer);
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return notifyEndReached.get();
            }
        }.waitForCondition(textViewer.getControl().getDisplay(), 3000L));
    }

    @Test
    public void testDefaultContentImplementation() {
        StyledTextContent content;
        try {
            TextViewer textViewer = new TextViewer((Composite)this.fShell, 0);
            textViewer.setDocument((IDocument)new Document());
            content = textViewer.getTextWidget().getContent();
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to obtain default instance of TextViewers document adapter. " + ex.getMessage()));
            return;
        }
        Assume.assumeNotNull((Object[])new Object[]{content});
        String line0 = "Hello ";
        String line1 = "";
        String line2 = "World!";
        String text = "Hello \n\r\nWorld!";
        content.setText("Hello \n\r\nWorld!");
        Assert.assertEquals((String)"Get text range failed.", (Object)"H", (Object)content.getTextRange(0, 1));
        Assert.assertEquals((String)"Get text range failed.", (Object)"ll", (Object)content.getTextRange(2, 2));
        Assert.assertEquals((String)"Adapter content length wrong.", (long)"Hello \n\r\nWorld!".length(), (long)content.getCharCount());
        Assert.assertEquals((String)"Adapter returned wrong content.", (Object)"Hello ", (Object)content.getLine(0));
        Assert.assertEquals((String)"Adapter returned wrong content.", (Object)"", (Object)content.getLine(1));
        Assert.assertEquals((String)"Adapter returned wrong content.", (Object)"World!", (Object)content.getLine(2));
        content.setText("\r\n\r\n");
        Assert.assertEquals((String)"Wrong line for offset.", (long)0L, (long)content.getLineAtOffset(0));
        Assert.assertEquals((String)"Wrong line for offset.", (long)0L, (long)content.getLineAtOffset(1));
        Assert.assertEquals((String)"Wrong line for offset.", (long)1L, (long)content.getLineAtOffset(2));
        Assert.assertEquals((String)"Wrong line for offset.", (long)1L, (long)content.getLineAtOffset(3));
        Assert.assertEquals((String)"Wrong line for offset.", (long)2L, (long)content.getLineAtOffset(4));
        Assert.assertEquals((String)"Wrong line for offset.", (long)(content.getLineCount() - 1), (long)content.getLineAtOffset(content.getCharCount()));
        content.setText(null);
        Assert.assertEquals((String)"Adapter returned wrong line count.", (long)1L, (long)content.getLineCount());
        content.setText("");
        Assert.assertEquals((String)"Adapter returned wrong line count.", (long)1L, (long)content.getLineCount());
        content.setText("a\n");
        Assert.assertEquals((String)"Adapter returned wrong line count.", (long)2L, (long)content.getLineCount());
        content.setText("\n\n");
        Assert.assertEquals((String)"Adapter returned wrong line count.", (long)3L, (long)content.getLineCount());
        content.setText("\r\ntest\r\n");
        Assert.assertEquals((String)"Wrong offset for line.", (long)0L, (long)content.getOffsetAtLine(0));
        Assert.assertEquals((String)"Wrong offset for line.", (long)2L, (long)content.getOffsetAtLine(1));
        Assert.assertEquals((String)"Wrong offset for line.", (long)8L, (long)content.getOffsetAtLine(2));
        content.setText("");
        Assert.assertEquals((String)"Wrong offset for line.", (long)0L, (long)content.getOffsetAtLine(0));
    }

    public static void ctrlEnd(ITextViewer viewer) {
        TextViewerTest.postKeyEvent((Control)viewer.getTextWidget(), 0x1000008, 262144, 1);
    }

    public static void ctrlHome(ITextViewer viewer) {
        TextViewerTest.postKeyEvent((Control)viewer.getTextWidget(), 0x1000007, 262144, 1);
    }

    static void postKeyEvent(Control widget, int keyCode, int stateMask, int type) {
        Listener[] listeners;
        Display display = widget.getDisplay();
        widget.setFocus();
        DisplayHelper.runEventLoop((Display)display, (long)0L);
        Event event = new Event();
        event.widget = widget;
        event.keyCode = keyCode;
        event.stateMask = stateMask;
        event.type = type;
        event.doit = true;
        Listener[] listenerArray = listeners = widget.getListeners(type);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
        DisplayHelper.runEventLoop((Display)display, (long)0L);
    }

    public static String generate5000Lines() {
        StringBuilder b = new StringBuilder("start");
        int i = 0;
        while (i < 5000) {
            b.append('\n');
            ++i;
        }
        b.append("end");
        return b.toString();
    }

    @Test
    public void testShiftLeft() {
        TextViewer textViewer = new TextViewer((Composite)this.fShell, 0);
        Document document = new Document("//line1\n//line2");
        textViewer.setDocumentPartitioning("__dftl_partitioning");
        textViewer.setDocument((IDocument)document);
        textViewer.setDefaultPrefixes(new String[]{"//"}, "__dftl_partition_content_type");
        textViewer.doOperation(7);
        textViewer.doOperation(12);
        Assert.assertEquals((Object)"line1\nline2", (Object)textViewer.getDocument().get());
        document = new Document("//line1\nline2");
        textViewer.setDocumentPartitioning("__dftl_partitioning");
        textViewer.setDocument((IDocument)document);
        textViewer.setDefaultPrefixes(new String[]{"//"}, "__dftl_partition_content_type");
        textViewer.doOperation(7);
        textViewer.doOperation(12);
        Assert.assertEquals((Object)"//line1\nline2", (Object)textViewer.getDocument().get());
        document = new Document("//line1\nline2");
        textViewer.setDocumentPartitioning("__dftl_partitioning");
        textViewer.setDocument((IDocument)document);
        textViewer.setDefaultPrefixes(new String[]{"//", ""}, "__dftl_partition_content_type");
        textViewer.doOperation(7);
        textViewer.doOperation(12);
        Assert.assertEquals((Object)"line1\nline2", (Object)textViewer.getDocument().get());
    }

    private String toString(Document document, IHyperlink[] links) {
        if (links == null) {
            return "[]";
        }
        return Arrays.stream(links).map(l -> {
            IRegion region = l.getHyperlinkRegion();
            try {
                String fromDocument = document.get(region.getOffset(), region.getLength());
                if (l instanceof URLHyperlink) {
                    Assert.assertEquals((Object)((URLHyperlink)l).getURLString(), (Object)fromDocument);
                }
                return fromDocument;
            }
            catch (BadLocationException e) {
                return "Invalid region <" + String.valueOf(region) + ">";
            }
        }).collect(Collectors.joining(",", "[", "]"));
    }

    private void checkHyperlink(TextViewer textViewer, int pos, String text, String expected) {
        Document document = new Document(text);
        textViewer.setDocumentPartitioning("__dftl_partitioning");
        textViewer.setDocument((IDocument)document);
        Region region = new Region(pos, 0);
        URLHyperlinkDetector detector = new URLHyperlinkDetector();
        IHyperlink[] hyperlinks = detector.detectHyperlinks((ITextViewer)textViewer, (IRegion)region, false);
        String found = this.toString(document, hyperlinks);
        Assert.assertEquals((Object)expected, (Object)found);
    }

    @Test
    public void testURLHyperlinkDetector() {
        TextViewer textViewer = new TextViewer((Composite)this.fShell, 0);
        this.checkHyperlink(textViewer, 3, "https://foo ", "[https://foo]");
        this.checkHyperlink(textViewer, 0, "", "[]");
        this.checkHyperlink(textViewer, 3, "https", "[]");
        this.checkHyperlink(textViewer, 3, "https://", "[]");
        this.checkHyperlink(textViewer, 3, "https:// ", "[]");
        this.checkHyperlink(textViewer, 3, "https:// foo", "[]");
        this.checkHyperlink(textViewer, 3, "https://foo bar", "[https://foo]");
        this.checkHyperlink(textViewer, 3, "\"https://\" foo bar", "[]");
        this.checkHyperlink(textViewer, 3, "\"https:// \" foo bar", "[]");
        this.checkHyperlink(textViewer, 3, "\"https:// foo\" bar", "[]");
        this.checkHyperlink(textViewer, 15, "https:// foo https://bar bar", "[https://bar]");
        this.checkHyperlink(textViewer, 24, "https:// foo https://bar bar", "[https://bar]");
        this.checkHyperlink(textViewer, 15, "<a href=\"test:https://bugs.eclipse.org/bugs\"></a>", "[https://bugs.eclipse.org/bugs]");
        this.checkHyperlink(textViewer, 19, "<a href=\"scm:git:https://bugs.eclipse.org/bugs\"></a>", "[https://bugs.eclipse.org/bugs]");
        this.checkHyperlink(textViewer, 40, "Find more information at https://www.eclipse.org.", "[https://www.eclipse.org]");
        this.checkHyperlink(textViewer, 3, "http://... links should not be used anymore; use https://... instead.", "[]");
        this.checkHyperlink(textViewer, 50, "http://... links should not be used anymore; use https://... instead.", "[]");
    }

    @Test
    public void testPasteMultiLines() {
        TextViewer textViewer = new TextViewer((Composite)this.fShell, 0);
        Document document = new Document();
        textViewer.setDocument((IDocument)document);
        new Clipboard(this.fShell.getDisplay()).setContents(new Object[]{"a" + System.lineSeparator() + "a"}, new Transfer[]{TextTransfer.getInstance()}, 1);
        textViewer.doOperation(5);
        Assert.assertEquals((Object)("a" + System.lineSeparator() + "a"), (Object)textViewer.getTextWidget().getText());
        document.set("a\na\na\nb");
        textViewer.setSelectedRange(0, 6);
        new Clipboard(this.fShell.getDisplay()).setContents(new Object[]{"b"}, new Transfer[]{TextTransfer.getInstance()}, 1);
        textViewer.doOperation(5);
        Assert.assertEquals((Object)"bb", (Object)textViewer.getTextWidget().getText());
    }

    @Test
    public void testSetSelectionNoDoc() {
        TextViewer textViewer = new TextViewer((Composite)this.fShell, 0);
        textViewer.setSelection((ISelection)TextSelection.emptySelection());
    }

    @Test
    public void testSelectionFromViewerState() {
        TextViewer textViewer = new TextViewer((Composite)this.fShell, 0);
        textViewer.setDocument((IDocument)new Document("/**\n *\n * HEADER\n */\npackage pack;\n\npublic final class C {\n    /** \n* javadoc\n     */\n    public void method() {\n/* a\ncomment */\nint local;\n    }\n}\n"));
        textViewer.setSelectedRange(118, 0);
        ITextSelection textSelection = (ITextSelection)textViewer.getSelection();
        Assert.assertEquals((long)118L, (long)textSelection.getOffset());
        textViewer.setRedraw(false);
        textViewer.setSelectedRange(113, 15);
        textSelection = (ITextSelection)textViewer.getSelection();
        Assert.assertEquals((long)113L, (long)textSelection.getOffset());
    }

    @Test
    public void testSurroundwithBracketsStrategy() {
        this.fShell = new Shell();
        SourceViewer sourceViewer = new SourceViewer((Composite)this.fShell, null, 0);
        sourceViewer.configure(new SourceViewerConfiguration());
        sourceViewer.setDocument((IDocument)new Document("Test sample to surround the selected text with brackets"));
        StyledText text = sourceViewer.getTextWidget();
        text.setText("Test sample to surround the selected text with brackets");
        text.setSelection(15, 23);
        Assert.assertEquals((long)23L, (long)text.getCaretOffset());
        Assert.assertEquals((Object)"surround", (Object)text.getSelectionText());
        text.insert("[");
        Assert.assertEquals((Object)"Test sample to [surround] the selected text with brackets", (Object)text.getText());
        Assert.assertEquals((long)24L, (long)text.getCaretOffset());
    }
}

