/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.codemining;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.eclipse.jface.internal.text.codemining.CodeMiningLineHeaderAnnotation;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.inlined.AbstractInlinedAnnotation;
import org.eclipse.jface.text.source.inlined.InlinedAnnotationSupport;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CodeMiningLineHeaderAnnotationTest {
    private SourceViewer fViewer;
    private Shell fShell;
    private Document document;

    @Before
    public void setUp() {
        this.fShell = new Shell(Display.getDefault());
        this.fShell.setSize(500, 200);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = new SourceViewer((Composite)this.fShell, null, 0);
        StyledText textWidget = this.fViewer.getTextWidget();
        this.document = new Document("a");
        textWidget.setText(this.document.get());
        this.fViewer.setDocument((IDocument)this.document, (IAnnotationModel)new AnnotationModel());
        Display display = textWidget.getDisplay();
        this.fShell.open();
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return CodeMiningLineHeaderAnnotationTest.this.fViewer.getTextWidget().isVisible();
            }
        }.waitForCondition(display, 3000L));
        DisplayHelper.sleep((Display)textWidget.getDisplay(), (long)1000L);
    }

    @After
    public void tearDown() {
        this.fViewer = null;
    }

    @Test
    public void testGetHeightDoesNotReturnZero() throws Exception {
        CodeMiningLineHeaderAnnotation cut = new CodeMiningLineHeaderAnnotation(new Position(0, 0), (ISourceViewer)this.fViewer);
        InlinedAnnotationSupport s = new InlinedAnnotationSupport();
        s.install((ISourceViewer)this.fViewer, new AnnotationPainter((ISourceViewer)this.fViewer, null));
        Method m = AbstractInlinedAnnotation.class.getDeclaredMethod("setSupport", InlinedAnnotationSupport.class);
        m.setAccessible(true);
        m.invoke((Object)cut, s);
        cut.update(Arrays.asList(new LineHeaderCodeMining(0, (IDocument)this.document, null){

            public String getLabel() {
                return "mining";
            }
        }), null);
        Assert.assertNotEquals((long)0L, (long)cut.getHeight());
    }
}

