/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.codemining;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.text.tests.codemining.DelayedEchoCodeMiningProvider;
import org.eclipse.jface.text.tests.codemining.StaticContentLineCodeMining;
import org.eclipse.jface.text.tests.contentassist.BarContentAssistProcessor;
import org.eclipse.jface.text.tests.source.inlined.LineContentBoundsDrawingTest;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class CodeMiningProjectionViewerTest {
    private Shell fParent;
    private ProjectionViewer fViewer;

    @Before
    public void setUp() {
        Shell[] shells;
        Shell[] shellArray = shells = Display.getDefault().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            shell.dispose();
            ++n2;
        }
        this.fParent = new Shell(16384);
        this.fParent.setSize(500, 200);
        this.fParent.setLayout((Layout)new FillLayout());
        this.fViewer = new ProjectionViewer((Composite)this.fParent, null, null, false, 0);
        LineContentBoundsDrawingTest.AccessAllAnnoations annotationAccess = new LineContentBoundsDrawingTest.AccessAllAnnoations();
        AnnotationPainter painter = new AnnotationPainter((ISourceViewer)this.fViewer, (IAnnotationAccess)annotationAccess);
        this.fViewer.addPainter((IPainter)painter);
        this.fViewer.setCodeMiningAnnotationPainter(painter);
        this.fViewer.setDocument((IDocument)new Document(), (IAnnotationModel)new ProjectionAnnotationModel());
        ProjectionSupport projectionSupport = new ProjectionSupport(this.fViewer, (IAnnotationAccess)annotationAccess, rgb -> null);
        projectionSupport.install();
        this.fViewer.doOperation(19);
    }

    @After
    public void tearDown() {
        this.fParent.dispose();
    }

    protected List<Shell> getCurrentShells() {
        return Arrays.stream(this.fParent.getDisplay().getShells()).filter(Shell::isVisible).toList();
    }

    protected List<Shell> findNewShells(Collection<Shell> beforeShells) {
        return Arrays.stream(this.fParent.getDisplay().getShells()).filter(Shell::isVisible).filter(shell -> !beforeShells.contains(shell)).toList();
    }

    protected Shell findNewShell(Collection<Shell> beforeShells) {
        DisplayHelper.sleep((Display)this.fParent.getDisplay(), (long)100L);
        List<Shell> afterShells = this.findNewShells(beforeShells);
        if (afterShells.isEmpty()) {
            DisplayHelper.sleep((Display)this.fParent.getDisplay(), (long)1000L);
        }
        afterShells = this.findNewShells(beforeShells);
        Assert.assertTrue((String)("No new shell found, existing: " + String.valueOf(beforeShells)), (afterShells.size() > beforeShells.size() ? 1 : 0) != 0);
        return afterShells.get(0);
    }

    @Test
    public void testCollapse() throws Exception {
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new RepeatLettersCodeMiningProvider()});
        this.fViewer.getDocument().set("1a\n2a\n3a\n4a\n5a\n6a\n");
        ProjectionAnnotation annotation = new ProjectionAnnotation(true);
        this.fViewer.getProjectionAnnotationModel().addAnnotation((Annotation)annotation, new Position(0, this.fViewer.getDocument().getLineOffset(4)));
        this.fViewer.doOperation(21);
        this.fViewer.updateCodeMinings();
        this.fParent.open();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.workbench");
        ILog log = null;
        AtomicReference logError = new AtomicReference();
        ILogListener logListener = (status, plugin) -> logError.set(status);
        if (bundle != null && bundle.getState() == 32) {
            log = ILog.of((Bundle)bundle);
            log.addLogListener(logListener);
        }
        try {
            DisplayHelper.sleep((Display)this.fParent.getDisplay(), (long)1000L);
            Assert.assertNull(logError.get());
        }
        finally {
            if (log != null) {
                log.removeLogListener(logListener);
            }
        }
    }

    @Test
    public void testCodeMiningDoesntAlterFocus() {
        this.fViewer.configure(new SourceViewerConfiguration(){

            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant contentAssistant = new ContentAssistant(true);
                contentAssistant.addContentAssistProcessor((IContentAssistProcessor)new BarContentAssistProcessor("1hi"), "__dftl_partition_content_type");
                contentAssistant.addContentAssistProcessor((IContentAssistProcessor)new BarContentAssistProcessor("1hello"), "__dftl_partition_content_type");
                contentAssistant.setShowEmptyList(true);
                return contentAssistant;
            }
        });
        final List<Shell> beforeShells = this.getCurrentShells();
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new DelayedEchoCodeMiningProvider()});
        this.fViewer.getDocument().set("1a\n2a\n3a\n4a\n5a\n6a\n");
        this.fParent.setSize(200, 4 * this.fViewer.getTextWidget().getLineHeight());
        this.fParent.open();
        DisplayHelper.runEventLoop((Display)this.fParent.getDisplay(), (long)0L);
        this.fViewer.getControl().notifyListeners(2, new Event());
        this.fViewer.setSelectedRange(1, 0);
        this.fViewer.doOperation(13);
        final Display display = this.fParent.getDisplay();
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return display.getShells().length > beforeShells.size();
            }
        }.waitForCondition(display, 1000L));
        Shell completionShell = this.findNewShell(beforeShells);
        this.fViewer.updateCodeMinings();
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return CodeMiningProjectionViewerTest.this.fViewer.getTextWidget().getLineVerticalIndent(0) > 0;
            }
        }.waitForCondition(display, 3000L));
        Event e = new Event();
        e.widget = this.fViewer.getTextWidget();
        e.keyCode = 0x1000002;
        this.fViewer.getTextWidget().notifyListeners(1, e);
        Assert.assertTrue((boolean)completionShell.isVisible());
    }

    private static final class RepeatLettersCodeMiningProvider
    implements ICodeMiningProvider {
        private RepeatLettersCodeMiningProvider() {
        }

        public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
            ArrayList<StaticContentLineCodeMining> codeMinings = new ArrayList<StaticContentLineCodeMining>();
            int i = 0;
            while (i < viewer.getDocument().getLength()) {
                try {
                    char c = viewer.getDocument().getChar(i);
                    if (Character.isLetter(c)) {
                        codeMinings.add(new StaticContentLineCodeMining(i, c, (ICodeMiningProvider)this));
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            return CompletableFuture.completedFuture(codeMinings);
        }

        public void dispose() {
        }
    }
}

