/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.codemining;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.DocumentFooterCodeMining;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.tests.TextViewerTest;
import org.eclipse.jface.text.tests.codemining.DelayedEchoCodeMiningProvider;
import org.eclipse.jface.text.tests.codemining.StaticContentLineCodeMining;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.test.Screenshots;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class CodeMiningTest {
    private SourceViewer fViewer;
    private Shell fShell;
    @Rule
    public TestWatcher screenshotRule = Screenshots.onFailure(() -> this.fShell);

    @Before
    public void setUp() {
        this.fShell = new Shell(Display.getDefault());
        this.fShell.setSize(500, 200);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = new SourceViewer((Composite)this.fShell, null, 0);
        StyledText textWidget = this.fViewer.getTextWidget();
        textWidget.setText("a");
        textWidget.setText("");
        MonoReconciler reconciler = new MonoReconciler(new IReconcilingStrategy(){

            public void setDocument(IDocument document) {
                CodeMiningTest.this.fViewer.updateCodeMinings();
            }

            public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
            }

            public void reconcile(IRegion partition) {
                CodeMiningTest.this.fViewer.updateCodeMinings();
            }
        }, false);
        reconciler.install((ITextViewer)this.fViewer);
        this.fViewer.setDocument((IDocument)new Document(), (IAnnotationModel)new AnnotationModel());
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new DelayedEchoCodeMiningProvider()});
        AnnotationPainter annotationPainter = new AnnotationPainter((ISourceViewer)this.fViewer, null);
        this.fViewer.setCodeMiningAnnotationPainter(annotationPainter);
        this.fViewer.addPainter((IPainter)annotationPainter);
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new DelayedEchoCodeMiningProvider()});
        Display display = textWidget.getDisplay();
        this.fShell.open();
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return CodeMiningTest.this.fViewer.getTextWidget().isVisible();
            }
        }.waitForCondition(display, 3000L));
        DisplayHelper.sleep((Display)textWidget.getDisplay(), (long)1000L);
    }

    @After
    public void tearDown() {
        this.fViewer = null;
    }

    @Test
    public void testCodeMiningFirstLine() {
        this.fViewer.getDocument().set("echo");
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return CodeMiningTest.this.fViewer.getTextWidget().getLineVerticalIndent(0) > 0;
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L));
    }

    @Test
    public void testCodeMiningCompletableFutureReturnsNull() {
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new AbstractCodeMiningProvider(){

            public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
                return CompletableFuture.supplyAsync(() -> null);
            }
        }, new DelayedEchoCodeMiningProvider()});
        this.fViewer.getDocument().set("echo");
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return CodeMiningTest.this.fViewer.getTextWidget().getLineVerticalIndent(0) > 0;
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L));
    }

    @Test
    public void testCodeMiningCtrlHome() throws BadLocationException {
        Assume.assumeFalse((String)"See bug 541415. For whatever reason, this shortcut doesn't work on Mac", (boolean)Util.isMac());
        DelayedEchoCodeMiningProvider.DELAY = 500;
        this.fViewer.getDocument().set(TextViewerTest.generate5000Lines());
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return CodeMiningTest.this.fViewer.getTextWidget().getText().length() > 5000;
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L));
        TextViewerTest.ctrlEnd((ITextViewer)this.fViewer);
        int lastLine = this.fViewer.getDocument().getNumberOfLines() - 1;
        final int lastLineOffset = this.fViewer.getDocument().getLineOffset(lastLine);
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return lastLineOffset >= CodeMiningTest.this.fViewer.getVisibleRegion().getOffset() && lastLineOffset <= CodeMiningTest.this.fViewer.getVisibleRegion().getOffset() + CodeMiningTest.this.fViewer.getVisibleRegion().getLength();
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L));
        DisplayHelper.sleep((Display)this.fViewer.getControl().getDisplay(), (long)500L);
        final AtomicInteger events = new AtomicInteger();
        this.fViewer.addViewportListener(offset -> {
            int n = events.incrementAndGet();
        });
        TextViewerTest.ctrlHome((ITextViewer)this.fViewer);
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return events.get() > 0;
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L));
        Assert.assertEquals((long)0L, (long)this.fViewer.getVisibleRegion().getOffset());
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return CodeMiningTest.this.fViewer.getTextWidget().getLineVerticalIndent(0) > 0;
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 300000L));
    }

    @Test
    public void testCodeMiningCtrlEnd() throws BadLocationException {
        Assume.assumeFalse((String)"See bug 541415. For whatever reason, this shortcut doesn't work on Mac", (boolean)Util.isMac());
        this.fViewer.getDocument().set(TextViewerTest.generate5000Lines());
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return CodeMiningTest.this.fViewer.getTextWidget().getText().length() > 5000 && CodeMiningTest.this.fViewer.getTextWidget().getLineVerticalIndent(0) > 0;
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L));
        DisplayHelper.sleep((Display)this.fViewer.getTextWidget().getDisplay(), (long)500L);
        TextViewerTest.ctrlEnd((ITextViewer)this.fViewer);
        final int lastLine = this.fViewer.getDocument().getNumberOfLines() - 1;
        final int lastLineOffset = this.fViewer.getDocument().getLineOffset(lastLine);
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return lastLineOffset >= CodeMiningTest.this.fViewer.getVisibleRegion().getOffset() && lastLineOffset <= CodeMiningTest.this.fViewer.getVisibleRegion().getOffset() + CodeMiningTest.this.fViewer.getVisibleRegion().getLength();
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L));
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return CodeMiningTest.this.fViewer.getTextWidget().getLineVerticalIndent(lastLine) > 0;
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L));
    }

    @Test
    public void testCodeMiningEmptyLine() {
        this.fViewer.getDocument().set("\n");
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new ICodeMiningProvider(){

            public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
                return CompletableFuture.completedFuture(Collections.singletonList(new StaticContentLineCodeMining(new Position(0, 1), "mining", (ICodeMiningProvider)this)));
            }

            public void dispose() {
            }
        }});
        final StyledText widget = this.fViewer.getTextWidget();
        Assert.assertTrue((String)"Code mining is not visible in 1st empty line after line break character", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    StyleRange range = widget.getStyleRangeAtOffset(0);
                    return range == null && CodeMiningTest.hasCodeMiningPrintedAfterTextOnLine((ITextViewer)CodeMiningTest.this.fViewer, 0);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(this.fViewer.getTextWidget().getDisplay(), 1000L));
    }

    @Test
    public void testLineHeaderCodeMiningAtEndOfDocumentWithEmptyLine() throws Exception {
        final String source = "first\nsecond\n";
        this.fViewer.getDocument().set(source);
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new ICodeMiningProvider(){

            public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
                ArrayList<1> minings = new ArrayList<1>();
                try {
                    minings.add(new LineHeaderCodeMining(new Position(source.length(), 0), this, null){

                        public String getLabel() {
                            return "multiline first line\nmultiline second line\nmultiline third line\nmultiline fourth line";
                        }
                    });
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                return CompletableFuture.completedFuture(minings);
            }

            public void dispose() {
            }
        }});
        Assert.assertTrue((String)"Code mining is not visible at end of document", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return CodeMiningTest.hasCodeMiningPrintedAfterTextOnLine((ITextViewer)CodeMiningTest.this.fViewer, 2);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(this.fViewer.getTextWidget().getDisplay(), 10000L));
    }

    @Test
    public void testDocumentFooterCodeMining() throws Exception {
        String source = "first\nsecond";
        this.fViewer.getDocument().set(source);
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new ICodeMiningProvider(){

            public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
                ArrayList<1> minings = new ArrayList<1>();
                minings.add(new DocumentFooterCodeMining(viewer.getDocument(), this, null){

                    public String getLabel() {
                        return "multiline first line\nmultiline second line";
                    }
                });
                return CompletableFuture.completedFuture(minings);
            }

            public void dispose() {
            }
        }});
        Assert.assertTrue((String)"Code mining is not visible at end of document", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    boolean res = CodeMiningTest.hasCodeMiningPrintedBelowLine((ITextViewer)CodeMiningTest.this.fViewer, 1);
                    if (!res) {
                        CodeMiningTest.this.fViewer.getTextWidget().redraw();
                    }
                    return res;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(this.fViewer.getTextWidget().getDisplay(), 10000L));
    }

    @Test
    public void testDocumentFooterCodeMiningEmptyDocument() throws Exception {
        String source = "";
        this.fViewer.getDocument().set(source);
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new ICodeMiningProvider(){

            public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
                ArrayList<1> minings = new ArrayList<1>();
                minings.add(new DocumentFooterCodeMining(viewer.getDocument(), this, null){

                    public String getLabel() {
                        return "multiline first line\nmultiline second line";
                    }
                });
                return CompletableFuture.completedFuture(minings);
            }

            public void dispose() {
            }
        }});
        Assert.assertTrue((String)"Code mining is not visible at end of document", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    boolean res = CodeMiningTest.hasCodeMiningPrintedBelowLine((ITextViewer)CodeMiningTest.this.fViewer, 0);
                    if (!res) {
                        CodeMiningTest.this.fViewer.getTextWidget().redraw();
                    }
                    return res;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(this.fViewer.getTextWidget().getDisplay(), 10000L));
    }

    @Test
    public void testCodeMiningAtEndOfDocumentWithEmptyLine() throws Exception {
        final String source = "first\nsecond\n";
        this.fViewer.getDocument().set(source);
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new ICodeMiningProvider(){

            public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
                return CompletableFuture.completedFuture(Collections.singletonList(new StaticContentLineCodeMining(new Position(source.length(), 0), true, "mining", this)));
            }

            public void dispose() {
            }
        }});
        Assert.assertTrue((String)"Code mining is not visible at end of document", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return CodeMiningTest.hasCodeMiningPrintedAfterTextOnLine((ITextViewer)CodeMiningTest.this.fViewer, 2);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(this.fViewer.getTextWidget().getDisplay(), 10000L));
    }

    @Test
    public void testCodeMiningEndOfLine() {
        this.fViewer.getDocument().set("a\n");
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new ICodeMiningProvider(){

            public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
                return CompletableFuture.completedFuture(Collections.singletonList(new StaticContentLineCodeMining(new Position(1, 1), "mining", (ICodeMiningProvider)this)));
            }

            public void dispose() {
            }
        }});
        final StyledText widget = this.fViewer.getTextWidget();
        Assert.assertTrue((String)"Code mining is not visible in 1st line after character a before line break character", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    StyleRange range = widget.getStyleRangeAtOffset(0);
                    return range != null && range.metrics != null && !CodeMiningTest.hasCodeMiningPrintedAfterTextOnLine((ITextViewer)CodeMiningTest.this.fViewer, 0);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(this.fViewer.getTextWidget().getDisplay(), 1000L));
    }

    @Test
    public void testCodeMiningMultiLine() {
        this.fViewer.getDocument().set("a\nbc");
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new ICodeMiningProvider(){

            public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
                return CompletableFuture.completedFuture(Collections.singletonList(new StaticContentLineCodeMining(new Position(0, 3), "long enough code mining to be wider than actual text", (ICodeMiningProvider)this)));
            }

            public void dispose() {
            }
        }});
        final StyledText widget = this.fViewer.getTextWidget();
        Assert.assertFalse((String)"Code mining is visible on 2nd line", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return widget.getStyleRangeAtOffset(0) != null && widget.getStyleRangeAtOffset((int)0).metrics != null && CodeMiningTest.hasCodeMiningPrintedAfterTextOnLine((ITextViewer)CodeMiningTest.this.fViewer, 1);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return true;
                }
            }
        }.waitForCondition(this.fViewer.getTextWidget().getDisplay(), 1000L));
    }

    @Test
    public void testMultiLineHeaderCodeMining() {
        this.fViewer.getDocument().set("a\nb\n");
        this.fViewer.setCodeMiningProviders(new ICodeMiningProvider[]{new ICodeMiningProvider(){

            public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
                try {
                    ArrayList<Object> minings = new ArrayList<Object>();
                    minings.add((Object)new StaticContentLineCodeMining(new Position(1, 1), "mining", (ICodeMiningProvider)this));
                    minings.add(new LineHeaderCodeMining(1, CodeMiningTest.this.fViewer.getDocument(), this){

                        public String getLabel() {
                            return "multiline first line\nmultiline second line\nmultiline third line\nmultiline fourth line";
                        }
                    });
                    return CompletableFuture.completedFuture(minings);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public void dispose() {
            }
        }});
        final StyledText widget = this.fViewer.getTextWidget();
        Assert.assertFalse((String)"Code mining is unexpectedly rendered below last line", (boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return widget.getStyleRangeAtOffset(0) != null && widget.getStyleRangeAtOffset((int)0).metrics != null && CodeMiningTest.hasCodeMiningPrintedBelowLine((ITextViewer)CodeMiningTest.this.fViewer, 1);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(widget.getDisplay(), 1000L));
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasCodeMiningPrintedBelowLine(ITextViewer viewer, int line) throws BadLocationException {
        int starty;
        int startx;
        int lineOffset;
        int lineLength;
        StyledText widget = viewer.getTextWidget();
        IDocument document = viewer.getDocument();
        String delim = document.getLineDelimiter(line);
        int delimLen = 0;
        if (delim != null) {
            delimLen = delim.length();
        }
        if ((lineLength = document.getLineLength(line) - delimLen) < 0) {
            lineLength = 0;
        }
        if ((lineOffset = document.getLineOffset(line)) + lineLength >= widget.getCharCount()) {
            Point loc = widget.getLocationAtOffset(lineOffset);
            startx = loc.x;
            starty = loc.y + widget.getLineHeight(lineOffset);
        } else {
            Rectangle lineBounds = widget.getTextBounds(lineOffset, lineOffset + lineLength);
            lineBounds.y += lineBounds.height;
            startx = lineBounds.x;
            starty = lineBounds.y;
        }
        Image image = new Image((Device)widget.getDisplay(), (gc, width, height) -> {}, widget.getSize().x, widget.getSize().y);
        try {
            block13: {
                int x;
                ImageData imageData;
                block12: {
                    GC gc2 = new GC((Drawable)widget);
                    gc2.copyArea(image, 0, 0);
                    gc2.dispose();
                    imageData = image.getImageData();
                    x = startx + 1;
                    if (!true) break block12;
                    if (x >= image.getBounds().width) return false;
                    if (x >= imageData.width) break block13;
                }
                do {
                    int y = starty;
                    while (y < imageData.height - 10) {
                        if (!imageData.palette.getRGB(imageData.getPixel(x, y)).equals((Object)widget.getBackground().getRGB())) {
                            return true;
                        }
                        ++y;
                    }
                    ++x;
                    if (x >= image.getBounds().width) return false;
                } while (x < imageData.width);
            }
            return false;
        }
        finally {
            image.dispose();
        }
    }

    private static boolean hasCodeMiningPrintedAfterTextOnLine(ITextViewer viewer, int line) throws BadLocationException {
        StyledText widget = viewer.getTextWidget();
        IDocument document = viewer.getDocument();
        int lineLength = document.getLineLength(line) - 1;
        if (lineLength < 0) {
            lineLength = 0;
        }
        Rectangle secondLineBounds = null;
        int lineOffset = document.getLineOffset(line);
        if (lineOffset >= document.getLength()) {
            int off = document.getLength() - 1;
            secondLineBounds = widget.getTextBounds(off, off + lineLength);
            Point l = widget.getLocationAtOffset(lineOffset);
            int lineVerticalIndent = widget.getLineVerticalIndent(line);
            secondLineBounds.x = l.x;
            secondLineBounds.y = l.y - lineVerticalIndent;
        } else {
            secondLineBounds = widget.getTextBounds(lineOffset, lineOffset + lineLength);
        }
        Image image = new Image((Device)widget.getDisplay(), (gc, width, height) -> {}, widget.getSize().x, widget.getSize().y);
        GC gc2 = new GC((Drawable)widget);
        gc2.copyArea(image, 0, 0);
        gc2.dispose();
        ImageData imageData = image.getImageData();
        secondLineBounds.x += secondLineBounds.width;
        int x = secondLineBounds.x + 1;
        while (x < image.getBounds().width && x < imageData.width) {
            int y = secondLineBounds.y;
            while (y < secondLineBounds.y + secondLineBounds.height && y < imageData.height) {
                if (!imageData.palette.getRGB(imageData.getPixel(x, y)).equals((Object)widget.getBackground().getRGB())) {
                    image.dispose();
                    return true;
                }
                ++y;
            }
            ++x;
        }
        image.dispose();
        return false;
    }
}

