/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.codemining;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;

public class DelayedEchoCodeMiningProvider
extends AbstractCodeMiningProvider {
    public static int DELAY = 0;

    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Thread.sleep(DELAY);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                return null;
            }
            IDocument document = viewer.getDocument();
            ArrayList<3> res = new ArrayList<3>();
            int lineNumber = 0;
            while (lineNumber < document.getNumberOfLines()) {
                try {
                    String lineContent = document.get(document.getLineOffset(lineNumber), document.getLineLength(lineNumber));
                    if (!lineContent.trim().isEmpty()) {
                        LineHeaderCodeMining mining = new LineHeaderCodeMining(lineNumber, document, (ICodeMiningProvider)this){};
                        mining.setLabel(lineContent);
                        res.add(mining);
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                ++lineNumber;
            }
            return res;
        });
    }
}

