/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.contentassist;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class AbstractContentAssistTest {
    private Shell shell;
    private SourceViewer viewer;
    private ContentAssistant assistant;
    private Document document;
    private Button button;

    @Before
    public void setUp() {
        Shell[] shells;
        Shell[] shellArray = shells = Display.getDefault().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell s = shellArray[n2];
            s.dispose();
            ++n2;
        }
        DisplayHelper.runEventLoop((Display)Display.getDefault(), (long)0L);
    }

    @After
    public void close() {
        Shell[] shells;
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
        }
        Shell[] shellArray = shells = Display.getDefault().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell s = shellArray[n2];
            s.dispose();
            ++n2;
        }
    }

    protected void setupSourceViewer(ContentAssistant contentAssistant, String initialText) {
        this.shell = new Shell();
        this.shell.setSize(500, 280);
        this.shell.setLayout((Layout)new GridLayout());
        this.viewer = new SourceViewer((Composite)this.shell, null, 0);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.assistant = contentAssistant;
        this.viewer.configure(this.createSourceViewerConfiguration());
        this.document = new Document();
        if (initialText != null) {
            this.document.set(initialText);
        }
        this.viewer.setDocument((IDocument)this.document);
        this.button = new Button((Composite)this.shell, 8);
        this.button.setLayoutData((Object)new GridData(4, 4, true, false));
        this.shell.open();
        AbstractContentAssistTest.processEvents();
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return AbstractContentAssistTest.this.viewer.getTextWidget().isVisible();
            }
        }.waitForCondition(AbstractContentAssistTest.getDisplay(), 3000L));
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        return new SourceViewerConfiguration(){

            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                return AbstractContentAssistTest.this.getContentAssistant();
            }
        };
    }

    protected SourceViewer getSourceViewer() {
        return this.viewer;
    }

    protected Document getDocument() {
        return this.document;
    }

    protected ContentAssistant getContentAssistant() {
        return this.assistant;
    }

    protected void selectAndReveal(int selectionStart, int selectionLength) {
        StyledText widget = this.viewer.getTextWidget();
        widget.setRedraw(false);
        this.viewer.revealRange(selectionStart, selectionLength);
        this.viewer.setSelectedRange(selectionStart, selectionLength);
        widget.setRedraw(true);
    }

    protected void postSourceViewerKeyEvent(int keyCode, int stateMask, int type) {
        AbstractContentAssistTest.processEvents();
        Event event = new Event();
        event.type = type;
        event.widget = this.viewer.getTextWidget();
        event.display = this.viewer.getTextWidget().getDisplay();
        event.keyCode = keyCode;
        event.stateMask = stateMask;
        event.doit = true;
        this.viewer.getTextWidget().notifyListeners(type, event);
        AbstractContentAssistTest.processEvents();
    }

    protected void postSourceViewerKeyEvent(char character, int stateMask, int type) {
        AbstractContentAssistTest.processEvents();
        Event event = new Event();
        event.type = type;
        event.widget = this.viewer.getTextWidget();
        event.display = this.viewer.getTextWidget().getDisplay();
        event.character = character;
        event.stateMask = stateMask;
        event.doit = true;
        this.viewer.getTextWidget().notifyListeners(type, event);
        AbstractContentAssistTest.processEvents();
    }

    protected void emulatePressArrowKey(int keyCode) {
        switch (keyCode) {
            case 0x1000003: {
                this.viewer.getTextWidget().invokeAction(0x1000003);
                break;
            }
            case 0x1000004: {
                this.viewer.getTextWidget().invokeAction(0x1000004);
                break;
            }
            case 0x1000001: {
                this.viewer.getTextWidget().invokeAction(0x1000001);
                break;
            }
            case 0x1000002: {
                this.viewer.getTextWidget().invokeAction(0x1000002);
            }
        }
        this.postSourceViewerKeyEvent(keyCode, 0, 3005);
    }

    protected void emulatePressEscKey() {
        this.postSourceViewerKeyEvent('\u001b', 0, 3005);
    }

    protected void runTextOperation(int operation) {
        ITextOperationTarget textOperationTarget = this.viewer.getTextOperationTarget();
        Assert.assertTrue((boolean)textOperationTarget.canDoOperation(operation));
        textOperationTarget.doOperation(operation);
    }

    protected void triggerContextInformation() {
        this.runTextOperation(14);
    }

    public Button getButton() {
        return this.button;
    }

    protected static void processEvents() {
        DisplayHelper.runEventLoop((Display)AbstractContentAssistTest.getDisplay(), (long)0L);
    }

    private static Display getDisplay() {
        return Display.getDefault();
    }

    protected static List<Shell> getCurrentShells() {
        return Arrays.stream(AbstractContentAssistTest.getDisplay().getShells()).filter(Shell::isVisible).toList();
    }

    protected static List<Shell> findNewShells(Collection<Shell> beforeShells) {
        return Arrays.stream(AbstractContentAssistTest.getDisplay().getShells()).filter(Shell::isVisible).filter(s -> !beforeShells.contains(s)).toList();
    }

    protected static Shell findNewShell(Collection<Shell> beforeShells) {
        List<Shell> afterShells = AbstractContentAssistTest.findNewShells(beforeShells);
        int attempt = 0;
        while (afterShells.size() != 1 && attempt < 10) {
            DisplayHelper.sleep((Display)AbstractContentAssistTest.getDisplay(), (long)100L);
            afterShells = AbstractContentAssistTest.findNewShells(beforeShells);
            ++attempt;
        }
        Assert.assertEquals((String)"Not unique new shell found", (long)1L, (long)afterShells.size());
        return afterShells.get(0);
    }
}

