/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.contentassist;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.tests.contentassist.AbstractContentAssistTest;
import org.eclipse.jface.text.tests.contentassist.BarContentAssistProcessor;
import org.eclipse.jface.text.tests.contentassist.DelayedErrorContentAssistProcessor;
import org.eclipse.jface.text.tests.contentassist.ImmediateContentAssistProcessor;
import org.eclipse.jface.text.tests.contentassist.ImmediateNullContentAssistProcessor;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class AsyncContentAssistTest {
    private ILogListener listener;
    private IStatus errorStatus;
    private Shell shell;

    @Before
    public void setUp() {
        this.shell = new Shell();
        this.listener = (status, plugin) -> {
            if (status.getSeverity() == 4 && "org.eclipse.jface.text".equals(status.getPlugin())) {
                this.errorStatus = status;
            }
        };
        Platform.addLogListener((ILogListener)this.listener);
    }

    @After
    public void tearDown() {
        this.shell.dispose();
        Platform.removeLogListener((ILogListener)this.listener);
    }

    @Test
    public void testAsyncFailureStackOverflow() {
        SourceViewer viewer = new SourceViewer((Composite)this.shell, null, 0);
        Document document = new Document("a");
        viewer.setDocument((IDocument)document);
        ContentAssistant contentAssistant = new ContentAssistant(true);
        contentAssistant.addContentAssistProcessor((IContentAssistProcessor)new DelayedErrorContentAssistProcessor(), "__dftl_partition_content_type");
        contentAssistant.addContentAssistProcessor((IContentAssistProcessor)new ImmediateContentAssistProcessor(), "__dftl_partition_content_type");
        contentAssistant.install((ITextViewer)viewer);
        contentAssistant.showPossibleCompletions();
        document.set("ab");
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)2000L);
        Assert.assertNotNull((Object)this.errorStatus);
    }

    @Test
    public void testSyncFailureNPE() {
        SourceViewer viewer = new SourceViewer((Composite)this.shell, null, 0);
        Document document = new Document("a");
        viewer.setDocument((IDocument)document);
        ContentAssistant contentAssistant = new ContentAssistant(true);
        contentAssistant.addContentAssistProcessor((IContentAssistProcessor)new ImmediateContentAssistProcessor(), "__dftl_partition_content_type");
        contentAssistant.addContentAssistProcessor((IContentAssistProcessor)new ImmediateNullContentAssistProcessor(), "__dftl_partition_content_type");
        contentAssistant.install((ITextViewer)viewer);
        contentAssistant.showPossibleCompletions();
        document.set("ab");
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)1000L);
        Assert.assertNull((Object)this.errorStatus);
    }

    @Test
    public void testCompletePrefix() {
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setSize(500, 300);
        SourceViewer viewer = new SourceViewer((Composite)this.shell, null, 0);
        final Document document = new Document("b");
        viewer.setDocument((IDocument)document);
        viewer.setSelectedRange(1, 0);
        ContentAssistant contentAssistant = new ContentAssistant(true);
        contentAssistant.addContentAssistProcessor((IContentAssistProcessor)new BarContentAssistProcessor(), "__dftl_partition_content_type");
        contentAssistant.enablePrefixCompletion(true);
        contentAssistant.install((ITextViewer)viewer);
        this.shell.open();
        DisplayHelper.runEventLoop((Display)this.shell.getDisplay(), (long)0L);
        Display display = this.shell.getDisplay();
        List<Shell> beforeShells = AbstractContentAssistTest.getCurrentShells();
        contentAssistant.showPossibleCompletions();
        final Shell newShell = AbstractContentAssistTest.findNewShell(beforeShells);
        Assert.assertTrue((String)"Completion item not shown", (boolean)new DisplayHelper(){

            protected boolean condition() {
                Table completionTable = AsyncContentAssistTest.findCompletionSelectionControl((Widget)newShell);
                return Arrays.stream(completionTable.getItems()).map(TableItem::getText).anyMatch(item -> item.contains("bars are good for a beer.".substring(document.getLength())));
            }
        }.waitForCondition(display, 2000L));
    }

    @Test
    public void testCompleteActivationChar() {
        Assume.assumeFalse((String)"test fails on Windows, see https://github.com/eclipse-platform/eclipse.platform.ui/issues/890", (boolean)Util.isWindows());
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setSize(500, 300);
        SourceViewer viewer = new SourceViewer((Composite)this.shell, null, 0);
        final Document document = new Document("something");
        viewer.setDocument((IDocument)document);
        viewer.setSelectedRange(1, 0);
        ContentAssistant contentAssistant = new ContentAssistant(true);
        BarContentAssistProcessor processor = new BarContentAssistProcessor();
        processor.setCompletionProposalAutoActivationChar('b');
        contentAssistant.addContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssistant.enablePrefixCompletion(true);
        contentAssistant.enableAutoActivation(true);
        contentAssistant.setAutoActivationDelay(0);
        contentAssistant.install((ITextViewer)viewer);
        this.shell.open();
        Display display = this.shell.getDisplay();
        Event keyEvent = new Event();
        StyledText control = viewer.getTextWidget();
        keyEvent.widget = control;
        keyEvent.type = 1;
        keyEvent.character = (char)98;
        keyEvent.keyCode = 98;
        control.getShell().forceActive();
        control.getDisplay().post(keyEvent);
        keyEvent.type = 2;
        control.getDisplay().post(keyEvent);
        List<Shell> beforeShells = AbstractContentAssistTest.getCurrentShells();
        AbstractContentAssistTest.processEvents();
        final Shell newShell = AbstractContentAssistTest.findNewShell(beforeShells);
        Assert.assertTrue((String)"Completion item not shown", (boolean)new DisplayHelper(){

            protected boolean condition() {
                Table completionTable = AsyncContentAssistTest.findCompletionSelectionControl((Widget)newShell);
                return Arrays.stream(completionTable.getItems()).map(TableItem::getText).anyMatch(item -> item.contains("bars are good for a beer.".substring(document.getLength())));
            }
        }.waitForCondition(display, 4000L));
    }

    private static Table findCompletionSelectionControl(Widget control) {
        if (control instanceof Table) {
            return (Table)control;
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Table res = AsyncContentAssistTest.findCompletionSelectionControl((Widget)child);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
        }
        return null;
    }
}

