/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.contentassist;

import java.util.Arrays;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessorExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class BarContentAssistProcessor
implements IContentAssistProcessorExtension {
    public static final String PROPOSAL = "bars are good for a beer.";
    private final String completeString;
    private char activationChar;

    public BarContentAssistProcessor() {
        this(PROPOSAL);
    }

    public BarContentAssistProcessor(String completeString) {
        this.completeString = completeString;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        int offsetInProposal = Math.min(this.completeString.length(), viewer.getDocument().getLength());
        while (offsetInProposal > 0) {
            String maybeMatchingString = this.completeString.substring(0, offsetInProposal);
            try {
                int lastIndex = offset - offsetInProposal + this.completeString.length();
                if (offset >= offsetInProposal && viewer.getDocument().get(offset - offsetInProposal, maybeMatchingString.length()).equals(maybeMatchingString)) {
                    CompletionProposal proposal = new CompletionProposal(this.completeString.substring(offsetInProposal), offset, 0, lastIndex);
                    return new ICompletionProposal[]{proposal};
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            --offsetInProposal;
        }
        return new ICompletionProposal[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        try {
            IDocument document = viewer.getDocument();
            int wordBegin = offset;
            while (wordBegin > 0 && Character.isLetterOrDigit(document.getChar(wordBegin - 1))) {
                --wordBegin;
            }
            if (wordBegin < offset) {
                String word = document.get(wordBegin, offset - wordBegin);
                int wordIdx = Arrays.asList(this.completeString.split("\\W")).indexOf(word);
                if (wordIdx >= 0) {
                    return new IContextInformation[]{new BarContextInformation(word, "idx= " + wordIdx, wordBegin)};
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator();
    }

    public String getErrorMessage() {
        return null;
    }

    public boolean isCompletionProposalAutoActivation(char c, ITextViewer viewer, int offset) {
        return this.activationChar == c;
    }

    public boolean isContextInformationAutoActivation(char c, ITextViewer viewer, int offset) {
        return false;
    }

    public void setCompletionProposalAutoActivationChar(char c) {
        this.activationChar = c;
    }

    protected static class BarContextInformation
    implements IContextInformation,
    IContextInformationExtension {
        private final String contextDisplayString;
        private final String informationDisplayString;
        private final int offset;

        public BarContextInformation(String contextDisplayString, String informationDisplayString, int offset) {
            this.contextDisplayString = contextDisplayString;
            this.informationDisplayString = informationDisplayString;
            this.offset = offset;
        }

        public String getContextDisplayString() {
            return this.contextDisplayString;
        }

        public Image getImage() {
            return null;
        }

        public String getInformationDisplayString() {
            return this.informationDisplayString;
        }

        public int getContextInformationPosition() {
            return this.offset;
        }
    }

    protected static class ContextInformationValidator
    implements IContextInformationValidator {
        protected BarContextInformation contextInfo;
        protected ITextViewer textViewer;
        protected int textOffset;

        protected ContextInformationValidator() {
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            if (info instanceof BarContextInformation) {
                this.contextInfo = (BarContextInformation)info;
            }
            this.textViewer = viewer;
            this.textOffset = offset;
        }

        public boolean isContextInformationValid(int offset) {
            if (this.contextInfo == null) {
                return false;
            }
            try {
                IDocument document = this.textViewer.getDocument();
                IRegion line = document.getLineInformationOfOffset(this.textOffset);
                int end = line.getOffset() + line.getLength();
                return offset >= this.textOffset && offset < end;
            }
            catch (BadLocationException e) {
                return false;
            }
        }
    }
}

