/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.contentassist;

import java.util.List;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.tests.contentassist.AbstractContentAssistTest;
import org.eclipse.jface.text.tests.contentassist.BarContentAssistProcessor;
import org.eclipse.jface.text.tests.contentassist.ContextInformationTest;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.junit.Assert;
import org.junit.Test;

public class ContextInformationPresenterTest
extends AbstractContentAssistTest {
    private Shell infoShell;

    private ContentAssistant createBarContentAssist() {
        ContentAssistant contentAssistant = new ContentAssistant();
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new BarContentAssistProcessor(){

            @Override
            public IContextInformationValidator getContextInformationValidator() {
                return new ValidatorWithPresenter();
            }
        }, "__dftl_partition_content_type");
        return contentAssistant;
    }

    @Test
    public void testContextInfo_withStyledTextPresentation() throws Exception {
        this.setupSourceViewer(this.createBarContentAssist(), "bars are good for a beer.");
        this.postSourceViewerKeyEvent(0x1000004, 0, 1);
        this.selectAndReveal(4, 0);
        ContextInformationPresenterTest.processEvents();
        List<Shell> beforeShells = ContextInformationPresenterTest.getCurrentShells();
        this.triggerContextInformation();
        this.infoShell = ContextInformationPresenterTest.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 0", (Object)ContextInformationTest.getInfoText(this.infoShell));
        Assert.assertArrayEquals((Object[])new StyleRange[]{new StyleRange(0, 3, null, null, 1)}, (Object[])ContextInformationPresenterTest.getInfoStyleRanges(this.infoShell));
        this.emulatePressArrowKey(0x1000004);
        Assert.assertEquals((Object)"idx= 0", (Object)ContextInformationTest.getInfoText(this.infoShell));
        Assert.assertArrayEquals((Object[])new StyleRange[0], (Object[])ContextInformationPresenterTest.getInfoStyleRanges(this.infoShell));
    }

    static StyleRange[] getInfoStyleRanges(Shell shell) {
        Control[] children;
        Assert.assertTrue((boolean)shell.isVisible());
        Control[] controlArray = children = shell.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Text) {
                return null;
            }
            if (child instanceof StyledText) {
                return ((StyledText)child).getStyleRanges();
            }
            ++n2;
        }
        return null;
    }

    private static class ValidatorWithPresenter
    extends BarContentAssistProcessor.ContextInformationValidator
    implements IContextInformationPresenter {
        private boolean isStyled;

        private ValidatorWithPresenter() {
        }

        public boolean updatePresentation(int offset, TextPresentation presentation) {
            boolean style;
            if (this.contextInfo == null) {
                return false;
            }
            int begin = this.contextInfo.getContextInformationPosition();
            int end = begin + this.contextInfo.getContextDisplayString().length();
            boolean bl = style = offset >= begin && offset <= end;
            if (style == this.isStyled) {
                return false;
            }
            if (style) {
                presentation.clear();
                presentation.addStyleRange(new StyleRange(0, 3, null, null, 1));
            } else {
                presentation.clear();
            }
            this.isStyled = style;
            return true;
        }
    }
}

