/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.contentassist;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.tests.contentassist.AbstractContentAssistTest;
import org.eclipse.jface.text.tests.contentassist.BarContentAssistProcessor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.tests.Accessor;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ContextInformationTest
extends AbstractContentAssistTest {
    private Shell infoShell;

    private ContentAssistant createBarContentAssist() {
        ContentAssistant contentAssistant = new ContentAssistant();
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new BarContentAssistProcessor(), "__dftl_partition_content_type");
        return contentAssistant;
    }

    @Test
    public void testContextInfo() throws Exception {
        this.setupSourceViewer(this.createBarContentAssist(), "bars are good for a beer.");
        this.selectAndReveal(4, 0);
        ContextInformationTest.processEvents();
        List<Shell> beforeShells = ContextInformationTest.getCurrentShells();
        this.triggerContextInformation();
        this.infoShell = ContextInformationTest.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 0", (Object)ContextInformationTest.getInfoText(this.infoShell));
        this.selectAndReveal(8, 0);
        ContextInformationTest.processEvents();
        this.triggerContextInformation();
        this.infoShell = ContextInformationTest.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 1", (Object)ContextInformationTest.getInfoText(this.infoShell));
    }

    @Test
    public void testContextInfo_hide_Bug512251() throws Exception {
        this.setupSourceViewer(this.createBarContentAssist(), "bars are good for a beer.");
        this.selectAndReveal(4, 0);
        ContextInformationTest.processEvents();
        List<Shell> beforeShells = ContextInformationTest.getCurrentShells();
        this.triggerContextInformation();
        this.infoShell = ContextInformationTest.findNewShell(beforeShells);
        this.selectAndReveal(8, 0);
        ContextInformationTest.processEvents();
        this.triggerContextInformation();
        this.infoShell = ContextInformationTest.findNewShell(beforeShells);
        this.getDocument().set("");
        new Accessor((Object)this.getContentAssistant(), ContentAssistant.class).invoke("hide", new Object[0]);
    }

    @Test
    public void testContextInfo_hide_focusOut() throws Exception {
        this.setupSourceViewer(this.createBarContentAssist(), "bars are good for a beer.");
        this.selectAndReveal(4, 0);
        ContextInformationTest.processEvents();
        List<Shell> beforeShells = ContextInformationTest.getCurrentShells();
        this.triggerContextInformation();
        this.infoShell = ContextInformationTest.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 0", (Object)ContextInformationTest.getInfoText(this.infoShell));
        this.selectAndReveal(8, 0);
        ContextInformationTest.processEvents();
        this.triggerContextInformation();
        this.infoShell = ContextInformationTest.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 1", (Object)ContextInformationTest.getInfoText(this.infoShell));
        this.getButton().setFocus();
        ContextInformationTest.processEvents();
        Assume.assumeFalse((String)"Test fails on Mac: Bug 558989", (boolean)"macosx".equals(Platform.getOS()));
        Assume.assumeFalse((String)"Test fails on CentOS 8: See https://github.com/eclipse-platform/eclipse.platform.text/pull/162", (boolean)"linux".equals(Platform.getOS()));
        Assert.assertTrue((String)("Shell not disposed:" + String.valueOf(this.infoShell)), (boolean)this.infoShell.isDisposed());
    }

    @Test
    public void testContextInfo_hide_keyEsc() throws Exception {
        this.setupSourceViewer(this.createBarContentAssist(), "bars are good for a beer.");
        this.selectAndReveal(4, 0);
        ContextInformationTest.processEvents();
        List<Shell> beforeShells = ContextInformationTest.getCurrentShells();
        this.triggerContextInformation();
        this.infoShell = ContextInformationTest.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 0", (Object)ContextInformationTest.getInfoText(this.infoShell));
        this.selectAndReveal(8, 0);
        ContextInformationTest.processEvents();
        this.triggerContextInformation();
        this.infoShell = ContextInformationTest.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 1", (Object)ContextInformationTest.getInfoText(this.infoShell));
        this.emulatePressEscKey();
        ContextInformationTest.processEvents();
        this.infoShell = ContextInformationTest.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 0", (Object)ContextInformationTest.getInfoText(this.infoShell));
        this.emulatePressEscKey();
        ContextInformationTest.processEvents();
        Assert.assertTrue((this.infoShell.isDisposed() || !this.infoShell.isVisible() ? 1 : 0) != 0);
    }

    @Test
    public void testContextInfo_hide_validRange() throws Exception {
        this.setupSourceViewer(this.createBarContentAssist(), "bars are good for a beer.\n");
        this.selectAndReveal(4, 0);
        ContextInformationTest.processEvents();
        List<Shell> beforeShells = ContextInformationTest.getCurrentShells();
        this.triggerContextInformation();
        this.infoShell = ContextInformationTest.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 0", (Object)ContextInformationTest.getInfoText(this.infoShell));
        this.selectAndReveal(8, 0);
        ContextInformationTest.processEvents();
        this.triggerContextInformation();
        this.infoShell = ContextInformationTest.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 1", (Object)ContextInformationTest.getInfoText(this.infoShell));
        this.emulatePressArrowKey(0x1000003);
        ContextInformationTest.processEvents();
        this.infoShell = ContextInformationTest.findNewShell(beforeShells);
        Assert.assertEquals((Object)"idx= 0", (Object)ContextInformationTest.getInfoText(this.infoShell));
        this.emulatePressArrowKey(0x1000002);
        ContextInformationTest.processEvents();
        Assert.assertTrue((this.infoShell.isDisposed() || !this.infoShell.isVisible() ? 1 : 0) != 0);
    }

    static String getInfoText(Shell shell) {
        Control[] children;
        Assert.assertTrue((boolean)shell.isVisible());
        Control[] controlArray = children = shell.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Text) {
                return ((Text)child).getText();
            }
            if (child instanceof StyledText) {
                return ((StyledText)child).getText();
            }
            ++n2;
        }
        return null;
    }
}

