/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.contentassist;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class FilteringAsyncContentAssistTests {
    private Shell shell;
    private SourceViewer viewer;
    private ContentAssistant ca;

    @Before
    public void setup() {
        this.tearDown();
        this.shell = new Shell();
        this.shell.setSize(300, 300);
        this.shell.open();
        DisplayHelper.runEventLoop((Display)this.shell.getDisplay(), (long)0L);
        this.viewer = new SourceViewer((Composite)this.shell, null, 0);
        Document document = new Document();
        this.viewer.setDocument((IDocument)document);
        this.ca = new ContentAssistant(true);
    }

    @After
    public void tearDown() {
        if (this.shell != null) {
            this.ca.uninstall();
            if (!this.shell.isDisposed()) {
                this.shell.dispose();
            }
            this.shell = null;
        }
    }

    @Test
    public void testSimpleCa() throws Exception {
        this.ca.addContentAssistProcessor((IContentAssistProcessor)new ImmediateContentAssistProcessor("xx"), "__dftl_partition_content_type");
        this.ca.install((ITextViewer)this.viewer);
        this.viewer.setSelectedRange(0, 0);
        this.ca.showPossibleCompletions();
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)300L);
        List<ICompletionProposal> computedProposals = FilteringAsyncContentAssistTests.getComputedProposals(this.ca);
        Assert.assertEquals((long)1L, (long)computedProposals.size());
        ICompletionProposal proposal = computedProposals.get(0);
        IDocument document = this.viewer.getDocument();
        proposal.apply(document);
        Assert.assertEquals((Object)"xx", (Object)document.get());
    }

    @Test
    public void testFilteredCa() throws Exception {
        IDocument document = this.viewer.getDocument();
        this.ca.addContentAssistProcessor((IContentAssistProcessor)new ImmediateContentAssistProcessor("xx"), "__dftl_partition_content_type");
        this.ca.addContentAssistProcessor((IContentAssistProcessor)new ImmediateContentAssistProcessor("yy"), "__dftl_partition_content_type");
        this.ca.install((ITextViewer)this.viewer);
        this.viewer.setSelectedRange(1, 0);
        this.ca.showPossibleCompletions();
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)300L);
        List<ICompletionProposal> computedProposals = FilteringAsyncContentAssistTests.getComputedProposals(this.ca);
        Assert.assertEquals((long)2L, (long)computedProposals.size());
        List<ICompletionProposal> filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(this.ca);
        Assert.assertEquals((long)2L, (long)filteredProposals.size());
        new InsertEdit(0, "x").apply(document);
        this.viewer.setSelectedRange(1, 0);
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)300L);
        computedProposals = FilteringAsyncContentAssistTests.getComputedProposals(this.ca);
        Assert.assertEquals((long)2L, (long)computedProposals.size());
        filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(this.ca);
        Assert.assertEquals((long)1L, (long)filteredProposals.size());
        ((ICompletionProposalExtension)filteredProposals.get(0)).apply(document, '\u0000', this.viewer.getSelectedRange().x);
        Assert.assertEquals((Object)"xx", (Object)document.get());
    }

    @Test
    public void testFilteredCa_AllFilteredOut() throws Exception {
        IDocument document = this.viewer.getDocument();
        this.ca.addContentAssistProcessor((IContentAssistProcessor)new ImmediateContentAssistProcessor("xx"), "__dftl_partition_content_type");
        this.ca.install((ITextViewer)this.viewer);
        this.viewer.setSelectedRange(1, 0);
        this.ca.showPossibleCompletions();
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)300L);
        List<ICompletionProposal> computedProposals = FilteringAsyncContentAssistTests.getComputedProposals(this.ca);
        Assert.assertEquals((long)1L, (long)computedProposals.size());
        List<ICompletionProposal> filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(this.ca);
        Assert.assertEquals((long)1L, (long)filteredProposals.size());
        new InsertEdit(0, "a").apply(document);
        this.viewer.setSelectedRange(1, 0);
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)600L);
        filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(this.ca);
        Assert.assertTrue((filteredProposals == null || filteredProposals.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleCaProcessors() throws Exception {
        IDocument document = this.viewer.getDocument();
        this.ca.addContentAssistProcessor((IContentAssistProcessor)new ImmediateContentAssistProcessor("xx"), "__dftl_partition_content_type");
        this.ca.addContentAssistProcessor((IContentAssistProcessor)new DelayedContentAssistProcessor(Collections.singletonList("yy"), 3000L, false), "__dftl_partition_content_type");
        this.ca.install((ITextViewer)this.viewer);
        this.viewer.setSelectedRange(0, 0);
        this.ca.showPossibleCompletions();
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)300L);
        List<ICompletionProposal> computedProposals = FilteringAsyncContentAssistTests.getComputedProposals(this.ca, p -> p instanceof IncompleteCompletionProposal);
        Assert.assertEquals((long)1L, (long)computedProposals.size());
        List<ICompletionProposal> filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(this.ca, p -> p instanceof IncompleteCompletionProposal);
        Assert.assertEquals((long)1L, (long)filteredProposals.size());
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)3000L);
        computedProposals = FilteringAsyncContentAssistTests.getComputedProposals(this.ca, p -> p instanceof IncompleteCompletionProposal);
        Assert.assertEquals((long)2L, (long)computedProposals.size());
        filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(this.ca, p -> p instanceof IncompleteCompletionProposal);
        Assert.assertEquals((long)2L, (long)filteredProposals.size());
        ((ICompletionProposalExtension)filteredProposals.get(1)).apply(document, '\u0000', this.viewer.getSelectedRange().x);
        Assert.assertEquals((Object)"yy", (Object)document.get());
    }

    @Test
    public void testCA_WithFirstDelayedThenImmediateProposals() throws Exception {
        IDocument document = this.viewer.getDocument();
        this.ca.addContentAssistProcessor((IContentAssistProcessor)new LongInitialContentAssistProcessor(Collections.singletonList("abc"), 500L, true), "__dftl_partition_content_type");
        this.ca.install((ITextViewer)this.viewer);
        this.viewer.setSelectedRange(0, 0);
        this.ca.showPossibleCompletions();
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)200L);
        new InsertEdit(0, "a").apply(document);
        this.viewer.setSelectedRange(1, 0);
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)3000L);
        List<ICompletionProposal> filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(this.ca, p -> p instanceof IncompleteCompletionProposal);
        Assert.assertNotNull(filteredProposals);
        Assert.assertEquals((long)1L, (long)filteredProposals.size());
        filteredProposals.get(0).apply(document);
        Assert.assertEquals((Object)"aabc", (Object)document.get());
    }

    @Test
    @Ignore
    public void testFastCompletionsNotFilteredUntilLongComplitionsCalculated() throws Exception {
        IDocument document = this.viewer.getDocument();
        this.ca.addContentAssistProcessor((IContentAssistProcessor)new ImmediateContentAssistProcessor("xxxx"), "__dftl_partition_content_type");
        this.ca.addContentAssistProcessor((IContentAssistProcessor)new DelayedContentAssistProcessor(Collections.singletonList("yyyy"), 5000L, false), "__dftl_partition_content_type");
        this.ca.install((ITextViewer)this.viewer);
        this.viewer.setSelectedRange(1, 0);
        this.ca.showPossibleCompletions();
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)300L);
        List<ICompletionProposal> computedProposals = FilteringAsyncContentAssistTests.getComputedProposals(this.ca, p -> p instanceof IncompleteCompletionProposal);
        Assert.assertEquals((long)1L, (long)computedProposals.size());
        List<ICompletionProposal> filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(this.ca, p -> p instanceof IncompleteCompletionProposal);
        Assert.assertEquals((long)1L, (long)filteredProposals.size());
        new InsertEdit(0, "a").apply(document);
        this.viewer.setSelectedRange(1, 0);
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)1000L);
        filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(this.ca, p -> p instanceof IncompleteCompletionProposal);
        Assert.assertTrue((filteredProposals == null || filteredProposals.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testProposalValidation() throws Exception {
        IDocument document = this.viewer.getDocument();
        BlockingProcessor processor = new BlockingProcessor("abcd()");
        this.ca.addContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        this.ca.install((ITextViewer)this.viewer);
        this.viewer.setSelectedRange(0, 0);
        this.ca.showPossibleCompletions();
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)50L);
        new InsertEdit(0, "a").apply(document);
        this.viewer.setSelectedRange(1, 0);
        new InsertEdit(1, "b").apply(document);
        this.viewer.setSelectedRange(2, 0);
        processor.blocked.countDown();
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)100L);
        new InsertEdit(2, "c").apply(document);
        this.viewer.setSelectedRange(3, 0);
        new InsertEdit(3, "d").apply(document);
        this.viewer.setSelectedRange(4, 0);
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)100L);
        List<ICompletionProposal> filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(this.ca, p -> p instanceof CompletionProposal);
        Assert.assertNotNull(filteredProposals);
        Assert.assertEquals((long)1L, (long)filteredProposals.size());
        filteredProposals.get(0).apply(document);
        Assert.assertEquals((Object)"abcd()", (Object)document.get());
    }

    private static List<ICompletionProposal> getComputedProposals(ContentAssistant ca) throws Exception {
        Field f = ContentAssistant.class.getDeclaredField("fProposalPopup");
        f.setAccessible(true);
        Object caPopup = f.get(ca);
        Assert.assertEquals((Object)"org.eclipse.jface.text.contentassist.AsyncCompletionProposalPopup", (Object)caPopup.getClass().getName());
        Class<?> caPopupSuperClass = caPopup.getClass().getSuperclass();
        Assert.assertEquals((Object)"org.eclipse.jface.text.contentassist.CompletionProposalPopup", (Object)caPopupSuperClass.getName());
        Field computedProposals = caPopupSuperClass.getDeclaredField("fComputedProposals");
        computedProposals.setAccessible(true);
        return (List)computedProposals.get(caPopup);
    }

    static List<ICompletionProposal> getFilteredProposals(ContentAssistant ca) throws Exception {
        Field f = ContentAssistant.class.getDeclaredField("fProposalPopup");
        f.setAccessible(true);
        Object caPopup = f.get(ca);
        Assert.assertEquals((Object)"org.eclipse.jface.text.contentassist.AsyncCompletionProposalPopup", (Object)caPopup.getClass().getName());
        Class<?> caPopupSuperClass = caPopup.getClass().getSuperclass();
        Assert.assertEquals((Object)"org.eclipse.jface.text.contentassist.CompletionProposalPopup", (Object)caPopupSuperClass.getName());
        Field computedProposals = caPopupSuperClass.getDeclaredField("fFilteredProposals");
        computedProposals.setAccessible(true);
        return (List)computedProposals.get(caPopup);
    }

    private static List<ICompletionProposal> getComputedProposals(ContentAssistant ca, Predicate<ICompletionProposal> p) throws Exception {
        List<ICompletionProposal> computedProposals = FilteringAsyncContentAssistTests.getComputedProposals(ca);
        return computedProposals == null ? null : computedProposals.stream().filter(p).toList();
    }

    private static List<ICompletionProposal> getFilteredProposals(ContentAssistant ca, Predicate<ICompletionProposal> p) throws Exception {
        List<ICompletionProposal> filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(ca);
        return filteredProposals == null ? null : filteredProposals.stream().filter(p).toList();
    }

    private static boolean isSubstringFoundOrderedInString(String subString, String string) {
        int lastIndex = 0;
        subString = subString.toLowerCase();
        string = string.toLowerCase();
        char[] cArray = subString.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            int index = string.indexOf(c.charValue(), lastIndex);
            if (index < 0) {
                return false;
            }
            lastIndex = index + 1;
            ++n2;
        }
        return true;
    }

    private class BlockingProcessor
    extends ImmediateContentAssistProcessor {
        final CountDownLatch blocked;

        BlockingProcessor(String ... templates) {
            super(Arrays.asList(templates), false);
            this.blocked = new CountDownLatch(1);
        }

        @Override
        public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int offset) {
            try {
                this.blocked.await();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Cannot generate delayed content assist proposals!");
            }
            return super.computeCompletionProposals(textViewer, offset);
        }
    }

    static class CompletionProposal
    extends IncompleteCompletionProposal
    implements ICompletionProposalExtension,
    ICompletionProposalExtension2,
    ICompletionProposalExtension3 {
        public CompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, String displayString) {
            super(replacementString, replacementOffset, replacementLength, cursorPosition, displayString);
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            this.apply(viewer.getDocument());
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            if (event != null) {
                this.fReplacementLength += event.fText.length() - event.fLength;
            }
            if (offset > this.fReplacementOffset) {
                try {
                    return FilteringAsyncContentAssistTests.isSubstringFoundOrderedInString(document.get(this.fReplacementOffset, offset - this.fReplacementOffset), this.fReplacementString);
                }
                catch (BadLocationException e) {
                    throw new IllegalStateException("Completion validation failed");
                }
            }
            return false;
        }

        public void apply(IDocument document, char trigger, int offset) {
            this.apply(document);
        }

        public boolean isValidFor(IDocument document, int offset) {
            return this.validate(document, offset, null);
        }

        public char[] getTriggerCharacters() {
            return new char[0];
        }

        public int getContextInformationPosition() {
            return 0;
        }

        public int getPrefixCompletionStart(IDocument document, int completionOffset) {
            return 0;
        }

        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            return this.getDisplayString();
        }

        public IInformationControlCreator getInformationControlCreator() {
            return null;
        }

        public String toString() {
            return this.getDisplayString();
        }
    }

    static class DelayedContentAssistProcessor
    extends ImmediateContentAssistProcessor {
        protected long delay;

        DelayedContentAssistProcessor(List<String> templates, long delay, boolean incomplete) {
            super(templates, incomplete);
            this.delay = delay;
        }

        @Override
        public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int offset) {
            if (this.delay > 0L) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Cannot generate delayed content assist proposals!");
                }
            }
            return super.computeCompletionProposals(textViewer, offset);
        }
    }

    static class ImmediateContentAssistProcessor
    implements IContentAssistProcessor {
        private final List<String> templates;
        private final boolean incomplete;

        ImmediateContentAssistProcessor(String ... templates) {
            this(Arrays.asList(templates), false);
        }

        ImmediateContentAssistProcessor(List<String> templates, boolean incomplete) {
            this.templates = templates;
            this.incomplete = incomplete;
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int offset) {
            ArrayList<IncompleteCompletionProposal> proposals = new ArrayList<IncompleteCompletionProposal>();
            try {
                IDocument document = textViewer.getDocument();
                for (String template : this.templates) {
                    if (document == null || document.getLength() != 0 && !FilteringAsyncContentAssistTests.isSubstringFoundOrderedInString(document.get(0, offset), template)) continue;
                    if (this.incomplete) {
                        proposals.add(new IncompleteCompletionProposal(template, offset, 0, offset, template));
                        continue;
                    }
                    proposals.add(new CompletionProposal(template, offset, 0, offset, template));
                }
            }
            catch (BadLocationException e) {
                throw new IllegalStateException("Error computing proposals");
            }
            return proposals.toArray(new ICompletionProposal[0]);
        }

        public IContextInformation[] computeContextInformation(ITextViewer textViewer, int offset) {
            return new IContextInformation[0];
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return new char[0];
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return new char[0];
        }

        public String getErrorMessage() {
            return "No proposals!";
        }

        public IContextInformationValidator getContextInformationValidator() {
            return new ContextInformationValidator((IContentAssistProcessor)this);
        }
    }

    private static class IncompleteCompletionProposal
    implements ICompletionProposal {
        private final String fDisplayString;
        protected String fReplacementString;
        protected int fReplacementOffset;
        protected int fReplacementLength;
        private final int fCursorPosition;

        public IncompleteCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, String displayString) {
            this.fReplacementString = replacementString;
            this.fReplacementOffset = replacementOffset;
            this.fReplacementLength = replacementLength;
            this.fCursorPosition = cursorPosition;
            this.fDisplayString = displayString;
        }

        public void apply(IDocument document) {
            try {
                document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public Image getImage() {
            return null;
        }

        public String getDisplayString() {
            if (this.fDisplayString != null) {
                return this.fDisplayString;
            }
            return this.fReplacementString;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }
    }

    private class LongInitialContentAssistProcessor
    extends DelayedContentAssistProcessor {
        LongInitialContentAssistProcessor(List<String> templates, long delay, boolean incomplete) {
            super(templates, delay, incomplete);
        }

        @Override
        public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int offset) {
            ICompletionProposal[] completionProposals = super.computeCompletionProposals((ITextViewer)FilteringAsyncContentAssistTests.this.viewer, offset);
            this.delay = 0L;
            return completionProposals;
        }
    }
}

