/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.contentassist;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.tests.contentassist.FilteringAsyncContentAssistTests;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IncrementalAsyncContentAssistTests {
    private Shell shell;
    private SourceViewer viewer;
    private ContentAssistant ca;

    @Before
    public void setup() {
        this.tearDown();
        this.shell = new Shell();
        this.shell.setSize(300, 300);
        this.shell.open();
        DisplayHelper.runEventLoop((Display)this.shell.getDisplay(), (long)0L);
        this.viewer = new SourceViewer((Composite)this.shell, null, 0);
        Document document = new Document();
        this.viewer.setDocument((IDocument)document);
        this.ca = new ContentAssistant(true);
        Comparator<ICompletionProposal> comparator = Comparator.comparing(ICompletionProposal::getDisplayString);
        this.ca.setSorter(comparator::compare);
    }

    @After
    public void tearDown() {
        if (this.shell != null) {
            this.ca.uninstall();
            if (!this.shell.isDisposed()) {
                this.shell.dispose();
            }
            this.shell = null;
        }
    }

    @Test
    public void testIncrementalComplete() throws Exception {
        this.ca.addContentAssistProcessor((IContentAssistProcessor)new FilteringAsyncContentAssistTests.ImmediateContentAssistProcessor("testC", "testB", "testA"), "__dftl_partition_content_type");
        this.viewer.getDocument().set("t");
        this.ca.install((ITextViewer)this.viewer);
        this.viewer.setSelectedRange(1, 0);
        this.ca.completePrefix();
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)300L);
        List<String> filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(this.ca).stream().map(ICompletionProposal::getDisplayString).toList();
        Assert.assertEquals(Arrays.asList("testA", "testB", "testC"), filteredProposals);
    }

    @Test
    public void testIncrementalComplete_async() throws Exception {
        long delay = 200L;
        this.ca.addContentAssistProcessor((IContentAssistProcessor)new FilteringAsyncContentAssistTests.DelayedContentAssistProcessor(Arrays.asList("testC", "testB", "testA"), delay, false), "__dftl_partition_content_type");
        this.viewer.getDocument().set("t");
        this.ca.install((ITextViewer)this.viewer);
        this.viewer.setSelectedRange(1, 0);
        this.ca.completePrefix();
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)(delay + 100L));
        List<String> filteredProposals = FilteringAsyncContentAssistTests.getFilteredProposals(this.ca).stream().map(ICompletionProposal::getDisplayString).toList();
        Assert.assertEquals(Arrays.asList("testA", "testB", "testC"), filteredProposals);
    }

    @Test
    public void testIncrementalCompleteOfSingleProposal() throws Exception {
        this.ca.enableAutoInsert(true);
        this.ca.addContentAssistProcessor((IContentAssistProcessor)new FilteringAsyncContentAssistTests.ImmediateContentAssistProcessor("testA"), "__dftl_partition_content_type");
        this.ca.install((ITextViewer)this.viewer);
        this.viewer.setSelectedRange(0, 0);
        this.ca.completePrefix();
        DisplayHelper.sleep((Display)this.shell.getDisplay(), (long)300L);
        Assert.assertEquals((Object)"testA", (Object)this.viewer.getDocument().get());
    }
}

