/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.reconciler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.tests.TestTextViewer;
import org.eclipse.text.tests.Accessor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractReconcilerTest {
    private Accessor fAccessor;
    private Barrier fBarrier;
    private List<String> fCallLog;
    private ITextViewer fViewer;
    protected AbstractReconciler fReconciler;
    private Document fDocument;
    private IProgressMonitor fProgressMonitor;

    @Before
    public void setUp() {
        this.fBarrier = new Barrier();
        this.fCallLog = Collections.synchronizedList(new ArrayList());
        this.fReconciler = new AbstractReconciler(){

            protected void initialProcess() {
                AbstractReconcilerTest.this.fCallLog.add("initialProcess");
                AbstractReconcilerTest.this.fBarrier.await();
            }

            protected void process(DirtyRegion dirtyRegion) {
                AbstractReconcilerTest.this.fCallLog.add("process");
                AbstractReconcilerTest.this.fBarrier.await();
            }

            protected void reconcilerDocumentChanged(IDocument newDocument) {
                AbstractReconcilerTest.this.fCallLog.add("reconcilerDocumentChanged");
            }

            protected void aboutToWork() {
                AbstractReconcilerTest.this.aboutToWork(this);
            }

            protected void aboutToBeReconciled() {
                AbstractReconcilerTest.this.fCallLog.add("aboutToBeReconciled");
            }

            protected void reconcilerReset() {
                AbstractReconcilerTest.this.fCallLog.add("reconcilerReset");
            }

            public IReconcilingStrategy getReconcilingStrategy(String contentType) {
                return null;
            }
        };
        this.fReconciler.setIsIncrementalReconciler(false);
        this.fReconciler.setDelay(this.getDelay());
        this.fProgressMonitor = new NullProgressMonitor();
        this.fReconciler.setProgressMonitor(this.fProgressMonitor);
        this.fViewer = new TestTextViewer();
        this.fReconciler.install(this.fViewer);
        this.fAccessor = new Accessor((Object)this.fReconciler, AbstractReconciler.class);
        Object object = this.fAccessor.get("fWorker");
        this.fAccessor = new Accessor(object, object.getClass());
    }

    int getDelay() {
        return 50;
    }

    void aboutToWork(AbstractReconciler reconciler) {
    }

    @After
    public void tearDown() throws Exception {
        this.fBarrier.shutdown();
        this.fReconciler.uninstall();
    }

    @Test
    public void testInitialReconcile() throws InterruptedException {
        Assert.assertFalse((boolean)this.isActive());
        Assert.assertFalse((boolean)this.isDirty());
        this.fDocument = new Document("foo");
        this.fViewer.setDocument((IDocument)this.fDocument);
        Assert.assertEquals((Object)"reconcilerDocumentChanged", (Object)this.fCallLog.remove(0));
        Assert.assertEquals((Object)"aboutToBeReconciled", (Object)this.fCallLog.remove(0));
        this.fBarrier.await();
        Assert.assertEquals((Object)"initialProcess", (Object)this.fCallLog.remove(0));
        Assert.assertFalse((boolean)this.isActive());
        Assert.assertFalse((boolean)this.isDirty());
        this.fBarrier.wakeAll();
        this.pollUntilClean();
        Assert.assertFalse((boolean)this.isActive());
        Assert.assertFalse((boolean)this.isDirty());
    }

    @Test
    public void testDirtyingWhenClean() throws BadLocationException, InterruptedException {
        this.installDocument();
        this.dirty();
        Assert.assertEquals((Object)"aboutToBeReconciled", (Object)this.fCallLog.remove(0));
        Assert.assertEquals((Object)"reconcilerReset", (Object)this.fCallLog.remove(0));
        this.fBarrier.await();
        Assert.assertEquals((Object)"process", (Object)this.fCallLog.remove(0));
        Assert.assertTrue((boolean)this.isActive());
        Assert.assertTrue((boolean)this.isDirty());
        this.fBarrier.wakeAll();
        this.pollUntilClean();
        Assert.assertFalse((boolean)this.isActive());
        Assert.assertFalse((boolean)this.isDirty());
    }

    private void dirty() throws BadLocationException {
        this.fDocument.replace(0, 0, "bar");
    }

    @Test
    public void testDirtyingWhenRunning() throws InterruptedException, BadLocationException {
        this.installDocument();
        this.dirty();
        this.fBarrier.await();
        Assert.assertTrue((boolean)this.isActive());
        Assert.assertTrue((boolean)this.isDirty());
        this.fCallLog.clear();
        this.dirty();
        if (this.fProgressMonitor.isCanceled()) {
            Assert.assertEquals((Object)"aboutToBeReconciled", (Object)this.fCallLog.remove(0));
        }
        Assert.assertEquals((Object)"reconcilerReset", (Object)this.fCallLog.remove(0));
        this.fBarrier.wakeAll();
        this.fBarrier.await();
        Assert.assertEquals((Object)"process", (Object)this.fCallLog.remove(0));
        this.fBarrier.wakeAll();
        this.pollUntilClean();
        Assert.assertFalse((boolean)this.isActive());
        Assert.assertFalse((boolean)this.isDirty());
    }

    @Test
    public void testCancellingWhenClean() throws InterruptedException, BadLocationException {
        this.installDocument();
        this.dirty();
        this.fBarrier.await();
        this.fBarrier.wakeAll();
        this.fCallLog.clear();
        this.fReconciler.uninstall();
        this.pollUntilInactive();
        Assert.assertTrue((boolean)this.fCallLog.isEmpty());
        Assert.assertFalse((boolean)this.isActive());
    }

    @Test
    public void testCancellingWhenRunning() throws InterruptedException, BadLocationException {
        this.installDocument();
        this.dirty();
        this.fBarrier.await();
        this.fCallLog.clear();
        this.fReconciler.uninstall();
        this.fBarrier.wakeAll();
        this.pollUntilInactive();
        Assert.assertTrue((boolean)this.fCallLog.isEmpty());
        Assert.assertFalse((boolean)this.isActive());
    }

    @Test
    public void testReplacingDocumentWhenClean() throws InterruptedException {
        this.installDocument();
        this.fCallLog.clear();
        this.fViewer.setDocument((IDocument)new Document("bar"));
        Assert.assertEquals((Object)"reconcilerDocumentChanged", (Object)this.fCallLog.remove(0));
        Assert.assertEquals((Object)"aboutToBeReconciled", (Object)this.fCallLog.remove(0));
        Assert.assertEquals((Object)"reconcilerReset", (Object)this.fCallLog.remove(0));
        this.fBarrier.await();
        Assert.assertEquals((Object)"process", (Object)this.fCallLog.remove(0));
        this.fBarrier.wakeAll();
        this.pollUntilClean();
        Assert.assertFalse((boolean)this.isActive());
        Assert.assertFalse((boolean)this.isDirty());
    }

    @Test
    public void testReplacingDocumentWhenRunning() throws InterruptedException, BadLocationException {
        this.installDocument();
        this.dirty();
        this.fBarrier.await();
        this.fCallLog.clear();
        this.fViewer.setDocument((IDocument)new Document("bar"));
        Assert.assertEquals((Object)"reconcilerDocumentChanged", (Object)this.fCallLog.remove(0));
        Assert.assertEquals((Object)"reconcilerReset", (Object)this.fCallLog.remove(0));
        Assert.assertTrue((boolean)this.fCallLog.isEmpty());
        this.fBarrier.wakeAll();
    }

    void installDocument() throws InterruptedException {
        this.fDocument = new Document("foo");
        this.fViewer.setDocument((IDocument)this.fDocument);
        this.fBarrier.await();
        this.fBarrier.wakeAll();
        this.pollUntilClean();
        this.fCallLog.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollUntilClean() throws InterruptedException {
        long start = System.currentTimeMillis();
        while (this.isDirty()) {
            long current = System.currentTimeMillis();
            if (current > start + 5000L) {
                Assert.fail((String)"waited > 5s for reconciler to complete");
            }
            AbstractReconcilerTest abstractReconcilerTest = this;
            synchronized (abstractReconcilerTest) {
                this.wait(50L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollUntilInactive() throws InterruptedException {
        long start = System.currentTimeMillis();
        while (this.isActive()) {
            long current = System.currentTimeMillis();
            if (current > start + 5000L) {
                Assert.fail((String)"waited > 5s for reconciler to complete");
            }
            AbstractReconcilerTest abstractReconcilerTest = this;
            synchronized (abstractReconcilerTest) {
                this.wait(50L);
            }
        }
    }

    boolean isActive() {
        Object bool = this.fAccessor.invoke("isActive", new Object[0]);
        return (Boolean)bool;
    }

    boolean isCanceled() {
        Object bool = this.fAccessor.invoke("isCanceled", new Object[0]);
        return (Boolean)bool;
    }

    boolean isDirty() {
        Object bool = this.fAccessor.invoke("isDirty", new Object[0]);
        return (Boolean)bool;
    }

    static class Barrier {
        private final Object fMutex = new Object();
        private final int fParticipants;
        private final Thread fMainThread = Thread.currentThread();
        private int fWaiting = 0;
        private boolean fMainThreadArrived = false;
        private boolean fIsInactive = false;

        Barrier() {
            this.fParticipants = 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await() {
            Object object = this.fMutex;
            synchronized (object) {
                boolean isMainThread;
                if (this.fIsInactive) {
                    return;
                }
                ++this.fWaiting;
                boolean bl = isMainThread = Thread.currentThread() == this.fMainThread;
                if (isMainThread) {
                    this.fMainThreadArrived = true;
                }
                if (this.allArrived()) {
                    if (!this.fMainThreadArrived) {
                        --this.fWaiting;
                        throw new RuntimeException(String.valueOf(this.getClass()) + " can't join barrier if only the main thread is missing!");
                    }
                    if (!isMainThread) {
                        this.notifyMainThread();
                    }
                }
                if (!this.allArrived() || !isMainThread) {
                    try {
                        if (!isMainThread) {
                            this.fMutex.wait();
                        } else {
                            this.fMutex.wait(5000L);
                            if (!this.allArrived()) {
                                Assert.fail((String)"reconciler never ran in 5 seconds");
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        throw new Error();
                    }
                }
            }
        }

        private boolean allArrived() {
            return this.fWaiting == this.fParticipants;
        }

        private void notifyMainThread() {
            this.fMutex.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeAll() {
            Object object = this.fMutex;
            synchronized (object) {
                this.fWaiting = 0;
                this.fMainThreadArrived = false;
                this.fMutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.fMutex;
            synchronized (object) {
                this.fIsInactive = true;
                this.fMutex.notifyAll();
            }
        }
    }
}

