/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.rules;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FastPartitionerZeroLengthTest {
    private static final String COMMENT = "comment";
    private static final String DEFAULT = "__dftl_partition_content_type";
    private IDocument fDoc;
    private FastPartitioner fPartitioner;

    @Before
    public void setUp() {
        this.fDoc = new Document();
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner(){
            {
                Token comment = new Token((Object)FastPartitionerZeroLengthTest.COMMENT);
                IPredicateRule[] rules = new IPredicateRule[]{new MultiLineRule("/*", "*/", (IToken)comment)};
                this.setPredicateRules(rules);
            }
        };
        this.fPartitioner = new FastPartitioner((IPartitionTokenScanner)scanner, new String[]{DEFAULT, COMMENT});
        this.fDoc.setDocumentPartitioner((IDocumentPartitioner)this.fPartitioner);
        this.fPartitioner.connect(this.fDoc);
    }

    @Test
    public void testGetZeroLengthPartition() {
        this.fDoc.set("docu     ment/* comment */docu     ment");
        int[] offsets = new int[]{13, 26};
        this.assertGetZeroLengthPartition_InterleavingPartitions(offsets);
    }

    @Test
    public void testGetZeroLengthPartitionEmptyMiddle() {
        this.fDoc.set("docu     ment/* comment *//* comment */docu     ment");
        int[] offsets = new int[]{13, 26, 26, 39};
        this.assertGetZeroLengthPartition_InterleavingPartitions(offsets);
    }

    @Test
    public void testGetZeroLengthPartitionEmptyStart() {
        this.fDoc.set("/* comment */docu     ment");
        int[] nArray = new int[2];
        nArray[1] = 13;
        int[] offsets = nArray;
        this.assertGetZeroLengthPartition_InterleavingPartitions(offsets);
    }

    @Test
    public void testGetZeroLengthPartitionEmptyEnd() {
        this.fDoc.set("docu     ment/* comment */");
        int[] offsets = new int[]{13, 26};
        this.assertGetZeroLengthPartition_InterleavingPartitions(offsets);
    }

    @Test
    public void testGetZeroLengthContentType() {
        this.fDoc.set("docu     ment/* comment */docu     ment");
        int[] offsets = new int[]{13, 26};
        this.assertGetZeroLengthContentType_InterleavingPartitions(offsets);
    }

    @Test
    public void testGetZeroLengthContentTypeEmptyMiddle() {
        this.fDoc.set("docu     ment/* comment *//* comment */docu     ment");
        int[] offsets = new int[]{13, 26, 26, 39};
        this.assertGetZeroLengthContentType_InterleavingPartitions(offsets);
    }

    @Test
    public void testGetZeroLengthContentTypeEmptyStart() {
        this.fDoc.set("/* comment */docu     ment");
        int[] nArray = new int[2];
        nArray[1] = 13;
        int[] offsets = nArray;
        this.assertGetZeroLengthContentType_InterleavingPartitions(offsets);
    }

    @Test
    public void testGetZeroLengthContentTypeEmptyEnd() {
        this.fDoc.set("docu     ment/* comment */");
        int[] offsets = new int[]{13, 26};
        this.assertGetZeroLengthContentType_InterleavingPartitions(offsets);
    }

    @Test
    public void testComputeZeroLengthPartitioning() {
        this.fDoc.set("docu     ment/* comment */docu     ment");
        int[] offsets = new int[]{13, 26};
        this.assertComputeZeroLengthPartitioning_InterleavingPartitions(offsets);
    }

    @Test
    public void testComputeZeroLengthPartitioningEmptyMiddle() {
        this.fDoc.set("docu     ment/* comment *//* comment */docu     ment");
        int[] offsets = new int[]{13, 26, 26, 39};
        this.assertComputeZeroLengthPartitioning_InterleavingPartitions(offsets);
    }

    @Test
    public void testComputeZeroLengthPartitioningEmptyStart() {
        this.fDoc.set("/* comment */docu     ment");
        int[] nArray = new int[2];
        nArray[1] = 13;
        int[] offsets = nArray;
        this.assertComputeZeroLengthPartitioning_InterleavingPartitions(offsets);
    }

    @Test
    public void testComputeZeroLengthPartitioningEmptyEnd() {
        this.fDoc.set("docu     ment/* comment */");
        int[] offsets = new int[]{13, 26};
        this.assertComputeZeroLengthPartitioning_InterleavingPartitions(offsets);
    }

    @Test
    public void testComputePartitioningSubrangeBeforeBoundaries() {
        this.fDoc.set("docu     ment/* comment *//* comment */docu     ment");
        int[] offsets = new int[]{13, 26, 26};
        this.assertComputeZeroLengthPartitioning_InterleavingPartitions(12, 38, offsets, DEFAULT);
    }

    @Test
    public void testComputePartitioningSubrangeOnBoundaries() {
        this.fDoc.set("docu     ment/* comment *//* comment */docu     ment");
        int[] offsets = new int[]{13, 26, 26, 39};
        this.assertComputeZeroLengthPartitioning_InterleavingPartitions(13, 39, offsets, DEFAULT);
    }

    @Test
    public void testComputePartitioningSubrangeOnBoundaries2() {
        this.fDoc.set("/* comment *//* comment *//* comment */");
        int[] offsets = new int[]{13, 26};
        this.assertComputeZeroLengthPartitioning_InterleavingPartitions(13, 26, offsets, DEFAULT);
    }

    @Test
    public void testComputePartitioningSubrangeAfterBoundaries() {
        this.fDoc.set("docu     ment/* comment *//* comment */docu     ment");
        int[] offsets = new int[]{26, 26, 39};
        this.assertComputeZeroLengthPartitioning_InterleavingPartitions(14, 40, offsets, COMMENT);
    }

    @Test
    public void testComputePartitioningSubrangeInBoundaries1() {
        this.fDoc.set("/* comment */");
        int[] offsets = new int[]{};
        this.assertComputeZeroLengthPartitioning_InterleavingPartitions(1, 12, offsets, COMMENT);
    }

    @Test
    public void testComputePartitioningSubrangeInBoundaries2() {
        this.fDoc.set("docu     ment");
        int[] offsets = new int[]{};
        this.assertComputeZeroLengthPartitioning_InterleavingPartitions(1, 12, offsets, DEFAULT);
    }

    private void assertComputeZeroLengthPartitioning_InterleavingPartitions(int[] offsets) {
        this.assertComputeZeroLengthPartitioning_InterleavingPartitions(0, this.fDoc.getLength(), offsets, DEFAULT);
    }

    private void assertComputeZeroLengthPartitioning_InterleavingPartitions(int startOffset, int endOffset, int[] offsets, String startType) {
        ITypedRegion[] regions = this.fPartitioner.computePartitioning(startOffset, endOffset - startOffset, true);
        String type = startType;
        int previousOffset = startOffset;
        Assert.assertEquals((long)(offsets.length + 1), (long)regions.length);
        int i = 0;
        while (i <= offsets.length) {
            int currentOffset = i == offsets.length ? endOffset : offsets[i];
            ITypedRegion region = regions[i];
            this.assertTypedRegion(region, previousOffset, currentOffset, type);
            type = type == DEFAULT ? COMMENT : DEFAULT;
            previousOffset = currentOffset;
            ++i;
        }
    }

    private void assertGetZeroLengthContentType_InterleavingPartitions(int[] offsets) {
        String type = DEFAULT;
        int previousOffset = 0;
        int i = 0;
        while (i <= offsets.length) {
            int offset = i == offsets.length ? this.fDoc.getLength() : offsets[i];
            this.assertEqualPartitionType(previousOffset, offset, type);
            type = type == DEFAULT ? COMMENT : DEFAULT;
            previousOffset = offset;
            ++i;
        }
    }

    private void assertGetZeroLengthPartition_InterleavingPartitions(int[] offsets) {
        String type = DEFAULT;
        int previousOffset = 0;
        int i = 0;
        while (i <= offsets.length) {
            int offset = i == offsets.length ? this.fDoc.getLength() : offsets[i];
            this.assertEqualPartition(previousOffset, offset, type);
            type = type == DEFAULT ? COMMENT : DEFAULT;
            previousOffset = offset;
            ++i;
        }
    }

    private boolean isOpenType(String type) {
        return type.equals(DEFAULT);
    }

    private void assertEqualPartition(int offset, int inclusiveEnd, String type) {
        int from = this.isOpenType(type) ? offset : offset + 1;
        int to = this.isOpenType(type) ? inclusiveEnd : inclusiveEnd - 1;
        int i = from;
        while (i <= to) {
            ITypedRegion region = this.fPartitioner.getPartition(i, true);
            this.assertTypedRegion(region, offset, inclusiveEnd, type);
            ++i;
        }
    }

    private void assertTypedRegion(ITypedRegion region, int offset, int inclusiveEnd, String type) {
        Assert.assertEquals((long)offset, (long)region.getOffset());
        Assert.assertEquals((long)(inclusiveEnd - offset), (long)region.getLength());
        Assert.assertEquals((Object)type, (Object)region.getType());
    }

    private void assertEqualPartitionType(int offset, int inclusiveEnd, String type) {
        int from = this.isOpenType(type) ? offset : offset + 1;
        int to = this.isOpenType(type) ? inclusiveEnd : inclusiveEnd - 1;
        int i = from;
        while (i <= to) {
            Assert.assertEquals((Object)type, (Object)this.fPartitioner.getContentType(i, true));
            ++i;
        }
    }
}

