/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.rules;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScannerColumnTest {
    private IDocument fDocument;

    @Before
    public void setUp() {
        this.fDocument = new Document("scanner test");
    }

    @After
    public void tearDown() {
        this.fDocument = null;
    }

    @Test
    public void testRuleBasedScannerColumnRead() {
        this._testScannerColumnRead(new RuleBasedScanner());
    }

    @Test
    public void testRuleBasedScannerColumnUnread() {
        this._testScannerColumnUnread(new RuleBasedScanner());
    }

    @Test
    public void testBufferedRuleBasedScannerColumnRead() {
        this._testScannerColumnRead((RuleBasedScanner)new BufferedRuleBasedScanner(100));
    }

    @Test
    public void testBufferedRuleBasedScannerColumnUnread() {
        this._testScannerColumnUnread((RuleBasedScanner)new BufferedRuleBasedScanner(100));
    }

    private void _testScannerColumnRead(RuleBasedScanner scanner) {
        scanner.setRange(this.fDocument, 0, 10);
        Assert.assertEquals((long)0L, (long)scanner.getColumn());
        Assert.assertEquals((long)115L, (long)scanner.read());
        Assert.assertEquals((long)1L, (long)scanner.getColumn());
        scanner.unread();
        Assert.assertEquals((long)0L, (long)scanner.getColumn());
    }

    private void _testScannerColumnUnread(RuleBasedScanner scanner) {
        scanner.setRange(this.fDocument, 0, 10);
        Assert.assertEquals((long)0L, (long)scanner.getColumn());
        Assert.assertEquals((long)115L, (long)scanner.read());
        Assert.assertEquals((long)1L, (long)scanner.getColumn());
        scanner.unread();
        Assert.assertEquals((long)0L, (long)scanner.getColumn());
    }
}

