/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.rules;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.junit.Assert;
import org.junit.Test;

public class WordRuleTest {
    @Test
    public void testBug163116() throws Exception {
        IWordDetector detector = new IWordDetector(){

            public boolean isWordPart(char c) {
                return true;
            }

            public boolean isWordStart(char c) {
                return true;
            }
        };
        WordRule rule = new WordRule(detector, (IToken)new Token((Object)this));
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setRules(new IRule[]{rule});
        scanner.setRange((IDocument)new Document(), 0, 0);
        IToken token = null;
        int i = 0;
        while (token != Token.EOF && i++ < 1000) {
            token = scanner.nextToken();
        }
        Assert.assertTrue((i < 1000 ? 1 : 0) != 0);
    }

    @Test
    public void testBug144355() throws Exception {
        SimpleWordDetector detector = new SimpleWordDetector();
        String defaultTokenString = "defaultToken";
        Token defaultToken = new Token((Object)defaultTokenString);
        String testTokenStringNormal = "TestTokenString";
        String testTokenStringDifferentCapitalization = "TestTOKENString";
        String testTokenStringCompletelyDifferent = "XXX";
        Token normalToken = new Token((Object)testTokenStringNormal);
        WordRule rule = new WordRule((IWordDetector)detector, (IToken)defaultToken, true);
        rule.addWord(testTokenStringNormal, (IToken)normalToken);
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setRules(new IRule[]{rule});
        scanner.setRange((IDocument)new Document(testTokenStringNormal), 0, testTokenStringNormal.length());
        Assert.assertEquals((Object)testTokenStringNormal, (Object)scanner.nextToken().getData());
        scanner = new RuleBasedScanner();
        scanner.setRules(new IRule[]{rule});
        scanner.setRange((IDocument)new Document(testTokenStringDifferentCapitalization), 0, testTokenStringDifferentCapitalization.length());
        Assert.assertEquals((Object)testTokenStringNormal, (Object)scanner.nextToken().getData());
        scanner = new RuleBasedScanner();
        scanner.setRules(new IRule[]{rule});
        scanner.setRange((IDocument)new Document(testTokenStringCompletelyDifferent), 0, testTokenStringCompletelyDifferent.length());
        Assert.assertEquals((Object)defaultTokenString, (Object)scanner.nextToken().getData());
        WordRule ruleWithoutIgnoreCase = new WordRule((IWordDetector)detector, (IToken)defaultToken);
        ruleWithoutIgnoreCase.addWord(testTokenStringNormal, (IToken)normalToken);
        scanner = new RuleBasedScanner();
        scanner.setRules(new IRule[]{ruleWithoutIgnoreCase});
        scanner.setRange((IDocument)new Document(testTokenStringNormal), 0, testTokenStringNormal.length());
        Assert.assertEquals((Object)testTokenStringNormal, (Object)scanner.nextToken().getData());
        scanner = new RuleBasedScanner();
        scanner.setRules(new IRule[]{ruleWithoutIgnoreCase});
        scanner.setRange((IDocument)new Document(testTokenStringDifferentCapitalization), 0, testTokenStringDifferentCapitalization.length());
        Assert.assertEquals((Object)defaultTokenString, (Object)scanner.nextToken().getData());
    }

    @Test
    public void testBug175712_1() throws Exception {
        IRule[] rules = new IRule[2];
        Token stepToken = new Token((Object)new TextAttribute(null, null, 1));
        PatternRule stepRule = new PatternRule("(((", ")", (IToken)stepToken, '\u0000', false);
        stepRule.setColumnConstraint(-1);
        rules[1] = stepRule;
        Token titleToken = new Token((Object)new TextAttribute(null, null, 1));
        WordRule wordRule = new WordRule((IWordDetector)new SimpleWordDetector());
        wordRule.addWord("((", (IToken)titleToken);
        rules[0] = wordRule;
        Document document = new Document("((( \n((\n- Cheese\n- Wine");
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setRules(rules);
        scanner.setRange((IDocument)document, 0, document.getLength());
        Token defaultToken = new Token((Object)this);
        scanner.setDefaultReturnToken((IToken)defaultToken);
        IToken token = scanner.nextToken();
        Assert.assertSame((Object)defaultToken, (Object)token);
        token = scanner.nextToken();
        Assert.assertSame((Object)defaultToken, (Object)token);
        token = scanner.nextToken();
        Assert.assertSame((Object)defaultToken, (Object)token);
        token = scanner.nextToken();
        Assert.assertSame((Object)titleToken, (Object)token);
    }

    @Test
    public void testBug175712_2() throws Exception {
        IRule[] rules = new IRule[2];
        Token stepToken = new Token((Object)new TextAttribute(null, null, 1));
        PatternRule stepRule = new PatternRule("(((", ")", (IToken)stepToken, '\u0000', false);
        stepRule.setColumnConstraint(-1);
        rules[1] = stepRule;
        Token titleToken = new Token((Object)new TextAttribute(null, null, 1));
        WordRule wordRule = new WordRule((IWordDetector)new SimpleWordDetector());
        wordRule.addWord("((", (IToken)titleToken);
        rules[0] = wordRule;
        Document document = new Document("((\n((\n- Cheese\n- Wine");
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setRules(rules);
        scanner.setRange((IDocument)document, 0, document.getLength());
        Token defaultToken = new Token((Object)this);
        scanner.setDefaultReturnToken((IToken)defaultToken);
        IToken token = scanner.nextToken();
        Assert.assertSame((Object)titleToken, (Object)token);
    }

    private static class SimpleWordDetector
    implements IWordDetector {
        private SimpleWordDetector() {
        }

        public boolean isWordStart(char c) {
            return !Character.isWhitespace(c);
        }

        public boolean isWordPart(char c) {
            return !Character.isWhitespace(c);
        }
    }
}

