/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.source;

import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnnotationRulerColumnTest {
    private Shell shell;
    private ILogListener listener;
    private IStatus errorStatus;

    @Before
    public void setUp() {
        this.shell = new Shell();
        this.listener = (status, plugin) -> {
            if (status.getSeverity() == 4 && "org.eclipse.ui".equals(status.getPlugin()) && "Unhandled event loop exception".equals(status.getMessage())) {
                this.errorStatus = status;
            }
        };
        Platform.addLogListener((ILogListener)this.listener);
    }

    @After
    public void tearDown() {
        this.shell.dispose();
        this.shell = null;
        Platform.removeLogListener((ILogListener)this.listener);
    }

    @Test
    public void testDrawWithEmptyProjection() throws Throwable {
        this.shell.setLayout((Layout)new FillLayout());
        AnnotationRulerColumn annotationRulerColumn = new AnnotationRulerColumn(12, (IAnnotationAccess)new TestAnnotationAccess());
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)annotationRulerColumn);
        final ProjectionViewer projectionViewer = new ProjectionViewer((Composite)this.shell, (IVerticalRuler)ruler, null, false, 0);
        projectionViewer.setDocument((IDocument)new Document("test\ndocument"), (IAnnotationModel)new AnnotationModel(), 0, 0);
        final TestPaintListener paintListener = new TestPaintListener();
        annotationRulerColumn.getControl().addPaintListener((PaintListener)paintListener);
        this.shell.open();
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return projectionViewer.getTextWidget().isVisible() && paintListener.wasPainted();
            }
        }.waitForCondition(this.shell.getDisplay(), 2000L));
        if (this.errorStatus != null && this.errorStatus.getException() != null) {
            throw this.errorStatus.getException();
        }
    }

    private static class TestAnnotationAccess
    implements IAnnotationAccess,
    IAnnotationAccessExtension {
        private TestAnnotationAccess() {
        }

        public String getTypeLabel(Annotation annotation) {
            return annotation.getText();
        }

        public int getLayer(Annotation annotation) {
            return 0;
        }

        public void paint(Annotation annotation, GC gc, Canvas canvas, Rectangle bounds) {
        }

        public boolean isPaintable(Annotation annotation) {
            return true;
        }

        public boolean isSubtype(Object annotationType, Object potentialSupertype) {
            return false;
        }

        public Object[] getSupertypes(Object annotationType) {
            return null;
        }

        @Deprecated
        public Object getType(Annotation annotation) {
            return annotation.getType();
        }

        @Deprecated
        public boolean isMultiLine(Annotation annotation) {
            return true;
        }

        @Deprecated
        public boolean isTemporary(Annotation annotation) {
            return true;
        }
    }

    private static class TestPaintListener
    implements PaintListener {
        private boolean painted;

        private TestPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            this.painted = true;
        }

        public boolean wasPainted() {
            return this.painted;
        }
    }
}

