/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.source.inlined;

import java.util.Collections;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.inlined.InlinedAnnotationSupport;
import org.eclipse.jface.text.source.inlined.LineContentAnnotation;
import org.eclipse.jface.text.tests.source.inlined.LineContentBoundsDrawingTest;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnnotationOnTabTest {
    private Shell fParent;

    @Before
    public void setUp() {
        this.fParent = new Shell();
    }

    @After
    public void tearDown() {
        this.fParent.dispose();
        this.fParent = null;
    }

    @Test
    public void testTextBoundsMatchPaintedArea() {
        this.fParent.setLayout((Layout)new FillLayout());
        SourceViewer sourceViewer = new SourceViewer((Composite)this.fParent, null, 2560);
        sourceViewer.setDocument((IDocument)new Document("\t\treference\n\t\tannotated"), (IAnnotationModel)new AnnotationModel());
        final StyledText textWidget = sourceViewer.getTextWidget();
        textWidget.setFont(JFaceResources.getTextFont());
        InlinedAnnotationSupport support = new InlinedAnnotationSupport();
        LineContentBoundsDrawingTest.AccessAllAnnoations annotationAccess = new LineContentBoundsDrawingTest.AccessAllAnnoations();
        final LineContentBoundsDrawingTest.TestAnnotationPainter painter = new LineContentBoundsDrawingTest.TestAnnotationPainter((ISourceViewer)sourceViewer, annotationAccess);
        ((ITextViewerExtension2)sourceViewer).addPainter((IPainter)painter);
        support.install((ISourceViewer)sourceViewer, (AnnotationPainter)painter);
        int annotationIndex = sourceViewer.getDocument().get().indexOf("annotated");
        LineContentAnnotation annotation = new LineContentAnnotation(new Position(annotationIndex, 1), (ISourceViewer)sourceViewer);
        annotation.setText("a");
        support.updateAnnotations(Collections.singleton(annotation));
        this.fParent.open();
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return textWidget.isVisible() && painter.wasPainted();
            }
        }.waitForCondition(textWidget.getDisplay(), 2000L));
        DisplayHelper.sleep((Display)textWidget.getDisplay(), (long)1000L);
        int referenceIndex = textWidget.getText().indexOf("reference");
        Rectangle referenceBounds = textWidget.getTextBounds(referenceIndex, referenceIndex);
        Rectangle annotatedCharactedBounds = textWidget.getTextBounds(annotationIndex, annotationIndex);
        Assert.assertTrue((String)"Annotation didn't shift target character to the right, it most likely replaced the tab instead of expanding it", (referenceBounds.x + referenceBounds.width < annotatedCharactedBounds.x + annotatedCharactedBounds.width ? 1 : 0) != 0);
    }
}

