/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.source.inlined;

import java.util.Collections;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.inlined.InlinedAnnotationSupport;
import org.eclipse.jface.text.source.inlined.LineContentAnnotation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LineContentBoundsDrawingTest {
    private final String text;
    private Shell fParent;

    @Parameterized.Parameters(name="{0}")
    public static String[] contents() {
        return new String[]{"annotation inside text", " annotation just after initial space", "\tannoation just after initial tab"};
    }

    public LineContentBoundsDrawingTest(String text) {
        this.text = text;
    }

    @Before
    public void setUp() {
        this.fParent = new Shell();
    }

    @After
    public void tearDown() {
        this.fParent.dispose();
        this.fParent = null;
    }

    @Test
    public void testTextBoundsMatchPaintedArea() {
        this.fParent.setLayout((Layout)new FillLayout());
        SourceViewer sourceViewer = new SourceViewer((Composite)this.fParent, null, 2560);
        sourceViewer.setDocument((IDocument)new Document(this.text), (IAnnotationModel)new AnnotationModel());
        InlinedAnnotationSupport support = new InlinedAnnotationSupport();
        AccessAllAnnoations annotationAccess = new AccessAllAnnoations();
        final TestAnnotationPainter painter = new TestAnnotationPainter((ISourceViewer)sourceViewer, annotationAccess);
        ((ITextViewerExtension2)sourceViewer).addPainter((IPainter)painter);
        support.install((ISourceViewer)sourceViewer, (AnnotationPainter)painter);
        LineContentAnnotation annotation = new LineContentAnnotation(new Position(1, 1), (ISourceViewer)sourceViewer);
        annotation.setText("longAnnationToDisplayOnTab");
        support.updateAnnotations(Collections.singleton(annotation));
        this.fParent.open();
        final StyledText textWidget = sourceViewer.getTextWidget();
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return textWidget.isVisible() && painter.wasPainted();
            }
        }.waitForCondition(textWidget.getDisplay(), 2000L));
        DisplayHelper.sleep((Display)textWidget.getDisplay(), (long)1000L);
        Rectangle textBounds = textWidget.getTextBounds(0, textWidget.getText().length() - 1);
        int supposedMostRightPaintedPixel = textBounds.x + textBounds.width - 1;
        int mostRightPaintedPixel = this.getMostRightPaintedPixel(textWidget);
        Assert.assertEquals((double)supposedMostRightPaintedPixel, (double)mostRightPaintedPixel, (double)1.5);
    }

    public int getMostRightPaintedPixel(StyledText widget) {
        Image image = new Image((Device)widget.getDisplay(), (gc, width, height) -> {}, widget.getSize().x, widget.getSize().y);
        GC gc2 = new GC((Drawable)widget);
        gc2.copyArea(image, 0, 0);
        gc2.dispose();
        RGB backgroundRgb = widget.getBackground().getRGB();
        ImageData imageData = image.getImageData();
        int x = imageData.width - 50;
        while (x >= 0) {
            int y = 3;
            while (y < imageData.height - 3) {
                if (!imageData.palette.getRGB(imageData.getPixel(x, y)).equals((Object)backgroundRgb)) {
                    image.dispose();
                    return x;
                }
                ++y;
            }
            --x;
        }
        image.dispose();
        return -1;
    }

    public static final class AccessAllAnnoations
    implements IAnnotationAccess {
        public Object getType(Annotation annotation) {
            return annotation.getType();
        }

        public boolean isMultiLine(Annotation annotation) {
            return true;
        }

        public boolean isTemporary(Annotation annotation) {
            return true;
        }
    }

    public static final class TestAnnotationPainter
    extends AnnotationPainter {
        private boolean painted;

        public TestAnnotationPainter(ISourceViewer sourceViewer, IAnnotationAccess access) {
            super(sourceViewer, access);
        }

        public void paint(int reason) {
            this.painted = true;
            super.paint(reason);
        }

        public boolean wasPainted() {
            return this.painted;
        }
    }
}

