/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.jface.databinding.conformance.ObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MutableObservableCollectionContractTest
extends ObservableCollectionContractTest {
    private final IObservableCollectionContractDelegate delegate;
    private IObservableCollection collection;

    public MutableObservableCollectionContractTest(IObservableCollectionContractDelegate delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.collection = (IObservableCollection)super.getObservable();
    }

    @Test
    public void testAdd_ChangeEvent() throws Exception {
        this.assertChangeEventFired(() -> {
            boolean bl = this.collection.add(this.delegate.createElement(this.collection));
        }, "Collection.add(Object)", this.collection);
    }

    @Test
    public void testAdd_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.collection.add(this.delegate.createElement(this.collection));
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testAdd_ChangeEventFiredAfterElementIsAdded() throws Exception {
        Object element = this.delegate.createElement(this.collection);
        this.assertContainsDuringChangeEvent(() -> {
            boolean bl = this.collection.add(element);
        }, "Collection.add(Object)", this.collection, element);
    }

    @Test
    public void testAddAll_ChangeEvent() throws Exception {
        this.assertChangeEventFired(() -> {
            boolean bl = this.collection.addAll(Arrays.asList(this.delegate.createElement(this.collection)));
        }, "Collection.addAll(Collection)", this.collection);
    }

    @Test
    public void testAddAll_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.collection.addAll(Arrays.asList(this.delegate.createElement(this.collection)));
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testAddAll_ChangeEventFiredAfterElementsAreAdded() throws Exception {
        Object element = this.delegate.createElement(this.collection);
        this.assertContainsDuringChangeEvent(() -> {
            boolean bl = this.collection.addAll(Arrays.asList(element));
        }, "Collection.addAll(Collection)", this.collection, element);
    }

    @Test
    public void testRemove_ChangeEvent() throws Exception {
        Object element = this.delegate.createElement(this.collection);
        this.collection.add(element);
        this.assertChangeEventFired(() -> {
            boolean bl = this.collection.remove(element);
        }, "Collection.remove(Object)", this.collection);
    }

    @Test
    public void testRemove_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.collection.remove(this.delegate.createElement(this.collection));
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testRemove_ChangeEventFiredAfterElementIsRemoved() throws Exception {
        Object element = this.delegate.createElement(this.collection);
        this.collection.add(element);
        this.assertDoesNotContainDuringChangeEvent(() -> {
            boolean bl = this.collection.remove(element);
        }, "Collection.remove(Object)", this.collection, element);
    }

    @Test
    public void testRemoveAll_ChangeEvent() throws Exception {
        Object element = this.delegate.createElement(this.collection);
        this.collection.add(element);
        this.assertChangeEventFired(() -> {
            boolean bl = this.collection.removeAll(Arrays.asList(element));
        }, "Collection.removeAll(Collection)", this.collection);
    }

    @Test
    public void testRemoveAll_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.collection.removeAll(Arrays.asList(this.delegate.createElement(this.collection)));
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testRemoveAll_ChangeEventFiredAfterElementsAreRemoved() throws Exception {
        Object element = this.delegate.createElement(this.collection);
        this.collection.add(element);
        this.assertDoesNotContainDuringChangeEvent(() -> {
            boolean bl = this.collection.removeAll(Arrays.asList(element));
        }, "Collection.removeAll(Collection)", this.collection, element);
    }

    @Test
    public void testRemoveAll_NoChange() throws Exception {
        ChangeEventTracker tracker = ChangeEventTracker.observe((IObservable)this.collection);
        this.collection.removeAll((Collection)Collections.EMPTY_LIST);
        Assert.assertEquals((String)"List.removeAll on an empty list should not fire a list change event", (long)0L, (long)tracker.count);
    }

    @Test
    public void testRetainAll_ChangeEvent() throws Exception {
        Object element1 = this.delegate.createElement(this.collection);
        this.collection.add(element1);
        Object element2 = this.delegate.createElement(this.collection);
        this.collection.add(element2);
        this.assertChangeEventFired(() -> {
            boolean bl = this.collection.retainAll(Arrays.asList(element1));
        }, "Collection.retainAll(Collection)", this.collection);
    }

    @Test
    public void testRetainAll_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.collection.retainAll((Collection)Collections.EMPTY_LIST);
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testRetainAll_ChangeEventFiredAfterElementsAreRetained() throws Exception {
        Object element1 = this.delegate.createElement(this.collection);
        this.collection.add(element1);
        Object element2 = this.delegate.createElement(this.collection);
        this.collection.add(element2);
        Assert.assertTrue((boolean)this.collection.contains(element1));
        Assert.assertTrue((boolean)this.collection.contains(element2));
        ContainsListener listener1 = new ContainsListener(this.collection, element1).init();
        ContainsListener listener2 = new ContainsListener(this.collection, element2).init();
        listener1.contains = false;
        listener2.contains = true;
        this.collection.retainAll(Arrays.asList(element1));
        Assert.assertTrue((String)this.formatFail("When Collection.retainAll(...) fires the change event the element should have been retained in the Collection."), (boolean)listener1.contains);
        Assert.assertFalse((String)this.formatFail("When Collection.retainAll(...) fires the change event the element should have been removed from the Collection."), (boolean)listener2.contains);
    }

    @Test
    public void testRetainAll_NoChangeFiresNoChangeEvent() throws Exception {
        ChangeEventTracker tracker = ChangeEventTracker.observe((IObservable)this.collection);
        this.collection.retainAll((Collection)Collections.EMPTY_LIST);
        Assert.assertEquals((String)"List.retainAll should not have fired a change event:", (long)0L, (long)tracker.count);
    }

    @Test
    public void testClear_ChangeEvent() throws Exception {
        this.collection.add(this.delegate.createElement(this.collection));
        this.assertChangeEventFired(() -> this.collection.clear(), "List.clear()", this.collection);
    }

    @Test
    public void testClear_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> this.collection.clear(), (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testClear_ChangeEventFiredAfterElementIsRemoved() throws Exception {
        Object element = this.delegate.createElement(this.collection);
        this.collection.add(element);
        this.assertDoesNotContainDuringChangeEvent(() -> this.collection.clear(), "List.clear()", this.collection, element);
    }

    void assertChangeEventFired(Runnable runnable, String methodName, IObservableCollection collection) {
        ChangeEventTracker listener = ChangeEventTracker.observe((IObservable)collection);
        runnable.run();
        Assert.assertEquals((String)this.formatFail(methodName + " should fire one ChangeEvent."), (long)1L, (long)listener.count);
        Assert.assertEquals((String)this.formatFail(methodName + "'s change event observable should be the created Collection."), (Object)collection, (Object)listener.event.getObservable());
    }

    void assertDoesNotContainDuringChangeEvent(Runnable runnable, String methodName, IObservableCollection collection, Object elementNotContained) {
        Assert.assertTrue((boolean)collection.contains(elementNotContained));
        ContainsListener listener = new ContainsListener(collection, elementNotContained).init();
        listener.contains = true;
        collection.remove(elementNotContained);
        Assert.assertFalse((String)this.formatFail("When " + methodName + " fires a change event the element should have been removed from the Collection."), (boolean)listener.contains);
    }

    void assertContainsDuringChangeEvent(Runnable runnable, String methodName, IObservableCollection collection, Object elementContained) {
        ContainsListener listener = new ContainsListener(collection, elementContained).init();
        Assert.assertFalse((boolean)collection.contains(elementContained));
        runnable.run();
        Assert.assertTrue((String)this.formatFail("When " + methodName + " fires a change event the element should have been added to the Collection."), (boolean)listener.contains);
    }

    static class ContainsListener
    implements IChangeListener {
        boolean contains;
        private final Object element;
        private final IObservableCollection collection;

        ContainsListener(IObservableCollection collection, Object element) {
            this.element = element;
            this.collection = collection;
        }

        ContainsListener init() {
            this.collection.addChangeListener((IChangeListener)this);
            return this;
        }

        public void handleChange(ChangeEvent event) {
            this.contains = this.collection.contains(this.element);
        }
    }
}

