/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.jface.databinding.conformance.MutableObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.SetChangeEventTracker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MutableObservableSetContractTest
extends MutableObservableCollectionContractTest {
    private final IObservableCollectionContractDelegate delegate;
    private IObservableSet set;

    public MutableObservableSetContractTest(IObservableCollectionContractDelegate delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.set = (IObservableSet)this.getObservable();
    }

    @Test
    public void testAdd_SetChangeEvent() throws Exception {
        this.assertSetChangeEventFired(() -> {
            boolean bl = this.set.add(this.delegate.createElement(this.set));
        }, "Set.add(Object)", this.set);
    }

    @Test
    public void testAdd_SetDiffEntry() throws Exception {
        this.set.add(this.delegate.createElement(this.set));
        Object element = this.delegate.createElement(this.set);
        this.assertAddDiffEntry(() -> {
            boolean bl = this.set.add(element);
        }, "Set.add(Object)", this.set, element);
    }

    @Test
    public void testAdd_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            boolean bl = this.set.add(this.delegate.createElement(this.set));
        }, "Set.add(Object)", (IObservable)this.set);
    }

    @Test
    public void testAddAll_SetChangeEvent() throws Exception {
        this.assertSetChangeEventFired(() -> {
            boolean bl = this.set.addAll(Arrays.asList(this.delegate.createElement(this.set)));
        }, "Set.addAll(Collection", this.set);
    }

    @Test
    public void testAddAll_SetDiffEntry() throws Exception {
        Object element = this.delegate.createElement(this.set);
        this.assertAddDiffEntry(() -> {
            boolean bl = this.set.addAll(Arrays.asList(element));
        }, "Set.addAll(Collection)", this.set, element);
    }

    @Test
    public void testAddAll_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            boolean bl = this.set.addAll(Collections.singleton(this.delegate.createElement(this.set)));
        }, "Set.addAll(Collection)", (IObservable)this.set);
    }

    @Test
    public void testRemove_SetChangeEvent() throws Exception {
        Object element = this.delegate.createElement(this.set);
        this.set.add(element);
        this.assertSetChangeEventFired(() -> {
            boolean bl = this.set.remove(element);
        }, "Set.remove(Object)", this.set);
    }

    @Test
    public void testRemove_SetDiffEntry() throws Exception {
        this.set.add(this.delegate.createElement(this.set));
        Object element = this.delegate.createElement(this.set);
        this.set.add(element);
        this.assertRemoveDiffEntry(() -> {
            boolean bl = this.set.remove(element);
        }, "Set.remove(Object)", this.set, element);
    }

    @Test
    public void testRemove_GetterCalled() throws Exception {
        Object element = this.delegate.createElement(this.set);
        this.set.add(element);
        this.assertGetterCalled(() -> {
            boolean bl = this.set.remove(element);
        }, "Set.remove(Object)", (IObservable)this.set);
    }

    @Test
    public void testRemoveAll_SetChangeEvent() throws Exception {
        Object element = this.delegate.createElement(this.set);
        this.set.add(element);
        this.assertSetChangeEventFired(() -> {
            boolean bl = this.set.removeAll(Arrays.asList(element));
        }, "Set.removeAll(Collection)", this.set);
    }

    @Test
    public void testRemoveAll_SetDiffEntry() throws Exception {
        Object element = this.delegate.createElement(this.set);
        this.set.add(element);
        this.assertRemoveDiffEntry(() -> {
            boolean bl = this.set.removeAll(Arrays.asList(element));
        }, "Set.removeAll(Collection)", this.set, element);
    }

    @Test
    public void testRemoveAll_GetterCalled() throws Exception {
        Object element = this.delegate.createElement(this.set);
        this.set.add(element);
        this.assertGetterCalled(() -> {
            boolean bl = this.set.removeAll(Collections.singleton(element));
        }, "Set.removeAll(Collection)", (IObservable)this.set);
    }

    @Test
    public void testRetainAll_SetChangeEvent() throws Exception {
        Object element1 = this.delegate.createElement(this.set);
        this.set.add(element1);
        this.set.add(this.delegate.createElement(this.set));
        this.assertSetChangeEventFired(() -> {
            boolean bl = this.set.retainAll(Arrays.asList(element1));
        }, "Set.retainAll(Collection", this.set);
    }

    @Test
    public void testRetainAll_SetDiffEntry() throws Exception {
        Object element1 = this.delegate.createElement(this.set);
        this.set.add(element1);
        Object element2 = this.delegate.createElement(this.set);
        this.set.add(element2);
        this.assertRemoveDiffEntry(() -> {
            boolean bl = this.set.retainAll(Arrays.asList(element1));
        }, "Set.retainAll(Collection)", this.set, element2);
    }

    @Test
    public void testRetainAll_GetterCalled() throws Exception {
        this.set.add(this.delegate.createElement(this.set));
        this.assertGetterCalled(() -> {
            boolean bl = this.set.retainAll((Collection)Collections.EMPTY_SET);
        }, "Set.retainAll(Collection)", (IObservable)this.set);
    }

    @Test
    public void testClear_SetChangeEvent() throws Exception {
        this.set.add(this.delegate.createElement(this.set));
        this.assertSetChangeEventFired(() -> this.set.clear(), "Set.clear()", this.set);
    }

    @Test
    public void testClear_SetDiffEntry() throws Exception {
        Object element = this.delegate.createElement(this.set);
        this.set.add(element);
        this.assertRemoveDiffEntry(() -> this.set.clear(), "Set.clear()", this.set, element);
    }

    @Test
    public void testClear_GetterCalled() throws Exception {
        this.set.add(this.delegate.createElement(this.set));
        this.assertGetterCalled(() -> this.set.clear(), "Set.clear()", (IObservable)this.set);
    }

    private void assertSetChangeEventFired(Runnable runnable, String methodName, IObservableSet set) {
        ArrayList<IObservablesListener> queue = new ArrayList<IObservablesListener>();
        SetChangeEventTracker setListener = new SetChangeEventTracker(queue);
        ChangeEventTracker changeListener = new ChangeEventTracker(queue);
        set.addSetChangeListener((ISetChangeListener)setListener);
        set.addChangeListener((IChangeListener)changeListener);
        runnable.run();
        Assert.assertEquals((String)this.formatFail(methodName + " should fire one SetChangeEvent."), (long)1L, (long)setListener.count);
        Assert.assertEquals((String)this.formatFail(methodName + "'s change event observable should be the created Set."), (Object)set, (Object)setListener.event.getObservable());
        Assert.assertEquals((String)this.formatFail("Two notifications should have been received."), (long)2L, (long)queue.size());
        Assert.assertEquals((String)this.formatFail("ChangeEvent of " + methodName + " should have fired before the SetChangeEvent."), (Object)changeListener, queue.get(0));
        Assert.assertEquals((String)this.formatFail("SetChangeEvent of " + methodName + " should have fired after the ChangeEvent."), (Object)setListener, queue.get(1));
    }

    private void assertAddDiffEntry(Runnable runnable, String methodName, IObservableSet set, Object element) {
        SetChangeEventTracker listener = new SetChangeEventTracker();
        set.addSetChangeListener((ISetChangeListener)listener);
        runnable.run();
        Set entries = listener.event.diff.getAdditions();
        Assert.assertEquals((String)this.formatFail(methodName + " should result in one diff entry."), (long)1L, (long)entries.size());
        Assert.assertTrue((String)this.formatFail(methodName + " should result in a diff entry that is an addition."), (boolean)entries.contains(element));
    }

    private void assertRemoveDiffEntry(Runnable runnable, String methodName, IObservableSet set, Object element) {
        SetChangeEventTracker listener = new SetChangeEventTracker();
        set.addSetChangeListener((ISetChangeListener)listener);
        runnable.run();
        Set entries = listener.event.diff.getRemovals();
        Assert.assertEquals((String)this.formatFail(methodName + " should result in one diff entry."), (long)1L, (long)entries.size());
        Assert.assertTrue((String)this.formatFail(methodName + " should result in a diff entry that is a removal."), (boolean)entries.contains(element));
    }
}

