/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MutableObservableValueContractTest
extends ObservableValueContractTest {
    private final IObservableValueContractDelegate delegate;
    private IObservableValue observable;

    public MutableObservableValueContractTest(IObservableValueContractDelegate delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.observable = (IObservableValue)this.getObservable();
    }

    @Test
    public void testSetValue_SetsValue() throws Exception {
        Object value = this.delegate.createValue(this.observable);
        this.observable.setValue(value);
        Assert.assertEquals((String)this.formatFail("IObservableValue.setValue(Object) should set the value of the observable."), (Object)value, (Object)this.observable.getValue());
    }

    @Test
    public void testSetValue_ChangeEvent() throws Exception {
        ChangeEventTracker listener = ChangeEventTracker.observe((IObservable)this.observable);
        this.observable.setValue(this.delegate.createValue(this.observable));
        Assert.assertEquals((String)this.formatFail("Change event listeners were not notified"), (long)1L, (long)listener.count);
        Assert.assertEquals((String)this.formatFail("IObservableValue.setValue(Object) should fire one ChangeEvent."), (long)1L, (long)listener.count);
        Assert.assertEquals((String)this.formatFail("IObservableValue.setValue(Object)'s change event observable should be the created observable."), (Object)this.observable, (Object)listener.event.getObservable());
    }

    @Test
    public void testSetValue_SameValue() throws Exception {
        this.delegate.change((IObservable)this.observable);
        ValueChangeEventTracker valueChangeListener = ValueChangeEventTracker.observe(this.observable);
        ChangeEventTracker changeListener = ChangeEventTracker.observe((IObservable)this.observable);
        Object value = this.observable.getValue();
        this.observable.setValue(value);
        Assert.assertEquals((String)this.formatFail("IObservableValue.setValue() should not fire a value change event when the value has not change."), (long)0L, (long)valueChangeListener.count);
        Assert.assertEquals((String)this.formatFail("IObservableValue.setValue() should not fire a change event when the value has not change."), (long)0L, (long)changeListener.count);
    }

    @Test
    public void testSetValue_RealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> this.observable.setValue(this.delegate.createValue(this.observable)), (CurrentRealm)this.observable.getRealm());
    }
}

