/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.jface.databinding.conformance.ObservableContractTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservableCollectionContractTest
extends ObservableContractTest {
    private final IObservableCollectionContractDelegate delegate;
    private IObservableCollection collection;

    public ObservableCollectionContractTest(IObservableCollectionContractDelegate delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.collection = (IObservableCollection)this.getObservable();
    }

    @Test
    public void testIterator_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            Iterator iterator = this.collection.iterator();
        }, "Collection.iterator()", (IObservable)this.collection);
    }

    @Test
    public void testIterator_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            Iterator iterator = this.collection.iterator();
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testSize_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            int n = this.collection.size();
        }, "Collection.size()", (IObservable)this.collection);
    }

    @Test
    public void testSize_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            int n = this.collection.size();
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testIsEmpty_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            boolean bl = this.collection.isEmpty();
        }, "Collection.isEmpty()", (IObservable)this.collection);
    }

    @Test
    public void testIsEmpty_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.collection.isEmpty();
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testContains_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            boolean bl = this.collection.contains(this.delegate.createElement(this.collection));
        }, "Collection.contains(...)", (IObservable)this.collection);
    }

    @Test
    public void testContains_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.collection.contains(this.delegate.createElement(this.collection));
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testContainsAll_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            boolean bl = this.collection.containsAll(Arrays.asList(this.delegate.createElement(this.collection)));
        }, "Collection.containsAll(Collection)", (IObservable)this.collection);
    }

    @Test
    public void testContainsAll_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.collection.containsAll(Arrays.asList(this.delegate.createElement(this.collection)));
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testToArray_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            Object[] objectArray = this.collection.toArray();
        }, "Collection.toArray()", (IObservable)this.collection);
    }

    @Test
    public void testToArray_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            Object[] objectArray = this.collection.toArray();
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testToArrayWithObjectArray_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            Object[] objectArray = this.collection.toArray(new Object[this.collection.size()]);
        }, "Collection.toArray(Object[])", (IObservable)this.collection);
    }

    @Test
    public void testToArrayWithObjectArray_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            Object[] objectArray = this.collection.toArray(new Object[this.collection.size()]);
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testEquals_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            boolean bl = this.collection.equals((Object)this.collection);
        }, "Collection.equals(Object)", (IObservable)this.collection);
    }

    @Test
    public void testEquals_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.collection.equals((Object)this.collection);
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testEquals_IdentityEquals() throws Exception {
        Assert.assertTrue((boolean)this.collection.equals((Object)this.collection));
    }

    @Test
    public void testHashCode_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            int n = this.collection.hashCode();
        }, "Collection.hashCode()", (IObservable)this.collection);
    }

    @Test
    public void testHashCode_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            int n = this.collection.hashCode();
        }, (CurrentRealm)this.collection.getRealm());
    }

    @Test
    public void testGetElementType_ReturnsType() throws Exception {
        Assert.assertEquals((String)"Element type of the collection should be returned from IObservableCollection.getElementType()", (Object)this.delegate.getElementType(this.collection), (Object)this.collection.getElementType());
    }
}

