/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservableContractTest
extends ObservableDelegateTest {
    private IObservable observable;
    private final IObservableContractDelegate delegate;

    public ObservableContractTest(IObservableContractDelegate delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.observable = this.getObservable();
    }

    @Test
    public void testConstruction_CallsObservableCreated() {
        IObservable[] created = new IObservable[1];
        IObservable[] collected = ObservableTracker.runAndCollect(() -> {
            IObservable iObservable = this.delegate.createObservable(new CurrentRealm(true));
        });
        Assert.assertTrue((collected.length > 0 ? 1 : 0) != 0);
        boolean wasCollected = false;
        IObservable[] iObservableArray = collected;
        int n = collected.length;
        int n2 = 0;
        while (n2 < n) {
            IObservable c = iObservableArray[n2];
            if (c == created[0]) {
                wasCollected = true;
                break;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)wasCollected);
    }

    @Test
    public void testGetRealm_NotNull() throws Exception {
        Assert.assertNotNull((String)this.formatFail("The observable's realm should not be null."), (Object)this.observable.getRealm());
    }

    @Test
    public void testChange_ChangeEvent() throws Exception {
        ChangeListener listener = new ChangeListener();
        this.observable.addChangeListener((IChangeListener)listener);
        this.delegate.change(this.observable);
        Assert.assertEquals((String)this.formatFail("A change in the observable should notify change listeners."), (long)1L, (long)listener.count);
    }

    @Test
    public void testChange_EventObservable() throws Exception {
        ChangeListener listener = new ChangeListener();
        this.observable.addChangeListener((IChangeListener)listener);
        this.delegate.change(this.observable);
        ChangeEvent event = listener.event;
        Assert.assertNotNull((String)this.formatFail("change event was null"), (Object)event);
        Assert.assertSame((String)this.formatFail("In the change event the source of the change should be the observable."), (Object)this.observable, (Object)event.getObservable());
    }

    @Test
    public void testChange_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> this.delegate.change(this.observable), (CurrentRealm)this.observable.getRealm());
    }

    @Test
    public void testChange_ObservableRealmIsTheCurrentRealm() throws Exception {
        ChangeListener listener = new ChangeListener();
        this.observable.addChangeListener((IChangeListener)listener);
        this.delegate.change(this.observable);
        Assert.assertTrue((String)this.formatFail("On change the current realm should be the realm of the observable."), (boolean)listener.isCurrentRealm);
    }

    @Test
    public void testRemoveChangeListener_RemovesListener() throws Exception {
        ChangeListener listener = new ChangeListener();
        this.observable.addChangeListener((IChangeListener)listener);
        this.delegate.change(this.observable);
        Assert.assertEquals((String)this.formatFail("change did not notify listeners"), (long)1L, (long)listener.count);
        this.observable.removeChangeListener((IChangeListener)listener);
        this.delegate.change(this.observable);
        Assert.assertEquals((String)this.formatFail("When a change listener is removed it should not still receive change events."), (long)1L, (long)listener.count);
    }

    @Test
    public void testIsStale_NotStale() throws Exception {
        this.delegate.setStale(this.observable, false);
        Assert.assertFalse((String)this.formatFail("When an observable is not stale isStale() should return false."), (boolean)this.observable.isStale());
    }

    @Test
    public void testIsStale_RealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.observable.isStale();
        }, (CurrentRealm)this.observable.getRealm());
    }

    @Test
    public void testIsStale_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            boolean bl = this.observable.isStale();
        }, "isStale", this.observable);
    }

    @Test
    public void testIsDisposed() throws Exception {
        Assert.assertFalse((boolean)this.observable.isDisposed());
        this.observable.dispose();
        Assert.assertTrue((boolean)this.observable.isDisposed());
    }

    @Test
    public void testAddDisposeListener_HandleDisposeInvoked() {
        DisposeEventTracker tracker = DisposeEventTracker.observe(this.observable);
        Assert.assertEquals((long)0L, (long)tracker.count);
        this.observable.dispose();
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertSame((Object)this.observable, (Object)tracker.event.getSource());
    }

    @Test
    public void testHandleDispose_IsDisposedTrue() {
        this.observable.addDisposeListener(staleEvent -> Assert.assertTrue((boolean)this.observable.isDisposed()));
        this.observable.dispose();
    }

    @Test
    public void testDispose_RemovesListeners() throws Exception {
        ChangeListener disposedObservableListener = new ChangeListener();
        Realm realm = this.observable.getRealm();
        this.observable.addChangeListener((IChangeListener)disposedObservableListener);
        this.observable.dispose();
        this.observable = this.delegate.createObservable(realm);
        this.delegate.change(this.observable);
        Assert.assertEquals((String)this.formatFail("After being disposed listeners should not receive change events."), (long)0L, (long)disposedObservableListener.count);
    }

    @Test
    public void testDispose_PreservesRealm() throws Exception {
        Realm realm = this.observable.getRealm();
        this.observable.dispose();
        Assert.assertSame((Object)realm, (Object)this.observable.getRealm());
    }

    static class ChangeListener
    implements IChangeListener {
        int count;
        ChangeEvent event;
        boolean isCurrentRealm;

        ChangeListener() {
        }

        public void handleChange(ChangeEvent event) {
            ++this.count;
            this.event = event;
            this.isCurrentRealm = event.getObservable().getRealm().isCurrent();
        }
    }
}

