/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class ObservableDelegateTest {
    private final IObservableContractDelegate delegate;
    private Realm previousRealm;
    private IObservable observable;
    private String debugInfo;

    public ObservableDelegateTest(IObservableContractDelegate delegate) {
        this.delegate = delegate;
    }

    @Before
    public void setUp() throws Exception {
        this.previousRealm = Realm.getDefault();
        this.delegate.setUp();
        this.observable = this.doCreateObservable();
    }

    @After
    public void tearDown() throws Exception {
        this.delegate.tearDown();
        this.observable.dispose();
        this.observable = null;
        RealmTester.setDefault(this.previousRealm);
        this.observable = null;
        this.previousRealm = null;
    }

    protected IObservable doCreateObservable() {
        return this.delegate.createObservable(new CurrentRealm(true));
    }

    protected IObservable getObservable() {
        return this.observable;
    }

    protected IObservableContractDelegate getObservableContractDelegate() {
        return this.delegate;
    }

    protected String formatFail(String message) {
        return message + this.getDebugString();
    }

    private String getDebugString() {
        if (this.debugInfo == null) {
            this.debugInfo = "(Test: " + this.getClass().getName() + ", Delegate: " + this.delegate.getClass().getName() + ")";
        }
        return this.debugInfo;
    }

    protected void assertGetterCalled(Runnable runnable, String methodName, IObservable observable) {
        IObservable[] observables = ObservableTracker.runAndMonitor((Runnable)runnable, null, null);
        int count = 0;
        IObservable[] iObservableArray = observables;
        int n = observables.length;
        int n2 = 0;
        while (n2 < n) {
            IObservable o = iObservableArray[n2];
            if (o == observable) {
                ++count;
            }
            ++n2;
        }
        Assert.assertEquals((String)this.formatFail(methodName + " should invoke ObservableTracker.getterCalled() once."), (long)1L, (long)count);
    }
}

