/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.databinding.conformance.ObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.junit.Before;
import org.junit.Test;

public class ObservableListContractTest
extends ObservableCollectionContractTest {
    private IObservableList list;
    private final IObservableCollectionContractDelegate delegate;

    public ObservableListContractTest(IObservableCollectionContractDelegate delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.list = (IObservableList)this.getObservable();
    }

    @Test
    public void testListIterator_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            ListIterator listIterator = this.list.listIterator();
        }, "List.listIterator()", (IObservable)this.list);
    }

    @Test
    public void testGet_GetterCalled() throws Exception {
        this.list = (IObservableList)this.delegate.createObservableCollection(new CurrentRealm(true), 1);
        this.assertGetterCalled(() -> {
            Object object = this.list.get(0);
        }, "List.get(int)", (IObservable)this.list);
    }

    @Test
    public void testIndexOf_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            int n = this.list.indexOf(this.delegate.createElement(this.list));
        }, "List.indexOf(int)", (IObservable)this.list);
    }

    @Test
    public void testLastIndexOf_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            int n = this.list.lastIndexOf(this.delegate.createElement(this.list));
        }, "List.lastIndexOf(Object)", (IObservable)this.list);
    }

    @Test
    public void testListIteratorAtIndex_GetterCalled() throws Exception {
        this.list = (IObservableList)this.delegate.createObservableCollection(new CurrentRealm(true), 1);
        this.assertGetterCalled(() -> {
            ListIterator listIterator = this.list.listIterator(0);
        }, "List.listIterator(int)", (IObservable)this.list);
    }

    @Test
    public void testSubList_GetterCalled() throws Exception {
        this.list = (IObservableList)this.delegate.createObservableCollection(new CurrentRealm(true), 1);
        this.assertGetterCalled(() -> {
            List list = this.list.subList(0, 1);
        }, "List.subList(int, int)", (IObservable)this.list);
    }
}

